<?php
// Application Configuration
define('APP_NAME', 'Bulk AI Writer');
define('APP_VERSION', '1.0');
define('MAX_TOPICS', 100);
define('DEFAULT_WORD_COUNT', 1000);

// Session Configuration
session_start();

// Security Headers
header("X-Frame-Options: DENY");
header("X-Content-Type-Options: nosniff");
header("X-XSS-Protection: 1; mode=block");

// CORS Headers (if needed)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 0); // Set to 1 for debugging

// User data file
define('USERS_FILE', 'users.json');

// Initialize users file if it doesn't exist
if (!file_exists(USERS_FILE)) {
    file_put_contents(USERS_FILE, json_encode([]));
}

// Helper functions
function sanitize_input($data) {
    return htmlspecialchars(strip_tags(trim($data)), ENT_QUOTES, 'UTF-8');
}

function is_logged_in() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

function redirect($url) {
    header("Location: $url");
    exit;
}
?>