<?php
require_once 'config.php';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['register'])) {
        $username = sanitize_input($_POST['username']);
        $email = sanitize_input($_POST['email']);
        $password = $_POST['password'];
        $confirm_password = $_POST['confirm_password'];
        
        // Validation
        if (empty($username) || empty($email) || empty($password)) {
            $error = "All fields are required";
        } elseif ($password !== $confirm_password) {
            $error = "Passwords do not match";
        } elseif (strlen($password) < 6) {
            $error = "Password must be at least 6 characters";
        } else {
            // Check if user exists
            $users = json_decode(file_get_contents(USERS_FILE), true);
            
            foreach ($users as $user) {
                if ($user['email'] === $email) {
                    $error = "Email already registered";
                    break;
                }
                if ($user['username'] === $username) {
                    $error = "Username already taken";
                    break;
                }
            }
            
            if (!isset($error)) {
                // Create new user
                $new_user = [
                    'id' => uniqid(),
                    'username' => $username,
                    'email' => $email,
                    'password' => password_hash($password, PASSWORD_DEFAULT),
                    'created_at' => date('Y-m-d H:i:s'),
                    'api_key' => ''
                ];
                
                $users[] = $new_user;
                file_put_contents(USERS_FILE, json_encode($users, JSON_PRETTY_PRINT));
                
                $_SESSION['user_id'] = $new_user['id'];
                $_SESSION['username'] = $username;
                redirect('bulkwriter.php');
            }
        }
    }
    
    if (isset($_POST['login'])) {
        $email = sanitize_input($_POST['email']);
        $password = $_POST['password'];
        
        $users = json_decode(file_get_contents(USERS_FILE), true);
        
        foreach ($users as $user) {
            if ($user['email'] === $email && password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                redirect('bulkwriter.php');
            }
        }
        
        $error = "Invalid email or password";
    }
}

// Redirect if already logged in
if (is_logged_in()) {
    redirect('bulkwriter.php');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.9.96/css/materialdesignicons.min.css" rel="stylesheet">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1><i class="mdi mdi-pencil-box-multiple"></i> <?php echo APP_NAME; ?></h1>
                <p>Generate high-quality, human-like content at scale</p>
            </div>
            
            <?php if (isset($error)): ?>
                <div class="alert alert-error">
                    <i class="mdi mdi-alert-circle"></i>
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>
            
            <div class="auth-tabs">
                <button class="tab-button active" data-tab="login">Login</button>
                <button class="tab-button" data-tab="register">Register</button>
            </div>
            
            <div class="tab-content active" id="login-tab">
                <form method="POST" class="auth-form">
                    <input type="hidden" name="login" value="1">
                    <div class="form-group">
                        <label for="login-email">Email</label>
                        <input type="email" id="login-email" name="email" required>
                        <i class="mdi mdi-email"></i>
                    </div>
                    <div class="form-group">
                        <label for="login-password">Password</label>
                        <input type="password" id="login-password" name="password" required>
                        <i class="mdi mdi-lock"></i>
                    </div>
                    <button type="submit" class="btn btn-primary btn-full">
                        <i class="mdi mdi-login"></i> Sign In
                    </button>
                </form>
            </div>
            
            <div class="tab-content" id="register-tab">
                <form method="POST" class="auth-form">
                    <input type="hidden" name="register" value="1">
                    <div class="form-group">
                        <label for="register-username">Username</label>
                        <input type="text" id="register-username" name="username" required>
                        <i class="mdi mdi-account"></i>
                    </div>
                    <div class="form-group">
                        <label for="register-email">Email</label>
                        <input type="email" id="register-email" name="email" required>
                        <i class="mdi mdi-email"></i>
                    </div>
                    <div class="form-group">
                        <label for="register-password">Password</label>
                        <input type="password" id="register-password" name="password" required>
                        <i class="mdi mdi-lock"></i>
                    </div>
                    <div class="form-group">
                        <label for="register-confirm">Confirm Password</label>
                        <input type="password" id="register-confirm" name="confirm_password" required>
                        <i class="mdi mdi-lock-check"></i>
                    </div>
                    <button type="submit" class="btn btn-primary btn-full">
                        <i class="mdi mdi-account-plus"></i> Create Account
                    </button>
                </form>
            </div>
        </div>
        
        <div class="auth-features">
            <div class="feature">
                <i class="mdi mdi-robot"></i>
                <h3>AI-Powered</h3>
                <p>Advanced AI that generates human-like content</p>
            </div>
            <div class="feature">
                <i class="mdi mdi-bulkwriter"></i>
                <h3>Bulk Generation</h3>
                <p>Create multiple articles simultaneously</p>
            </div>
            <div class="feature">
                <i class="mdi mdi-shield-check"></i>
                <h3>AI Detection Bypass</h3>
                <p>Content that passes AI detection tools</p>
            </div>
        </div>
    </div>
    
    <script src="script.js"></script>
</body>
</html>