<?php
require_once 'config.php';

if (!is_logged_in()) {
    redirect('index.php');
}

// Get user data
$users = json_decode(file_get_contents(USERS_FILE), true);
$current_user = null;
foreach ($users as $user) {
    if ($user['id'] === $_SESSION['user_id']) {
        $current_user = $user;
        break;
    }
}

if (!$current_user) {
    session_destroy();
    redirect('index.php');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulk Content Writer - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.9.96/css/materialdesignicons.min.css" rel="stylesheet">
    <!-- In the head section, add this -->
<script src="ai/ai.js"></script>
<script src="bulkwriter.js"></script>
<script src="script.js"></script>
</head>
<body>
    <!-- Navigation Header -->
    <nav class="navbar">
        <div class="nav-brand">
            <i class="mdi mdi-pencil-box-multiple"></i>
            <span><?php echo APP_NAME; ?></span>
        </div>
        
        <div class="nav-controls">
            <div class="theme-toggle">
                <input type="checkbox" id="theme-switch" class="theme-switch">
                <label for="theme-switch" class="theme-label">
                    <i class="mdi mdi-weather-sunny"></i>
                    <i class="mdi mdi-weather-night"></i>
                </label>
            </div>
            
            <div class="user-menu">
                <button class="user-btn">
                    <i class="mdi mdi-account-circle"></i>
                    <span><?php echo htmlspecialchars($current_user['username']); ?></span>
                    <i class="mdi mdi-chevron-down"></i>
                </button>
                <div class="user-dropdown">
                    <a href="#" class="dropdown-item">
                        <i class="mdi mdi-cog"></i> Settings
                    </a>
                    <a href="#" class="dropdown-item" id="api-settings-btn">
                        <i class="mdi mdi-key"></i> API Settings
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="logout.php" class="dropdown-item">
                        <i class="mdi mdi-logout"></i> Logout
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        <div class="container-fluid">
            <!-- Page Header -->
            <div class="page-header">
                <h1>Bulk Content Generator</h1>
                <p>Generate high-quality, SEO-optimized content for multiple topics simultaneously</p>
            </div>

            <!-- API Settings Modal -->
            <div id="api-settings-modal" class="modal">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2>API Configuration</h2>
                        <button class="modal-close">&times;</button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="api-key">AI API Key</label>
                            <input type="password" id="api-key" placeholder="Enter your API key (without AIzaSy prefix)" 
                                   value="<?php echo substr($current_user['api_key'] ?? '', 6); ?>">
                            <small>We'll automatically add the "AIzaSy" prefix for security</small>
                        </div>
                        <div class="form-actions">
                            <button type="button" class="btn btn-secondary" id="close-api-modal">Cancel</button>
                            <button type="button" class="btn btn-primary" id="save-api-key">Save API Key</button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Content Generation Form -->
            <div class="generation-form">
                <div class="form-section">
                    <div class="section-header">
                        <h3><i class="mdi mdi-format-list-bulleted"></i> Content Topics</h3>
                        <button type="button" class="btn btn-outline" id="add-topic-btn">
                            <i class="mdi mdi-plus"></i> Add Topic
                        </button>
                    </div>
                    
                    <div id="topics-container">
                        <div class="topic-row">
                            <div class="form-group">
                                <label>Topic/Title</label>
                                <input type="text" class="topic-input" placeholder="Enter topic or title">
                            </div>
                            <div class="form-group">
                                <label>Word Count</label>
                                <input type="number" class="word-count-input" value="1000" min="100" max="5000">
                            </div>
                            <button type="button" class="btn btn-danger btn-icon remove-topic" style="display: none;">
                                <i class="mdi mdi-delete"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <div class="form-section">
                    <div class="section-header">
                        <h3><i class="mdi mdi-tune"></i> Content Settings</h3>
                    </div>
                    
                    <div class="settings-grid">
                        <div class="form-group">
                            <label for="content-type">Content Type</label>
                            <select id="content-type">
                                <option value="Articles">Articles</option>
                                <option value="Blog Posts">Blog Posts</option>
                                <option value="Listicles">Listicles</option>
                                <option value="News Posts">News Posts</option>
                                <option value="Product Descriptions">Product Descriptions</option>
                                <option value="Social Media Posts">Social Media Posts</option>
                                <option value="Email Newsletters">Email Newsletters</option>
                                <option value="Press Releases">Press Releases</option>
                                <option value="Case Studies">Case Studies</option>
                                <option value="White Papers">White Papers</option>
                                <option value="How-To Guides">How-To Guides</option>
                                <option value="Tutorials">Tutorials</option>
                                <option value="FAQs">FAQs</option>
                                <option value="Landing Pages">Landing Pages</option>
                                <option value="About Us Pages">About Us Pages</option>
                                <option value="Mission Statements">Mission Statements</option>
                                <option value="Video Scripts">Video Scripts</option>
                                <option value="Podcast Outlines">Podcast Outlines</option>
                                <option value="Interview Questions">Interview Questions</option>
                                <option value="Book Summaries">Book Summaries</option>
                                <option value="Research Papers">Research Papers</option>
                                <option value="Business Proposals">Business Proposals</option>
                                <option value="Meeting Agendas">Meeting Agendas</option>
                                <option value="Job Descriptions">Job Descriptions</option>
                                <option value="Resume Bullet Points">Resume Bullet Points</option>
                                <option value="Cover Letters">Cover Letters</option>
                                <option value="Advertising Copy">Advertising Copy</option>
                                <option value="Meta Descriptions">Meta Descriptions</option>
                                <option value="Instagram Captions">Instagram Captions</option>
                                <option value="Twitter Threads">Twitter Threads</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="tone-voice">Tone/Voice</label>
                            <select id="tone-voice">
                                <option value="Professional">Professional</option>
                                <option value="Casual">Casual</option>
                                <option value="Friendly">Friendly</option>
                                <option value="Formal">Formal</option>
                                <option value="Authoritative">Authoritative</option>
                                <option value="Conversational">Conversational</option>
                                <option value="Humorous">Humorous</option>
                                <option value="Witty">Witty</option>
                                <option value="Sarcastic">Sarcastic</option>
                                <option value="Empathetic">Empathetic</option>
                                <option value="Persuasive">Persuasive</option>
                                <option value="Inspirational">Inspirational</option>
                                <option value="Confident">Confident</option>
                                <option value="Neutral">Neutral</option>
                                <option value="Academic">Academic</option>
                                <option value="Technical">Technical</option>
                                <option value="Storytelling">Storytelling</option>
                                <option value="Dramatic">Dramatic</option>
                                <option value="Optimistic">Optimistic</option>
                                <option value="Urgent">Urgent</option>
                                <option value="Calming">Calming</option>
                                <option value="Corporate">Corporate</option>
                                <option value="Salesy">Salesy</option>
                                <option value="Educational">Educational</option>
                                <option value="Youthful">Youthful</option>
                                <option value="Sophisticated">Sophisticated</option>
                                <option value="Bold">Bold</option>
                                <option value="Conservative">Conservative</option>
                                <option value="Creative">Creative</option>
                                <option value="Minimalist">Minimalist</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="ai-persona">AI Writer Persona</label>
                            <select id="ai-persona">
                                <option value="Lily SEO">Lily SEO</option>
                                <option value="Technical Expert">Technical Expert</option>
                                <option value="Creative Writer">Creative Writer</option>
                                <option value="Business Analyst">Business Analyst</option>
                                <option value="Marketing Guru">Marketing Guru</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="target-audience">Target Audience</label>
                            <input type="text" id="target-audience" placeholder="e.g., Small business owners, Tech enthusiasts">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="focus-keyword">Focus Keyword</label>
                        <input type="text" id="focus-keyword" placeholder="Primary keyword for SEO">
                    </div>
                    
                    <div class="form-group">
                        <label for="other-keywords">Other Keywords</label>
                        <textarea id="other-keywords" placeholder="Secondary keywords (comma-separated)"></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label for="custom-prompt">Custom Prompt (Optional)</label>
                        <textarea id="custom-prompt" placeholder="Override default prompt with your own instructions"></textarea>
                    </div>
                </div>

                <div class="form-section">
                    <div class="section-header">
                        <h3><i class="mdi mdi-puzzle"></i> Content Add-ins</h3>
                    </div>
                    
                    <div class="addins-grid">
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="statistics">
                            <span class="checkmark"></span>
                            Statistics
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="quotes">
                            <span class="checkmark"></span>
                            Quotes
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="numbers">
                            <span class="checkmark"></span>
                            Numbers/Quantities
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="percentages">
                            <span class="checkmark"></span>
                            Percentages
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="examples">
                            <span class="checkmark"></span>
                            Examples
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="analogies">
                            <span class="checkmark"></span>
                            Analogies
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="sources">
                            <span class="checkmark"></span>
                            Sources
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="bullet-points">
                            <span class="checkmark"></span>
                            Bullet Points
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="lists">
                            <span class="checkmark"></span>
                            Lists
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="case-studies">
                            <span class="checkmark"></span>
                            Case Studies
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="comparisons">
                            <span class="checkmark"></span>
                            Comparisons
                        </label>
                        <label class="checkbox-label">
                            <input type="checkbox" name="addins" value="definitions">
                            <span class="checkmark"></span>
                            Definitions
                        </label>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="button" class="btn btn-primary btn-lg" id="generate-all-btn">
                        <i class="mdi mdi-robot"></i> Generate All Content
                    </button>
                    <button type="button" class="btn btn-secondary btn-lg" id="export-all-btn" disabled>
                        <i class="mdi mdi-download"></i> Export All as .doc
                    </button>
                </div>
            </div>

            <!-- Results Section -->
            <div id="results-section" class="results-section" style="display: none;">
                <div class="section-header">
                    <h3><i class="mdi mdi-text-box-check"></i> Generated Content</h3>
                    <div class="results-stats">
                        <span id="completed-count">0</span> / <span id="total-count">0</span> Completed
                    </div>
                </div>
                
                <div id="results-container">
                    <!-- Generated articles will appear here -->
                </div>
            </div>
        </div>
    </main>

    <!-- Loading Overlay -->
    <div id="loading-overlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <h3>Generating Content</h3>
            <p>Please wait while we create your high-quality articles...</p>
            <div class="progress-bar">
                <div class="progress-fill" id="global-progress"></div>
            </div>
            <div class="progress-text" id="progress-text">Starting...</div>
        </div>
    </div>

    <script src="bulkwriter.js"></script>
    <script src="script.js"></script>
</body>
</html>