<?php
require_once 'config.php';

if (!is_logged_in()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $users = json_decode(file_get_contents(USERS_FILE), true);
    $user_id = $_SESSION['user_id'];
    
    // Remove user from users array
    $users = array_filter($users, function($user) use ($user_id) {
        return $user['id'] !== $user_id;
    });
    
    // Reindex array
    $users = array_values($users);
    
    // Save updated users list
    file_put_contents(USERS_FILE, json_encode($users, JSON_PRETTY_PRINT));
    
    // Destroy session
    session_destroy();
    
    echo json_encode(['success' => true, 'message' => 'Account deleted successfully']);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
}
?>