<?php
require_once 'config.php';

if (!is_logged_in()) {
    http_response_code(401);
    echo json_encode(['api_key' => null]);
    exit;
}

try {
    $users = json_decode(file_get_contents(USERS_FILE), true);
    $api_key = null;
    
    foreach ($users as $user) {
        if ($user['id'] === $_SESSION['user_id']) {
            $api_key = $user['api_key'] ?? null;
            break;
        }
    }
    
    echo json_encode(['api_key' => $api_key]);
} catch (Exception $e) {
    echo json_encode(['api_key' => null]);
}
?>