<?php
require_once 'config.php';

if (!is_logged_in()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$api_key = $input['api_key'] ?? '';

if (empty($api_key)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'API key is required']);
    exit;
}

try {
    $users = json_decode(file_get_contents(USERS_FILE), true);
    $updated = false;
    
    foreach ($users as &$user) {
        if ($user['id'] === $_SESSION['user_id']) {
            $user['api_key'] = $api_key;
            $updated = true;
            break;
        }
    }
    
    if ($updated) {
        file_put_contents(USERS_FILE, json_encode($users, JSON_PRETTY_PRINT));
        echo json_encode(['success' => true]);
    } else {
        http_response_code(404);
        echo json_encode(['success' => false, 'message' => 'User not found']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Server error: ' . $e->getMessage()]);
}
?>