<?php
require_once 'config.php';
require_once 'database.php';

if (!isLoggedIn() || !isAdmin()) {
    echo json_encode(['success' => false, 'error' => 'Not authorized']);
    exit;
}

$userId = intval($_POST['user_id']);
$db = new Database();
$accessKey = $db->generateAccessKey($userId);

if ($accessKey) {
    echo json_encode(['success' => true, 'key' => $accessKey]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to generate key']);
}
?>