<?php
require_once 'config.php';
require_once 'database.php';

$db = new Database();

// Handle user registration
$registrationError = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['register'])) {
    $username = sanitizeInput($_POST['username']);
    $email = sanitizeInput($_POST['email']);
    $password = sanitizeInput($_POST['password']);
    $confirmPassword = sanitizeInput($_POST['confirm_password']);
    
    if ($password !== $confirmPassword) {
        $registrationError = "Passwords do not match.";
    } elseif (strlen($password) < 6) {
        $registrationError = "Password must be at least 6 characters.";
    } else {
        // Check if user exists
        $existingUser = $db->getUser($username);
        if ($existingUser) {
            $registrationError = "Username or email already exists.";
        } else {
            if ($db->createUser($username, $email, $password)) {
                // Auto login after registration
                $user = $db->verifyUser($username, $password);
                if ($user) {
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['username'] = $user['username'];
                    $_SESSION['user_role'] = 'user';
                    redirect('dashboard.php');
                }
            } else {
                $registrationError = "Registration failed. Please try again.";
            }
        }
    }
}

// Handle login
$loginError = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $identifier = sanitizeInput($_POST['identifier']);
    $password = sanitizeInput($_POST['password']);
    
    $user = $db->verifyUser($identifier, $password);
    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['user_role'] = isset($user['role']) ? $user['role'] : 'user';
        
        if ($_SESSION['user_role'] === 'admin') {
            redirect('admin.php');
        } else {
            redirect('dashboard.php');
        }
    } else {
        $loginError = "Invalid username/email or password.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?> - Uncensored AI Content Generation</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .pricing-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        .testimonial-card {
            transition: all 0.3s ease;
        }
        .testimonial-card:hover {
            transform: scale(1.02);
        }
        @media (max-width: 768px) {
            .pricing-grid {
                grid-template-columns: 1fr;
            }
            .testimonial-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg">
        <div class="max-w-7xl mx-auto px-4">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <div class="flex-shrink-0">
                        <h1 class="text-2xl font-bold text-purple-600"><?php echo APP_NAME; ?></h1>
                    </div>
                    <div class="hidden md:ml-10 md:flex md:space-x-8">
                        <a href="#features" class="text-gray-700 hover:text-purple-600 px-3 py-2 font-medium">Features</a>
                        <a href="#pricing" class="text-gray-700 hover:text-purple-600 px-3 py-2 font-medium">Pricing</a>
                        <a href="#testimonials" class="text-gray-700 hover:text-purple-600 px-3 py-2 font-medium">Testimonials</a>
                    </div>
                </div>
                <div class="flex items-center">
                    <button onclick="openLoginModal()" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded-md font-medium transition duration-300">
                        Sign In
                    </button>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="gradient-bg text-white py-20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <h1 class="text-4xl md:text-5xl font-extrabold leading-tight mb-6">
                    Generate Uncensored AI Content That Ranks #1
                </h1>
                <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto">
                    Break free from AI limitations. Create authentic, human-like content that bypasses all detectors and dominates search rankings.
                </p>
                <div class="flex flex-col sm:flex-row justify-center gap-4">
                    <button onclick="openRegisterModal()" class="bg-white text-purple-600 px-8 py-3 rounded-lg font-bold text-lg hover:bg-gray-100 transition duration-300">
                        Get Started Free
                    </button>
                    <button onclick="scrollToPricing()" class="border-2 border-white text-white px-8 py-3 rounded-lg font-bold text-lg hover:bg-white hover:text-purple-600 transition duration-300">
                        View Pricing
                    </button>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Powerful Features</h2>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">Everything you need to create undetectable, high-ranking content</p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-gray-50 p-6 rounded-lg shadow-md">
                    <div class="text-purple-600 text-4xl mb-4">
                        <i class="fas fa-brain"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Uncensored AI</h3>
                    <p class="text-gray-600">Generate content on any topic without restrictions or limitations.</p>
                </div>
                
                <div class="bg-gray-50 p-6 rounded-lg shadow-md">
                    <div class="text-purple-600 text-4xl mb-4">
                        <i class="fas fa-user-secret"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">AI Detection Evasion</h3>
                    <p class="text-gray-600">Create content that bypasses all AI detectors with human-like authenticity.</p>
                </div>
                
                <div class="bg-gray-50 p-6 rounded-lg shadow-md">
                    <div class="text-purple-600 text-4xl mb-4">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">SEO Optimized</h3>
                    <p class="text-gray-600">Automatically optimized content structure and keyword placement.</p>
                </div>
                
                <div class="bg-gray-50 p-6 rounded-lg shadow-md">
                    <div class="text-purple-600 text-4xl mb-4">
                        <i class="fas fa-robot"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Custom Personas</h3>
                    <p class="text-gray-600">Create and use different AI personas for various content styles.</p>
                </div>
                
                <div class="bg-gray-50 p-6 rounded-lg shadow-md">
                    <div class="text-purple-600 text-4xl mb-4">
                        <i class="fas fa-database"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Content Management</h3>
                    <p class="text-gray-600">Save, edit, and manage all your generated content in one place.</p>
                </div>
                
                <div class="bg-gray-50 p-6 rounded-lg shadow-md">
                    <div class="text-purple-600 text-4xl mb-4">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3 class="text-xl font-bold text-gray-900 mb-2">Secure & Private</h3>
                    <p class="text-gray-600">Your data and API keys are encrypted and stored securely.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <section id="pricing" class="py-20 bg-gray-100">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Simple, Transparent Pricing</h2>
                <p class="text-xl text-gray-600">Choose the plan that works best for your content needs</p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-6xl mx-auto pricing-grid">
                <!-- Basic Monthly -->
                <div class="bg-white p-8 rounded-xl shadow-lg pricing-card transition duration-300">
                    <div class="text-center mb-6">
                        <h3 class="text-2xl font-bold text-gray-900">Basic Monthly</h3>
                        <div class="mt-4">
                            <span class="text-4xl font-bold">$19</span>
                            <span class="text-gray-600">/month</span>
                        </div>
                    </div>
                    <ul class="space-y-4 mb-8">
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>20 articles per month</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Default AI personas only</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>1000 words max per article</span>
                        </li>
                        <li class="flex items-center text-gray-400">
                            <i class="fas fa-times mr-2"></i>
                            <span>Basic SEO optimization</span>
                        </li>
                        <li class="flex items-center text-gray-400">
                            <i class="fas fa-times mr-2"></i>
                            <span>No custom personas</span>
                        </li>
                        <li class="flex items-center text-gray-400">
                            <i class="fas fa-times mr-2"></i>
                            <span>No advanced settings</span>
                        </li>
                    </ul>
                    <button onclick="selectPlan('basic_monthly')" class="w-full bg-purple-600 text-white py-3 rounded-lg font-bold hover:bg-purple-700 transition duration-300">
                        Subscribe Now
                    </button>
                </div>
                
                <!-- Basic Yearly -->
                <div class="bg-white p-8 rounded-xl shadow-lg pricing-card transition duration-300">
                    <div class="text-center mb-6">
                        <h3 class="text-2xl font-bold text-gray-900">Basic Yearly</h3>
                        <div class="mt-4">
                            <span class="text-4xl font-bold">$179</span>
                            <span class="text-gray-600">/year</span>
                        </div>
                        <div class="text-green-600 font-bold mt-2">Save 20%</div>
                    </div>
                    <ul class="space-y-4 mb-8">
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>240 articles per year</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Default AI personas only</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>1000 words max per article</span>
                        </li>
                        <li class="flex items-center text-gray-400">
                            <i class="fas fa-times mr-2"></i>
                            <span>Basic SEO optimization</span>
                        </li>
                        <li class="flex items-center text-gray-400">
                            <i class="fas fa-times mr-2"></i>
                            <span>No custom personas</span>
                        </li>
                        <li class="flex items-center text-gray-400">
                            <i class="fas fa-times mr-2"></i>
                            <span>No advanced settings</span>
                        </li>
                    </ul>
                    <button onclick="selectPlan('basic_yearly')" class="w-full bg-purple-600 text-white py-3 rounded-lg font-bold hover:bg-purple-700 transition duration-300">
                        Subscribe Now
                    </button>
                </div>
                
                <!-- Pro Monthly -->
                <div class="bg-white p-8 rounded-xl shadow-2xl pricing-card border-4 border-purple-500 transform scale-105 transition duration-300">
                    <div class="text-center mb-6">
                        <div class="inline-block bg-purple-100 text-purple-800 px-4 py-1 rounded-full text-sm font-bold mb-2">
                            MOST POPULAR
                        </div>
                        <h3 class="text-2xl font-bold text-gray-900">Pro Monthly</h3>
                        <div class="mt-4">
                            <span class="text-4xl font-bold">$49</span>
                            <span class="text-gray-600">/month</span>
                        </div>
                    </div>
                    <ul class="space-y-4 mb-8">
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Unlimited articles</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>All AI personas</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>3000 words max per article</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Full SEO optimization</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Create custom personas</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Advanced settings</span>
                        </li>
                    </ul>
                    <button onclick="selectPlan('pro_monthly')" class="w-full gradient-bg text-white py-3 rounded-lg font-bold hover:opacity-90 transition duration-300">
                        Subscribe Now
                    </button>
                </div>
                
                <!-- Pro Yearly -->
                <div class="bg-white p-8 rounded-xl shadow-lg pricing-card transition duration-300">
                    <div class="text-center mb-6">
                        <h3 class="text-2xl font-bold text-gray-900">Pro Yearly</h3>
                        <div class="mt-4">
                            <span class="text-4xl font-bold">$449</span>
                            <span class="text-gray-600">/year</span>
                        </div>
                        <div class="text-green-600 font-bold mt-2">Save 25%</div>
                    </div>
                    <ul class="space-y-4 mb-8">
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Unlimited articles</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>All AI personas</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>5000 words max per article</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Full SEO optimization</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Create custom personas</span>
                        </li>
                        <li class="flex items-center">
                            <i class="fas fa-check text-green-500 mr-2"></i>
                            <span>Priority support</span>
                        </li>
                    </ul>
                    <button onclick="selectPlan('pro_yearly')" class="w-full gradient-bg text-white py-3 rounded-lg font-bold hover:opacity-90 transition duration-300">
                        Subscribe Now
                    </button>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section id="testimonials" class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-16">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">What Our Users Say</h2>
                <p class="text-xl text-gray-600">Real results from real users</p>
            </div>
            
            <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8 testimonial-grid">
                <div class="bg-gray-50 p-6 rounded-xl shadow-md testimonial-card">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-purple-600 rounded-full flex items-center justify-center text-white font-bold">
                            JD
                        </div>
                        <div class="ml-4">
                            <h4 class="font-bold">John Doe</h4>
                            <p class="text-purple-600">SEO Specialist</p>
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"This tool completely transformed my content strategy. My articles now rank on the first page consistently, and the best part is they read like they were written by a human expert."</p>
                    <div class="flex mt-4">
                        <?php for ($i = 0; $i < 5; $i++): ?>
                            <i class="fas fa-star text-yellow-400"></i>
                        <?php endfor; ?>
                    </div>
                </div>
                
                <div class="bg-gray-50 p-6 rounded-xl shadow-md testimonial-card">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-purple-600 rounded-full flex items-center justify-center text-white font-bold">
                            SM
                        </div>
                        <div class="ml-4">
                            <h4 class="font-bold">Sarah Miller</h4>
                            <p class="text-purple-600">Content Marketer</p>
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"I was skeptical at first, but Vine Uncensored AI has exceeded all my expectations. The ability to create content on any topic without restrictions is a game-changer."</p>
                    <div class="flex mt-4">
                        <?php for ($i = 0; $i < 5; $i++): ?>
                            <i class="fas fa-star text-yellow-400"></i>
                        <?php endfor; ?>
                    </div>
                </div>
                
                <div class="bg-gray-50 p-6 rounded-xl shadow-md testimonial-card">
                    <div class="flex items-center mb-4">
                        <div class="w-12 h-12 bg-purple-600 rounded-full flex items-center justify-center text-white font-bold">
                            RK
                        </div>
                        <div class="ml-4">
                            <h4 class="font-bold">Robert Kim</h4>
                            <p class="text-purple-600">Blog Owner</p>
                        </div>
                    </div>
                    <p class="text-gray-600 italic">"The content generated by this AI is so authentic that my readers think I hired a team of expert writers. My traffic has increased by 200% in just 3 months."</p>
                    <div class="flex mt-4">
                        <?php for ($i = 0; $i < 5; $i++): ?>
                            <i class="fas fa-star text-yellow-400"></i>
                        <?php endfor; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="gradient-bg py-16 text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <h2 class="text-3xl md:text-4xl font-bold mb-6">Ready to Create Uncensored AI Content?</h2>
            <p class="text-xl mb-8 max-w-3xl mx-auto">Join thousands of users who are already generating high-quality, undetectable content that ranks.</p>
            <button onclick="openRegisterModal()" class="bg-white text-purple-600 px-8 py-3 rounded-lg font-bold text-lg hover:bg-gray-100 transition duration-300">
                Start Generating Now
            </button>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-900 text-white py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid md:grid-cols-3 gap-8">
                <div>
                    <h3 class="text-xl font-bold mb-4"><?php echo APP_NAME; ?></h3>
                    <p class="text-gray-400">The most powerful uncensored AI content generation platform.</p>
                </div>
                <div>
                    <h3 class="text-xl font-bold mb-4">Quick Links</h3>
                    <ul class="space-y-2">
                        <li><a href="#features" class="text-gray-400 hover:text-white">Features</a></li>
                        <li><a href="#pricing" class="text-gray-400 hover:text-white">Pricing</a></li>
                        <li><a href="#testimonials" class="text-gray-400 hover:text-white">Testimonials</a></li>
                    </ul>
                </div>
                <div>
                    <h3 class="text-xl font-bold mb-4">Contact</h3>
                    <p class="text-gray-400">Email: <?php echo APP_CONTACT; ?></p>
                    <p class="text-gray-400">Website: <?php echo APP_WEBSITE; ?></p>
                </div>
            </div>
            <div class="border-t border-gray-800 mt-8 pt-8 text-center text-gray-400">
                <p>&copy; <?php echo date('Y'); ?> <?php echo APP_NAME; ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Login Modal -->
    <div id="loginModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg w-full max-w-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-2xl font-bold text-gray-900">Sign In</h3>
                <button onclick="closeLoginModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <?php if ($loginError): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo $loginError; ?>
                </div>
            <?php endif; ?>
            <form method="POST" action="">
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2" for="identifier">Username or Email</label>
                    <input type="text" id="identifier" name="identifier" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600" required>
                </div>
                <div class="mb-6">
                    <label class="block text-gray-700 mb-2" for="password">Password</label>
                    <input type="password" id="password" name="password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600" required>
                </div>
                <button type="submit" name="login" class="w-full gradient-bg text-white py-2 rounded-lg font-bold hover:opacity-90 transition duration-300">
                    Sign In
                </button>
            </form>
            <p class="mt-4 text-center text-gray-600">
                Don't have an account? <button onclick="switchToRegister()" class="text-purple-600 hover:underline">Register</button>
            </p>
        </div>
    </div>

    <!-- Register Modal -->
    <div id="registerModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg w-full max-w-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-2xl font-bold text-gray-900">Create Account</h3>
                <button onclick="closeRegisterModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <?php if ($registrationError): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo $registrationError; ?>
                </div>
            <?php endif; ?>
            <form method="POST" action="">
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2" for="username">Username</label>
                    <input type="text" id="username" name="username" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600" required>
                </div>
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2" for="email">Email</label>
                    <input type="email" id="email" name="email" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600" required>
                </div>
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2" for="password">Password</label>
                    <input type="password" id="password" name="password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600" required>
                </div>
                <div class="mb-6">
                    <label class="block text-gray-700 mb-2" for="confirm_password">Confirm Password</label>
                    <input type="password" id="confirm_password" name="confirm_password" class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600" required>
                </div>
                <button type="submit" name="register" class="w-full gradient-bg text-white py-2 rounded-lg font-bold hover:opacity-90 transition duration-300">
                    Create Account
                </button>
            </form>
            <p class="mt-4 text-center text-gray-600">
                Already have an account? <button onclick="switchToLogin()" class="text-purple-600 hover:underline">Sign In</button>
            </p>
        </div>
    </div>

    <!-- Payment Modal -->
    <div id="paymentModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 hidden">
        <div class="bg-white rounded-lg w-full max-w-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-2xl font-bold text-gray-900">Subscribe Now</h3>
                <button onclick="closePaymentModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="mb-4">
                <p class="text-gray-600">You are subscribing to the <span id="selectedPlan" class="font-bold"></span> plan.</p>
            </div>
            <div class="mb-6">
                <label class="block text-gray-700 mb-2">Select Payment Method</label>
                <div class="grid grid-cols-2 gap-4">
                    <button onclick="selectPaymentMethod('stripe')" class="border-2 border-gray-300 rounded-lg p-4 text-center hover:border-purple-600 transition duration-300">
                        <i class="fab fa-cc-stripe text-2xl text-blue-600 mb-2"></i>
                        <p>Stripe</p>
                    </button>
                    <button onclick="selectPaymentMethod('flutterwave')" class="border-2 border-gray-300 rounded-lg p-4 text-center hover:border-purple-600 transition duration-300">
                        <i class="fas fa-credit-card text-2xl text-blue-400 mb-2"></i>
                        <p>Flutterwave</p>
                    </button>
                </div>
            </div>
            <div id="paymentForm" class="hidden">
                <!-- Payment form will be loaded here via AJAX -->
            </div>
        </div>
    </div>

    <script>
        // Modal functions
        function openLoginModal() {
            document.getElementById('loginModal').classList.remove('hidden');
            document.getElementById('registerModal').classList.add('hidden');
        }
        
        function closeLoginModal() {
            document.getElementById('loginModal').classList.add('hidden');
        }
        
        function openRegisterModal() {
            document.getElementById('registerModal').classList.remove('hidden');
            document.getElementById('loginModal').classList.add('hidden');
        }
        
        function closeRegisterModal() {
            document.getElementById('registerModal').classList.add('hidden');
        }
        
        function switchToRegister() {
            closeLoginModal();
            openRegisterModal();
        }
        
        function switchToLogin() {
            closeRegisterModal();
            openLoginModal();
        }
        
        function scrollToPricing() {
            document.getElementById('pricing').scrollIntoView({ behavior: 'smooth' });
        }
        
        // Payment functions
        let selectedPlan = '';
        
        function selectPlan(plan) {
            selectedPlan = plan;
            const planNames = {
                'basic_monthly': 'Basic Monthly ($19/month)',
                'basic_yearly': 'Basic Yearly ($179/year)',
                'pro_monthly': 'Pro Monthly ($49/month)',
                'pro_yearly': 'Pro Yearly ($449/year)'
            };
            document.getElementById('selectedPlan').textContent = planNames[plan] || plan;
            document.getElementById('paymentModal').classList.remove('hidden');
        }
        
        function closePaymentModal() {
            document.getElementById('paymentModal').classList.add('hidden');
            document.getElementById('paymentForm').classList.add('hidden');
            document.getElementById('paymentForm').innerHTML = '';
        }
        
        function selectPaymentMethod(method) {
            // Load payment form via AJAX
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'payment.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onload = function() {
                if (this.status === 200) {
                    document.getElementById('paymentForm').innerHTML = this.responseText;
                    document.getElementById('paymentForm').classList.remove('hidden');
                }
            };
            xhr.send('action=payment_form&method=' + method + '&plan=' + selectedPlan);
        }
        
        // Close modals when clicking outside
        window.onclick = function(event) {
            if (event.target === document.getElementById('loginModal')) {
                closeLoginModal();
            }
            if (event.target === document.getElementById('registerModal')) {
                closeRegisterModal();
            }
            if (event.target === document.getElementById('paymentModal')) {
                closePaymentModal();
            }
        }
    </script>
</body>
</html>