<?php
require_once 'config.php';
require_once 'database.php';

if (isset($_GET['tx_ref'])) {
    $txRef = sanitizeInput($_GET['tx_ref']);
    
    // Verify payment with Flutterwave
    $url = "https://api.flutterwave.com/v3/transactions/" . $txRef . "/verify";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . FLW_SECRET_KEY
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200) {
        $responseData = json_decode($response, true);
        if ($responseData['status'] === 'success' && $responseData['data']['status'] === 'successful') {
            // Update payment status
            $db = new Database();
            $db->updatePaymentStatus($txRef, 'completed');
            
            // Update user subscription
            $payment = $db->getPaymentByTxRef($txRef);
            if ($payment) {
                $duration = $payment['plan'] === 'monthly' ? '1 month' : '1 year';
                $db->updateUserSubscription($payment['user_id'], $payment['plan'], $duration);
                
                $_SESSION['success'] = 'Payment completed successfully!';
                redirect('dashboard.php');
            }
        }
    }
    
    $_SESSION['error'] = 'Payment verification failed.';
    redirect('dashboard.php');
} else {
    redirect('index.php');
}
?>