<?php
require_once 'config.php';
require_once 'database.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$db = new Database();
$userId = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_article'])) {
    $title = sanitizeInput($_POST['title']);
    $content = $_POST['content'];
    $excerpt = sanitizeInput($_POST['excerpt']);
    $keywords = sanitizeInput($_POST['keywords']);
    $status = sanitizeInput($_POST['status']);
    
    if ($db->createArticle($userId, $title, $content, $excerpt, $keywords, $status)) {
        $_SESSION['success'] = "Article saved successfully!";
    } else {
        $_SESSION['error'] = "Failed to save article.";
    }
}

redirect('dashboard.php');
?>