<?php
require_once 'config.php';
require_once 'database.php';

if (!isLoggedIn() || !canCreatePersonas()) {
    redirect('login.php');
}

$db = new Database();
$userId = $_SESSION['user_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitizeInput($_POST['name']);
    $byline = sanitizeInput($_POST['byline']);
    $coreIdentity = sanitizeInput($_POST['core_identity']);
    $backstory = sanitizeInput($_POST['backstory']);
    $traits = implode(',', $_POST['traits']);
    $prompt = $_POST['operational_prompt'];
    $isPublic = isset($_POST['is_public']) ? 1 : 0;
    
    if ($db->createPersona($userId, $name, $byline, $coreIdentity, $backstory, $traits, $prompt, $isPublic)) {
        $_SESSION['success'] = "Persona created successfully!";
    } else {
        $_SESSION['error'] = "Failed to create persona.";
    }
}

redirect('dashboard.php');
?>