<?php
// admin.php - Administration Panel
session_start();

// Check authentication and admin privileges
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    header('Location: index.php');
    exit;
}

// In a real implementation, you would check admin privileges here
// For demo purposes, we'll assume all authenticated users are admins

$userToken = $_SESSION['quillfy_token'] ?? '';

// Handle AJAX requests
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    switch ($_POST['action']) {
        case 'get_users':
            echo json_encode(['success' => true, 'users' => $this->getAllUsers()]);
            exit;
            
        case 'get_agents':
            $agents = json_decode(file_get_contents('data/ai_agents.json'), true) ?? [];
            echo json_encode(['success' => true, 'agents' => $agents]);
            exit;
            
        case 'get_conversations':
            $conversations = $this->getAllConversations();
            echo json_encode(['success' => true, 'conversations' => $conversations]);
            exit;
            
        case 'delete_user':
            $userId = $_POST['user_id'] ?? '';
            if ($this->deleteUser($userId)) {
                echo json_encode(['success' => true, 'message' => 'User deleted successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to delete user']);
            }
            exit;
            
        case 'delete_agent':
            $agentId = $_POST['agent_id'] ?? '';
            if ($this->deleteAIAgent($agentId)) {
                echo json_encode(['success' => true, 'message' => 'AI Agent deleted successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to delete AI Agent']);
            }
            exit;
            
        case 'delete_conversation':
            $conversationId = $_POST['conversation_id'] ?? '';
            if ($this->deleteConversation($conversationId)) {
                echo json_encode(['success' => true, 'message' => 'Conversation deleted successfully']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to delete conversation']);
            }
            exit;
    }
}

// Mock data functions for demo
function getAllUsers() {
    return [
        ['id' => 1, 'username' => 'john_doe', 'email' => 'john@example.com', 'created_at' => '2024-01-15', 'last_login' => '2024-03-20'],
        ['id' => 2, 'username' => 'jane_smith', 'email' => 'jane@example.com', 'created_at' => '2024-02-01', 'last_login' => '2024-03-19'],
        ['id' => 3, 'username' => 'bob_wilson', 'email' => 'bob@example.com', 'created_at' => '2024-02-20', 'last_login' => '2024-03-18']
    ];
}

function getAllConversations() {
    return [
        ['id' => 1, 'user_id' => 1, 'agent_id' => 'athena-blaze', 'message_count' => 15, 'last_activity' => '2024-03-20 14:30:00'],
        ['id' => 2, 'user_id' => 2, 'agent_id' => 'aisha-thompson', 'message_count' => 8, 'last_activity' => '2024-03-19 16:45:00'],
        ['id' => 3, 'user_id' => 3, 'agent_id' => 'athena-blaze', 'message_count' => 23, 'last_activity' => '2024-03-18 09:15:00']
    ];
}

function deleteUser($userId) {
    // In real implementation, delete from database
    return true;
}

function deleteAIAgent($agentId) {
    $agentsFile = 'data/ai_agents.json';
    if (file_exists($agentsFile)) {
        $agents = json_decode(file_get_contents($agentsFile), true) ?? [];
        $agents = array_filter($agents, fn($agent) => $agent['id'] !== $agentId);
        file_put_contents($agentsFile, json_encode(array_values($agents)));
    }
    return true;
}

function deleteConversation($conversationId) {
    // In real implementation, delete from database
    return true;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Quillfy AI</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="writer-container">
        <!-- Sidebar -->
        <div class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <i class="fas fa-feather-alt"></i>
                <h2>Quillfy AI</h2>
                <button class="sidebar-close-btn" id="sidebarCloseBtn">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <nav class="sidebar-nav">
                <a href="writer.php" class="nav-item">
                    <i class="fas fa-pen-fancy"></i>
                    <span>AI Writer</span>
                </a>
                <a href="bulkwriter.php" class="nav-item">
                    <i class="fas fa-layer-group"></i>
                    <span>Bulk Writer</span>
                </a>
                <a href="chat.php" class="nav-item">
                    <i class="fas fa-comments"></i>
                    <span>Uncensored Chat</span>
                </a>
                <a href="admin.php" class="nav-item active">
                    <i class="fas fa-cog"></i>
                    <span>Admin Panel</span>
                </a>
            </nav>
            
            <div class="token-section">
                <div class="token-status">
                    <div class="status-indicator">
                        <div class="status-dot" id="tokenStatus"></div>
                        <span>Token Status: <span id="statusText">Checking...</span></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="main-content" id="mainContent">
            <!-- Header -->
            <header class="header">
                <button class="mobile-menu-btn" id="mobileMenuBtn">
                    <i class="fas fa-bars"></i>
                </button>
                
                <div class="header-actions">
                    <button class="theme-toggle" id="themeToggle">
                        <i class="fas fa-moon"></i>
                    </button>
                    <div class="user-menu">
                        <div class="user-avatar">A</div>
                        <span>Admin</span>
                        <a href="logout.php" class="action-btn">
                            <i class="fas fa-sign-out-alt"></i>
                        </a>
                    </div>
                </div>
            </header>

            <!-- Admin Content -->
            <div class="content-area">
                <div class="admin-container">
                    <div class="admin-header">
                        <h1><i class="fas fa-cog"></i> Administration Panel</h1>
                        <p>Manage users, AI agents, and conversations</p>
                    </div>

                    <div class="admin-stats">
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-users"></i>
                            </div>
                            <div class="stat-info">
                                <h3 id="totalUsers">0</h3>
                                <p>Total Users</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-robot"></i>
                            </div>
                            <div class="stat-info">
                                <h3 id="totalAgents">0</h3>
                                <p>AI Agents</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-comments"></i>
                            </div>
                            <div class="stat-info">
                                <h3 id="totalConversations">0</h3>
                                <p>Conversations</p>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon">
                                <i class="fas fa-database"></i>
                            </div>
                            <div class="stat-info">
                                <h3 id="totalMessages">0</h3>
                                <p>Total Messages</p>
                            </div>
                        </div>
                    </div>

                    <!-- User Management -->
                    <div class="admin-section">
                        <div class="section-header">
                            <h2><i class="fas fa-users"></i> User Management</h2>
                            <button class="refresh-btn" onclick="loadUsers()">
                                <i class="fas fa-sync-alt"></i> Refresh
                            </button>
                        </div>
                        <div class="table-container">
                            <table class="admin-table" id="usersTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Username</th>
                                        <th>Email</th>
                                        <th>Created</th>
                                        <th>Last Login</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="usersTableBody">
                                    <!-- Users will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- AI Agents Management -->
                    <div class="admin-section">
                        <div class="section-header">
                            <h2><i class="fas fa-robot"></i> AI Agents Management</h2>
                            <button class="refresh-btn" onclick="loadAIAgents()">
                                <i class="fas fa-sync-alt"></i> Refresh
                            </button>
                        </div>
                        <div class="table-container">
                            <table class="admin-table" id="agentsTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Title</th>
                                        <th>Persona</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="agentsTableBody">
                                    <!-- AI Agents will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Conversations Management -->
                    <div class="admin-section">
                        <div class="section-header">
                            <h2><i class="fas fa-comments"></i> Conversations Management</h2>
                            <button class="refresh-btn" onclick="loadConversations()">
                                <i class="fas fa-sync-alt"></i> Refresh
                            </button>
                        </div>
                        <div class="table-container">
                            <table class="admin-table" id="conversationsTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>User ID</th>
                                        <th>AI Agent</th>
                                        <th>Messages</th>
                                        <th>Last Activity</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="conversationsTableBody">
                                    <!-- Conversations will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit User Modal -->
    <div class="modal" id="editUserModal" style="display: none;">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Edit User</h3>
                <button class="close-modal" onclick="closeEditUserModal()">&times;</button>
            </div>
            <div class="modal-body">
                <form id="editUserForm">
                    <input type="hidden" id="editUserId">
                    <div class="form-group">
                        <label>Username</label>
                        <input type="text" id="editUsername" class="form-input" required>
                    </div>
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" id="editEmail" class="form-input" required>
                    </div>
                    <div class="form-group">
                        <label>Password (leave blank to keep current)</label>
                        <input type="password" id="editPassword" class="form-input">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" onclick="closeEditUserModal()">Cancel</button>
                <button class="btn btn-primary" onclick="saveUserChanges()">Save Changes</button>
            </div>
        </div>
    </div>

    <!-- Edit Agent Modal -->
    <div class="modal" id="editAgentModal" style="display: none;">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Edit AI Agent</h3>
                <button class="close-modal" onclick="closeEditAgentModal()">&times;</button>
            </div>
            <div class="modal-body">
                <form id="editAgentForm">
                    <input type="hidden" id="editAgentId">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" id="editAgentName" class="form-input" required>
                    </div>
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" id="editAgentTitle" class="form-input" required>
                    </div>
                    <div class="form-group">
                        <label>Avatar URL</label>
                        <input type="text" id="editAgentAvatar" class="form-input">
                    </div>
                    <div class="form-group">
                        <label>Persona</label>
                        <textarea id="editAgentPersona" class="form-textarea" rows="6" required></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary" onclick="closeEditAgentModal()">Cancel</button>
                <button class="btn btn-primary" onclick="saveAgentChanges()">Save Changes</button>
            </div>
        </div>
    </div>

    <!-- Overlay for mobile sidebar -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <script src="admin.js"></script>
</body>
</html>