<?php
// admin_actions.php - Handle admin actions via AJAX
require_once 'config.php';

session_start();

// Check admin authentication
if (!isset($_SESSION['admin_authenticated']) || $_SESSION['admin_authenticated'] !== true) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

header('Content-Type: application/json');

$pdo = getDBConnection();
if (!$pdo) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'delete_user':
        $user_id = $_POST['user_id'] ?? '';
        if (empty($user_id)) {
            echo json_encode(['error' => 'User ID is required']);
            exit;
        }
        
        try {
            $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
            $stmt->execute([$user_id]);
            echo json_encode(['success' => true, 'message' => 'User deleted successfully']);
        } catch (Exception $e) {
            echo json_encode(['error' => 'Failed to delete user: ' . $e->getMessage()]);
        }
        break;
        
    case 'delete_agent':
        $agent_id = $_POST['agent_id'] ?? '';
        if (empty($agent_id)) {
            echo json_encode(['error' => 'Agent ID is required']);
            exit;
        }
        
        try {
            $stmt = $pdo->prepare("DELETE FROM ai_agents WHERE id = ?");
            $stmt->execute([$agent_id]);
            echo json_encode(['success' => true, 'message' => 'AI Agent deleted successfully']);
        } catch (Exception $e) {
            echo json_encode(['error' => 'Failed to delete agent: ' . $e->getMessage()]);
        }
        break;
        
    case 'delete_conversation':
        $conversation_id = $_POST['conversation_id'] ?? '';
        if (empty($conversation_id)) {
            echo json_encode(['error' => 'Conversation ID is required']);
            exit;
        }
        
        try {
            // Delete messages first
            $stmt = $pdo->prepare("DELETE FROM messages WHERE conversation_id = ?");
            $stmt->execute([$conversation_id]);
            
            // Then delete conversation
            $stmt = $pdo->prepare("DELETE FROM conversations WHERE id = ?");
            $stmt->execute([$conversation_id]);
            
            echo json_encode(['success' => true, 'message' => 'Conversation deleted successfully']);
        } catch (Exception $e) {
            echo json_encode(['error' => 'Failed to delete conversation: ' . $e->getMessage()]);
        }
        break;
        
    case 'get_user':
        $user_id = $_POST['user_id'] ?? '';
        if (empty($user_id)) {
            echo json_encode(['error' => 'User ID is required']);
            exit;
        }
        
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            echo json_encode(['success' => true, 'user' => $user]);
        } else {
            echo json_encode(['error' => 'User not found']);
        }
        break;
        
    case 'get_agent':
        $agent_id = $_POST['agent_id'] ?? '';
        if (empty($agent_id)) {
            echo json_encode(['error' => 'Agent ID is required']);
            exit;
        }
        
        $stmt = $pdo->prepare("SELECT * FROM ai_agents WHERE id = ?");
        $stmt->execute([$agent_id]);
        $agent = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($agent) {
            echo json_encode(['success' => true, 'agent' => $agent]);
        } else {
            echo json_encode(['error' => 'Agent not found']);
        }
        break;
        
    case 'update_user':
        $user_id = $_POST['user_id'] ?? '';
        $username = $_POST['username'] ?? '';
        $coins = $_POST['coins'] ?? '';
        $title = $_POST['title'] ?? '';
        
        if (empty($user_id) || empty($username)) {
            echo json_encode(['error' => 'Required fields are missing']);
            exit;
        }
        
        try {
            $stmt = $pdo->prepare("UPDATE users SET username = ?, coins = ?, title = ? WHERE id = ?");
            $stmt->execute([$username, $coins, $title, $user_id]);
            echo json_encode(['success' => true, 'message' => 'User updated successfully']);
        } catch (Exception $e) {
            echo json_encode(['error' => 'Failed to update user: ' . $e->getMessage()]);
        }
        break;
        
    case 'update_agent':
        $agent_id = $_POST['agent_id'] ?? '';
        $name = $_POST['name'] ?? '';
        $avatar = $_POST['avatar'] ?? '';
        $age = $_POST['age'] ?? '';
        $gender = $_POST['gender'] ?? '';
        $location = $_POST['location'] ?? '';
        $personality = $_POST['personality'] ?? '';
        
        if (empty($agent_id) || empty($name) || empty($personality)) {
            echo json_encode(['error' => 'Required fields are missing']);
            exit;
        }
        
        try {
            $stmt = $pdo->prepare("UPDATE ai_agents SET name = ?, avatar = ?, age = ?, gender = ?, location = ?, personality = ? WHERE id = ?");
            $stmt->execute([$name, $avatar, $age, $gender, $location, $personality, $agent_id]);
            echo json_encode(['success' => true, 'message' => 'AI Agent updated successfully']);
        } catch (Exception $e) {
            echo json_encode(['error' => 'Failed to update agent: ' . $e->getMessage()]);
        }
        break;
        
    default:
        echo json_encode(['error' => 'Invalid action']);
        break;
}
?>