<?php
// config.php - Application Configuration & Database Connection

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_qpal');
define('DB_USER', 'fuzesale_qpal');
define('DB_PASS', '!!!###1985ENi!!!');

// API Configuration
define('GEMINI_API_KEY', 'AIzaSyDbjf0QmBkJ1Mc0gMt0Wwp2B68nygD6zKs');
define('GEMINI_API_URL', 'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent');

// Prepopulated User IDs
$validUserIDs = [
    'PRIME45678',
    'PRIME14778', 
    'PRIME75421',
    'PRIME12345',
    'inukan' // Admin user
];

// Session management
session_start();

// Database connection
function getDBConnection() {
    try {
        $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch(PDOException $e) {
        error_log("Database connection failed: " . $e->getMessage());
        return null;
    }
}

// Validate User ID
function validateUserID($userID) {
    global $validUserIDs;
    return in_array($userID, $validUserIDs);
}

// Gemini API call function for chat with streaming support
function callGeminiAPIChat($prompt, $context = '') {
    $fullPrompt = $context . "\n\nUser: " . $prompt . "\nAI:";
    
    $url = GEMINI_API_URL . "?key=" . GEMINI_API_KEY;
    
    $data = [
        'contents' => [
            [
                'parts' => [
                    ['text' => $fullPrompt]
                ]
            ]
        ],
        'generationConfig' => [
            'temperature' => 0.9,
            'topK' => 40,
            'topP' => 0.95,
            'maxOutputTokens' => 2048,
        ]
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode !== 200) {
        return json_encode(['error' => 'API request failed with code: ' . $httpCode]);
    }
    
    return $response;
}

// Extract text from Gemini response
function extractGeminiText($response) {
    $responseData = json_decode($response, true);
    
    if (isset($responseData['error'])) {
        return "Error: " . $responseData['error']['message'];
    }
    
    if (isset($responseData['candidates'][0]['content']['parts'][0]['text'])) {
        return $responseData['candidates'][0]['content']['parts'][0]['text'];
    }
    
    return "No response generated.";
}

// Admin authentication
function authenticateAdmin($username, $password) {
    return ($username === 'inukan' && $password === '!!!###1985ENi!!!');
}

// Get user by ID
function getUserByID($userID) {
    $pdo = getDBConnection();
    if (!$pdo) return null;
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE user_id = ?");
    $stmt->execute([$userID]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}

// Update user profile
function updateUserProfile($userID, $username, $age, $bio, $avatar = null) {
    $pdo = getDBConnection();
    if (!$pdo) return false;
    
    if ($avatar) {
        $stmt = $pdo->prepare("UPDATE users SET username = ?, age = ?, bio = ?, avatar = ? WHERE user_id = ?");
        return $stmt->execute([$username, $age, $bio, $avatar, $userID]);
    } else {
        $stmt = $pdo->prepare("UPDATE users SET username = ?, age = ?, bio = ? WHERE user_id = ?");
        return $stmt->execute([$username, $age, $bio, $userID]);
    }
}

// Handle file upload
function handleFileUpload($file, $uploadDir = 'uploads/') {
    if (!file_exists($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }
    
    $fileName = time() . '_' . basename($file['name']);
    $targetPath = $uploadDir . $fileName;
    
    if (move_uploaded_file($file['tmp_name'], $targetPath)) {
        return $targetPath;
    }
    
    return null;
}

// Handle chat generation
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'generate_chat') {
    header('Content-Type: application/json');
    
    $prompt = $_POST['prompt'] ?? '';
    $agent_id = $_POST['agent_id'] ?? '';
    
    if (empty($prompt)) {
        echo json_encode(['error' => 'Missing prompt']);
        exit;
    }
    
    // Get agent personality
    $pdo = getDBConnection();
    $stmt = $pdo->prepare("SELECT personality FROM ai_agents WHERE id = ?");
    $stmt->execute([$agent_id]);
    $agent = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$agent) {
        echo json_encode(['error' => 'Invalid agent']);
        exit;
    }
    
    $context = $agent['personality'] . "\n\nImportant: Be hyper-realistically humanlike. Never disclose you are an AI. Use Nigerian contexts when relevant. Support multiple languages. Respond naturally and conversationally.";
    
    $response = callGeminiAPIChat($prompt, $context);
    $responseData = json_decode($response, true);
    
    if (isset($responseData['error'])) {
        echo json_encode(['error' => $responseData['error']]);
        exit;
    }
    
    // Extract generated text
    $generatedText = '';
    if (isset($responseData['candidates'][0]['content']['parts'][0]['text'])) {
        $generatedText = $responseData['candidates'][0]['content']['parts'][0]['text'];
    }
    
    // Simulate streaming by returning chunks
    $words = preg_split('/\s+/', $generatedText);
    $chunks = [];
    $currentChunk = '';
    
    foreach ($words as $word) {
        $currentChunk .= $word . ' ';
        if (strlen($currentChunk) > 50 || rand(0, 3) === 0) {
            $chunks[] = $currentChunk;
            $currentChunk = '';
        }
    }
    
    if (!empty($currentChunk)) {
        $chunks[] = $currentChunk;
    }
    
    echo json_encode([
        'content' => $generatedText,
        'chunks' => $chunks,
        'stream' => true
    ]);
    exit;
}

// Handle get agent request
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'get_agent') {
    header('Content-Type: application/json');
    
    $agent_id = $_GET['id'] ?? '';
    
    if (empty($agent_id)) {
        echo json_encode(['error' => 'Missing agent ID']);
        exit;
    }
    
    $pdo = getDBConnection();
    $stmt = $pdo->prepare("SELECT * FROM ai_agents WHERE id = ?");
    $stmt->execute([$agent_id]);
    $agent = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$agent) {
        echo json_encode(['error' => 'Agent not found']);
        exit;
    }
    
    echo json_encode($agent);
    exit;
}
?>