<?php
// get_agent.php - Get AI Agent Data
require_once 'config.php';

header('Content-Type: application/json');

if (!isset($_GET['id'])) {
    echo json_encode(['error' => 'Missing agent ID']);
    exit;
}

$agent_id = $_GET['id'];
$pdo = getDBConnection();

if (!$pdo) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM ai_agents WHERE id = ?");
$stmt->execute([$agent_id]);
$agent = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$agent) {
    echo json_encode(['error' => 'Agent not found']);
    exit;
}

echo json_encode($agent);
?>