<?php
// index.php - Login Page
require_once 'config.php';

// Check if user is already authenticated
if (isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true) {
    header('Location: chat.php');
    exit;
}

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user_id'])) {
    $userID = trim($_POST['user_id']);
    
    if (validateUserID($userID)) {
        $_SESSION['user_id'] = $userID;
        $_SESSION['authenticated'] = true;
        
        // Check if user exists in database, if not create them
        $user = getUserByID($userID);
        if (!$user) {
            $pdo = getDBConnection();
            $stmt = $pdo->prepare("INSERT INTO users (user_id, username) VALUES (?, ?)");
            $stmt->execute([$userID, 'User ' . $userID]);
        } else {
            // Update last login
            $pdo = getDBConnection();
            $stmt = $pdo->prepare("UPDATE users SET last_login = CURRENT_TIMESTAMP WHERE user_id = ?");
            $stmt->execute([$userID]);
        }
        
        header('Location: chat.php');
        exit;
    } else {
        $error = "Invalid User ID. Please check your credentials.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PRIME-AI CHAT - Login</title>
    <link rel="stylesheet" href="styles.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@6.9.96/css/materialdesignicons.min.css" rel="stylesheet">
</head>
<body class="auth-body">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <div class="logo">
                    <i class="mdi mdi-robot-excited-outline"></i>
                    <h1>PRIME-AI CHAT</h1>
                </div>
                <p class="tagline">Hyper-Realistic AI Tutoring Platform</p>
            </div>
            
            <div class="auth-content">
                <h2>Enter Your User ID</h2>
                <p class="auth-description">Access your personalized AI tutoring experience</p>
                
                <?php if (isset($error)): ?>
                    <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                
                <form method="POST" class="token-form">
                    <div class="input-group">
                        <i class="mdi mdi-account-key"></i>
                        <input type="text" name="user_id" placeholder="Enter your User ID" required>
                    </div>
                    <button type="submit" class="auth-btn">
                        <i class="mdi mdi-login"></i>
                        Access Platform
                    </button>
                </form>
                
                <div class="auth-features">
                    <div class="feature">
                        <i class="mdi mdi-brain"></i>
                        <span>Hyper-Realistic AI Conversations</span>
                    </div>
                    <div class="feature">
                        <i class="mdi mdi-school"></i>
                        <span>NERDC Curriculum Integration</span>
                    </div>
                    <div class="feature">
                        <i class="mdi mdi-translate"></i>
                        <span>Multilingual Support</span>
                    </div>
                    <div class="feature">
                        <i class="mdi mdi-trophy"></i>
                        <span>Gamified Learning Experience</span>
                    </div>
                </div>
                
                <div class="admin-access">
                    <a href="inukan.php" class="admin-link">
                        <i class="mdi mdi-shield-account"></i>
                        Admin Access
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>