<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_noteai');
define('DB_USER', 'fuzesale_noteai');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Vine AI Note Maker - NERDC Compliant');
define('SITE_URL', 'http://p.vinesubtech.com.ng/noteaiv7');

// Start session
session_start();

// Check if user is logged in and is admin
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit();
}

// Database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Get admin data
$admin_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT username, email, full_name FROM users WHERE id = ?");
$stmt->execute([$admin_id]);
$admin = $stmt->fetch();

// Get action from URL
$action = $_GET['action'] ?? 'dashboard';
$subaction = $_GET['subaction'] ?? '';
$id = $_GET['id'] ?? 0;

// Initialize variables
$error = '';
$success = '';
$data = [];

// Process actions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    switch ($action) {
        case 'users':
            if ($subaction == 'edit' && $id) {
                // Edit user
                $full_name = $_POST['full_name'];
                $email = $_POST['email'];
                $school = $_POST['school'];
                $status = $_POST['status'];
                $role = $_POST['role'];
                
                $stmt = $pdo->prepare("UPDATE users SET full_name = ?, email = ?, school = ?, status = ?, role = ? WHERE id = ?");
                if ($stmt->execute([$full_name, $email, $school, $status, $role, $id])) {
                    $success = 'User updated successfully';
                    logAction($admin_id, "Updated user #$id", $pdo);
                } else {
                    $error = 'Failed to update user';
                }
            } elseif ($subaction == 'add_credits' && $id) {
                // Add credits to user
                $credits = (int)$_POST['credits'];
                $description = $_POST['description'];
                
                if ($credits != 0) {
                    // Update user credits
                    $stmt = $pdo->prepare("UPDATE users SET note_credits = note_credits + ? WHERE id = ?");
                    if ($stmt->execute([$credits, $id])) {
                        // Record transaction
                        $type = $credits > 0 ? 'reward' : 'penalty';
                        $stmt = $pdo->prepare("INSERT INTO credit_transactions (user_id, admin_id, credits, type, description) VALUES (?, ?, ?, ?, ?)");
                        $stmt->execute([$id, $admin_id, $credits, $type, $description]);
                        
                        $success = $credits > 0 ? "Added $credits credits to user" : "Removed " . abs($credits) . " credits from user";
                        logAction($admin_id, "Adjusted credits for user #$id: $credits", $pdo);
                    } else {
                        $error = 'Failed to update credits';
                    }
                }
            } elseif ($subaction == 'delete' && $id) {
                // Delete user
                $stmt = $pdo->prepare("DELETE FROM users WHERE id = ? AND role != 'admin'");
                if ($stmt->execute([$id])) {
                    $success = 'User deleted successfully';
                    logAction($admin_id, "Deleted user #$id", $pdo);
                    header('Location: admin.php?action=users');
                    exit();
                } else {
                    $error = 'Failed to delete user';
                }
            }
            break;
            
        case 'settings':
            // Update settings
            foreach ($_POST['settings'] as $key => $value) {
                $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
                $stmt->execute([$value, $key]);
            }
            $success = 'Settings updated successfully';
            logAction($admin_id, "Updated system settings", $pdo);
            break;
            
        case 'announcements':
            if ($subaction == 'create' || ($subaction == 'edit' && $id)) {
                // Create or edit announcement
                $title = $_POST['title'];
                $content = $_POST['content'];
                $priority = $_POST['priority'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                $start_date = $_POST['start_date'] ?: null;
                $end_date = $_POST['end_date'] ?: null;
                
                if ($subaction == 'create') {
                    $stmt = $pdo->prepare("INSERT INTO announcements (title, content, priority, is_active, start_date, end_date, created_by) VALUES (?, ?, ?, ?, ?, ?, ?)");
                    if ($stmt->execute([$title, $content, $priority, $is_active, $start_date, $end_date, $admin_id])) {
                        $success = 'Announcement created successfully';
                        logAction($admin_id, "Created announcement: $title", $pdo);
                        header('Location: admin.php?action=announcements');
                        exit();
                    } else {
                        $error = 'Failed to create announcement';
                    }
                } else {
                    $stmt = $pdo->prepare("UPDATE announcements SET title = ?, content = ?, priority = ?, is_active = ?, start_date = ?, end_date = ? WHERE id = ?");
                    if ($stmt->execute([$title, $content, $priority, $is_active, $start_date, $end_date, $id])) {
                        $success = 'Announcement updated successfully';
                        logAction($admin_id, "Updated announcement #$id", $pdo);
                        header('Location: admin.php?action=announcements');
                        exit();
                    } else {
                        $error = 'Failed to update announcement';
                    }
                }
            } elseif ($subaction == 'delete' && $id) {
                // Delete announcement
                $stmt = $pdo->prepare("DELETE FROM announcements WHERE id = ?");
                if ($stmt->execute([$id])) {
                    $success = 'Announcement deleted successfully';
                    logAction($admin_id, "Deleted announcement #$id", $pdo);
                    header('Location: admin.php?action=announcements');
                    exit();
                } else {
                    $error = 'Failed to delete announcement';
                }
            }
            break;
            
        case 'email_templates':
            if ($subaction == 'edit' && $id) {
                // Edit email template
                $subject = $_POST['subject'];
                $content = $_POST['content'];
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                $stmt = $pdo->prepare("UPDATE email_templates SET subject = ?, content = ?, is_active = ? WHERE id = ?");
                if ($stmt->execute([$subject, $content, $is_active, $id])) {
                    $success = 'Email template updated successfully';
                    logAction($admin_id, "Updated email template #$id", $pdo);
                } else {
                    $error = 'Failed to update email template';
                }
            }
            break;
            
        case 'system':
            if ($subaction == 'clear_cache') {
                // Clear cache (placeholder for future implementation)
                $success = 'System cache cleared successfully';
                logAction($admin_id, "Cleared system cache", $pdo);
            } elseif ($subaction == 'backup_db') {
                // Backup database (placeholder for future implementation)
                $success = 'Database backup initiated successfully';
                logAction($admin_id, "Initiated database backup", $pdo);
            }
            break;
    }
}

// Load data based on action
switch ($action) {
    case 'dashboard':
        // Get statistics
        $stats = [
            'total_users' => $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn(),
            'total_teachers' => $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'teacher'")->fetchColumn(),
            'total_notes' => $pdo->query("SELECT COUNT(*) FROM notes")->fetchColumn(),
            'total_ai_notes' => $pdo->query("SELECT COUNT(*) FROM notes WHERE ai_generated = 1")->fetchColumn(),
            'active_users' => $pdo->query("SELECT COUNT(*) FROM users WHERE status = 'active'")->fetchColumn(),
            'suspended_users' => $pdo->query("SELECT COUNT(*) FROM users WHERE status = 'suspended'")->fetchColumn(),
            'today_notes' => $pdo->query("SELECT COUNT(*) FROM notes WHERE DATE(created_at) = CURDATE()")->fetchColumn(),
            'yesterday_notes' => $pdo->query("SELECT COUNT(*) FROM notes WHERE DATE(created_at) = DATE_SUB(CURDATE(), INTERVAL 1 DAY)")->fetchColumn(),
        ];
        
        // Get recent activities
        $recent_activities = $pdo->query("
            SELECT l.*, u.username, u.full_name 
            FROM system_logs l 
            LEFT JOIN users u ON l.user_id = u.id 
            ORDER BY l.created_at DESC 
            LIMIT 10
        ")->fetchAll();
        
        // Get note creation trends (last 7 days)
        $note_trends = $pdo->query("
            SELECT DATE(created_at) as date, COUNT(*) as count 
            FROM notes 
            WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY) 
            GROUP BY DATE(created_at) 
            ORDER BY date
        ")->fetchAll();
        
        break;
        
    case 'users':
        // Get all users
        $search = $_GET['search'] ?? '';
        $role_filter = $_GET['role'] ?? '';
        $status_filter = $_GET['status'] ?? '';
        
        $query = "SELECT * FROM users WHERE 1=1";
        $params = [];
        
        if ($search) {
            $query .= " AND (username LIKE ? OR email LIKE ? OR full_name LIKE ?)";
            $search_term = "%$search%";
            $params[] = $search_term;
            $params[] = $search_term;
            $params[] = $search_term;
        }
        
        if ($role_filter) {
            $query .= " AND role = ?";
            $params[] = $role_filter;
        }
        
        if ($status_filter) {
            $query .= " AND status = ?";
            $params[] = $status_filter;
        }
        
        $query .= " ORDER BY created_at DESC";
        
        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        $users = $stmt->fetchAll();
        
        // For edit view
        if ($subaction == 'edit' && $id) {
            $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
            $stmt->execute([$id]);
            $edit_user = $stmt->fetch();
            
            if (!$edit_user) {
                $error = 'User not found';
                $action = 'users';
            } else {
                // Get credit transactions
                $stmt = $pdo->prepare("
                    SELECT ct.*, a.username as admin_username 
                    FROM credit_transactions ct 
                    LEFT JOIN users a ON ct.admin_id = a.id 
                    WHERE ct.user_id = ? 
                    ORDER BY ct.created_at DESC
                ");
                $stmt->execute([$id]);
                $credit_transactions = $stmt->fetchAll();
                
                // Get user notes
                $stmt = $pdo->prepare("SELECT * FROM notes WHERE user_id = ? ORDER BY created_at DESC");
                $stmt->execute([$id]);
                $user_notes = $stmt->fetchAll();
            }
        }
        break;
        
    case 'notes':
        // Get all notes with user info
        $search = $_GET['search'] ?? '';
        $user_filter = $_GET['user'] ?? '';
        
        $query = "
            SELECT n.*, u.username, u.full_name, u.email 
            FROM notes n 
            JOIN users u ON n.user_id = u.id 
            WHERE 1=1
        ";
        $params = [];
        
        if ($search) {
            $query .= " AND (n.topic LIKE ? OR n.content LIKE ?)";
            $search_term = "%$search%";
            $params[] = $search_term;
            $params[] = $search_term;
        }
        
        if ($user_filter) {
            $query .= " AND n.user_id = ?";
            $params[] = $user_filter;
        }
        
        $query .= " ORDER BY n.created_at DESC";
        
        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        $notes = $stmt->fetchAll();
        
        // Get all users for filter
        $users = $pdo->query("SELECT id, username, full_name FROM users ORDER BY username")->fetchAll();
        break;
        
    case 'settings':
        // Get all settings
        $settings = $pdo->query("SELECT * FROM settings ORDER BY setting_key")->fetchAll();
        break;
        
    case 'announcements':
        // Get all announcements
        $stmt = $pdo->query("
            SELECT a.*, u.username as created_by_username 
            FROM announcements a 
            JOIN users u ON a.created_by = u.id 
            ORDER BY a.created_at DESC
        ");
        $announcements = $stmt->fetchAll();
        
        // For edit view
        if ($subaction == 'edit' && $id) {
            $stmt = $pdo->prepare("SELECT * FROM announcements WHERE id = ?");
            $stmt->execute([$id]);
            $edit_announcement = $stmt->fetch();
            
            if (!$edit_announcement) {
                $error = 'Announcement not found';
                $action = 'announcements';
            }
        }
        break;
        
    case 'email_templates':
        // Get all email templates
        $templates = $pdo->query("SELECT * FROM email_templates ORDER BY name")->fetchAll();
        
        // For edit view
        if ($subaction == 'edit' && $id) {
            $stmt = $pdo->prepare("SELECT * FROM email_templates WHERE id = ?");
            $stmt->execute([$id]);
            $edit_template = $stmt->fetch();
            
            if (!$edit_template) {
                $error = 'Email template not found';
                $action = 'email_templates';
            }
        }
        break;
        
    case 'reports':
        // Get report data
        $report_type = $_GET['type'] ?? 'usage';
        $start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
        $end_date = $_GET['end_date'] ?? date('Y-m-d');
        
        switch ($report_type) {
            case 'usage':
                // Usage statistics
                $stmt = $pdo->prepare("
                    SELECT 
                        COUNT(DISTINCT user_id) as active_users,
                        COUNT(*) as total_notes,
                        SUM(ai_generated) as ai_notes,
                        AVG(LENGTH(content) - LENGTH(REPLACE(content, ' ', '')) + 1) as avg_words
                    FROM notes 
                    WHERE created_at BETWEEN ? AND ?
                ");
                $stmt->execute([$start_date, $end_date . ' 23:59:59']);
                $usage_stats = $stmt->fetch();
                
                // Daily usage trend
                $stmt = $pdo->prepare("
                    SELECT DATE(created_at) as date, 
                           COUNT(*) as note_count,
                           COUNT(DISTINCT user_id) as user_count
                    FROM notes 
                    WHERE created_at BETWEEN ? AND ?
                    GROUP BY DATE(created_at)
                    ORDER BY date
                ");
                $stmt->execute([$start_date, $end_date . ' 23:59:59']);
                $daily_usage = $stmt->fetchAll();
                break;
                
            case 'users':
                // User activity report
                $stmt = $pdo->prepare("
                    SELECT u.id, u.username, u.full_name, u.email, u.school,
                           COUNT(n.id) as note_count,
                           MAX(n.created_at) as last_note_date,
                           SUM(n.ai_generated) as ai_note_count
                    FROM users u
                    LEFT JOIN notes n ON u.id = n.user_id AND n.created_at BETWEEN ? AND ?
                    WHERE u.role = 'teacher'
                    GROUP BY u.id
                    ORDER BY note_count DESC
                ");
                $stmt->execute([$start_date, $end_date . ' 23:59:59']);
                $user_activity = $stmt->fetchAll();
                break;
                
            case 'credits':
                // Credit transactions report
                $stmt = $pdo->prepare("
                    SELECT ct.*, u.username, u.full_name, a.username as admin_username
                    FROM credit_transactions ct
                    JOIN users u ON ct.user_id = u.id
                    LEFT JOIN users a ON ct.admin_id = a.id
                    WHERE ct.created_at BETWEEN ? AND ?
                    ORDER BY ct.created_at DESC
                ");
                $stmt->execute([$start_date, $end_date . ' 23:59:59']);
                $credit_transactions = $stmt->fetchAll();
                break;
        }
        break;
        
    case 'system_logs':
        // Get system logs
        $page = max(1, $_GET['page'] ?? 1);
        $limit = 50;
        $offset = ($page - 1) * $limit;
        
        $search = $_GET['search'] ?? '';
        
        $query = "
            SELECT l.*, u.username, u.full_name 
            FROM system_logs l 
            LEFT JOIN users u ON l.user_id = u.id 
            WHERE 1=1
        ";
        $params = [];
        
        if ($search) {
            $query .= " AND (l.action LIKE ? OR l.description LIKE ? OR u.username LIKE ?)";
            $search_term = "%$search%";
            $params[] = $search_term;
            $params[] = $search_term;
            $params[] = $search_term;
        }
        
        $query .= " ORDER BY l.created_at DESC LIMIT $limit OFFSET $offset";
        
        $stmt = $pdo->prepare($query);
        $stmt->execute($params);
        $logs = $stmt->fetchAll();
        
        // Get total count for pagination
        $count_query = "SELECT COUNT(*) FROM system_logs l LEFT JOIN users u ON l.user_id = u.id WHERE 1=1";
        if ($search) {
            $count_query .= " AND (l.action LIKE ? OR l.description LIKE ? OR u.username LIKE ?)";
        }
        
        $stmt = $pdo->prepare($count_query);
        $stmt->execute($params);
        $total_logs = $stmt->fetchColumn();
        $total_pages = ceil($total_logs / $limit);
        break;
        
    case 'system':
        // System management page doesn't need additional data
        break;
}

// Function to log admin actions
function logAction($user_id, $action, $pdo) {
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    
    $stmt = $pdo->prepare("INSERT INTO system_logs (user_id, action, description, ip_address, user_agent) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$user_id, 'admin_action', $action, $ip_address, $user_agent]);
}

// Helper functions
function get_status_badge($status) {
    switch ($status) {
        case 'active': return 'success';
        case 'suspended': return 'danger';
        case 'pending': return 'warning';
        default: return 'secondary';
    }
}

function get_priority_badge($priority) {
    switch ($priority) {
        case 'high': return 'danger';
        case 'medium': return 'warning';
        case 'low': return 'info';
        default: return 'secondary';
    }
}

function time_ago($date) {
    $now = new DateTime();
    $past = new DateTime($date);
    $diff = $now->diff($past);
    
    if ($diff->y > 0) return $diff->y . ' year' . ($diff->y > 1 ? 's' : '') . ' ago';
    if ($diff->m > 0) return $diff->m . ' month' . ($diff->m > 1 ? 's' : '') . ' ago';
    if ($diff->d > 0) return $diff->d . ' day' . ($diff->d > 1 ? 's' : '') . ' ago';
    if ($diff->h > 0) return $diff->h . ' hour' . ($diff->h > 1 ? 's' : '') . ' ago';
    if ($diff->i > 0) return $diff->i . ' minute' . ($diff->i > 1 ? 's' : '') . ' ago';
    return 'just now';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo SITE_NAME; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.css">
    <style>
        .content-wrapper { background-color: #f8f9fa; }
        .main-sidebar { position: fixed; }
        .nav-sidebar .nav-item > .nav-link { cursor: pointer; }
        .stats-small { font-size: 0.9rem; }
        .chart-container { position: relative; height: 300px; }
        .log-table { font-size: 0.85rem; }
        .user-avatar { width: 40px; height: 40px; border-radius: 50%; }
        .badge-status { font-size: 0.75rem; }
        .sidebar-dark-primary { background-color: #343a40; }
        .brand-link { border-bottom: 1px solid #4b545c; }
    </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <div class="wrapper">

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href="admin.php" class="nav-link">Home</a>
                </li>
                <li class="nav-item d-none d-sm-inline-block">
                    <a href="../index.php" class="nav-link" target="_blank">View Site</a>
                </li>
            </ul>

            <!-- Right navbar links -->
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="logout.php">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </li>
            </ul>
        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="admin.php" class="brand-link text-center">
                <span class="brand-text font-weight-light"><?php echo SITE_NAME; ?> Admin</span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="image">
                        <i class="fas fa-user-shield img-circle elevation-2 bg-info p-2"></i>
                    </div>
                    <div class="info">
                        <a href="#" class="d-block"><?php echo htmlspecialchars($admin['full_name']); ?></a>
                        <small class="text-light">Administrator</small>
                    </div>
                </div>

                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                        <li class="nav-item">
                            <a href="admin.php?action=dashboard" class="nav-link <?php echo $action == 'dashboard' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=users" class="nav-link <?php echo $action == 'users' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-users"></i>
                                <p>User Management</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=notes" class="nav-link <?php echo $action == 'notes' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-sticky-note"></i>
                                <p>Lesson Notes</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=settings" class="nav-link <?php echo $action == 'settings' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-cog"></i>
                                <p>System Settings</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=announcements" class="nav-link <?php echo $action == 'announcements' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-bullhorn"></i>
                                <p>Announcements</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=email_templates" class="nav-link <?php echo $action == 'email_templates' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-envelope"></i>
                                <p>Email Templates</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=reports" class="nav-link <?php echo $action == 'reports' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-chart-bar"></i>
                                <p>Reports & Analytics</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=system_logs" class="nav-link <?php echo $action == 'system_logs' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-clipboard-list"></i>
                                <p>System Logs</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="admin.php?action=system" class="nav-link <?php echo $action == 'system' ? 'active' : ''; ?>">
                                <i class="nav-icon fas fa-server"></i>
                                <p>System Tools</p>
                            </a>
                        </li>
                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1 class="m-0 text-dark">
                                <?php 
                                $titles = [
                                    'dashboard' => 'Dashboard',
                                    'users' => 'User Management',
                                    'notes' => 'Lesson Notes',
                                    'settings' => 'System Settings',
                                    'announcements' => 'Announcements',
                                    'email_templates' => 'Email Templates',
                                    'reports' => 'Reports & Analytics',
                                    'system_logs' => 'System Logs',
                                    'system' => 'System Tools'
                                ];
                                echo $titles[$action] ?? 'Admin Panel';
                                ?>
                            </h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="admin.php">Admin</a></li>
                                <li class="breadcrumb-item active"><?php echo $titles[$action] ?? 'Dashboard'; ?></li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Main content -->
            <section class="content">
                <div class="container-fluid">
                    <?php if ($error): ?>
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="icon fas fa-ban"></i> <?php echo $error; ?>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($success): ?>
                    <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <i class="icon fas fa-check"></i> <?php echo $success; ?>
                    </div>
                    <?php endif; ?>

                    <!-- Dashboard Content -->
                    <?php if ($action == 'dashboard'): ?>
                    <div class="row">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3><?php echo $stats['total_users']; ?></h3>
                                    <p>Total Users</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <a href="admin.php?action=users" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3><?php echo $stats['total_notes']; ?></h3>
                                    <p>Total Notes</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-sticky-note"></i>
                                </div>
                                <a href="admin.php?action=notes" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3><?php echo $stats['active_users']; ?></h3>
                                    <p>Active Users</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-user-check"></i>
                                </div>
                                <a href="admin.php?action=users&status=active" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3><?php echo $stats['today_notes']; ?></h3>
                                    <p>Today's Notes</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-day"></i>
                                </div>
                                <a href="admin.php?action=notes" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Note Creation Trend (Last 7 Days)</h3>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container">
                                        <canvas id="notesChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Recent Activities</h3>
                                </div>
                                <div class="card-body p-0">
                                    <ul class="products-list product-list-in-card pl-2 pr-2">
                                        <?php foreach ($recent_activities as $activity): ?>
                                        <li class="item">
                                            <div class="product-info">
                                                <a href="javascript:void(0)" class="product-title">
                                                    <?php echo htmlspecialchars($activity['action']); ?>
                                                    <span class="badge badge-warning float-right"><?php echo time_ago($activity['created_at']); ?></span>
                                                </a>
                                                <span class="product-description">
                                                    <?php echo htmlspecialchars($activity['description']); ?>
                                                    <?php if ($activity['username']): ?>
                                                    <br><small>By: <?php echo htmlspecialchars($activity['username']); ?></small>
                                                    <?php endif; ?>
                                                </span>
                                            </div>
                                        </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Users Management -->
                    <?php if ($action == 'users'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">User Management</h3>
                            <div class="card-tools">
                                <form method="GET" class="form-inline">
                                    <input type="hidden" name="action" value="users">
                                    <div class="input-group input-group-sm">
                                        <input type="text" name="search" class="form-control" placeholder="Search users..." value="<?php echo htmlspecialchars($search ?? ''); ?>">
                                        <select name="role" class="form-control ml-1">
                                            <option value="">All Roles</option>
                                            <option value="admin" <?php echo ($role_filter ?? '') == 'admin' ? 'selected' : ''; ?>>Admin</option>
                                            <option value="teacher" <?php echo ($role_filter ?? '') == 'teacher' ? 'selected' : ''; ?>>Teacher</option>
                                        </select>
                                        <select name="status" class="form-control ml-1">
                                            <option value="">All Status</option>
                                            <option value="active" <?php echo ($status_filter ?? '') == 'active' ? 'selected' : ''; ?>>Active</option>
                                            <option value="suspended" <?php echo ($status_filter ?? '') == 'suspended' ? 'selected' : ''; ?>>Suspended</option>
                                            <option value="pending" <?php echo ($status_filter ?? '') == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                        </select>
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Username</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Role</th>
                                        <th>Status</th>
                                        <th>Credits</th>
                                        <th>Joined</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($users as $user): ?>
                                    <tr>
                                        <td><?php echo $user['id']; ?></td>
                                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                                        <td><?php echo htmlspecialchars($user['full_name']); ?></td>
                                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo $user['role'] == 'admin' ? 'danger' : 'primary'; ?>">
                                                <?php echo ucfirst($user['role']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge badge-<?php echo get_status_badge($user['status']); ?>">
                                                <?php echo ucfirst($user['status']); ?>
                                            </span>
                                        </td>
                                        <td><?php echo $user['note_credits']; ?></td>
                                        <td><?php echo date('M j, Y', strtotime($user['created_at'])); ?></td>
                                        <td>
                                            <a href="admin.php?action=users&subaction=edit&id=<?php echo $user['id']; ?>" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <?php if ($user['role'] != 'admin'): ?>
                                            <a href="admin.php?action=users&subaction=delete&id=<?php echo $user['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this user?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- User Edit Form -->
                    <?php if ($action == 'users' && $subaction == 'edit' && isset($edit_user)): ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card card-primary">
                                <div class="card-header">
                                    <h3 class="card-title">Edit User: <?php echo htmlspecialchars($edit_user['username']); ?></h3>
                                </div>
                                <form method="POST">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label>Username</label>
                                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($edit_user['username']); ?>" disabled>
                                        </div>
                                        <div class="form-group">
                                            <label>Full Name *</label>
                                            <input type="text" name="full_name" class="form-control" value="<?php echo htmlspecialchars($edit_user['full_name']); ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Email *</label>
                                            <input type="email" name="email" class="form-control" value="<?php echo htmlspecialchars($edit_user['email']); ?>" required>
                                        </div>
                                        <div class="form-group">
                                            <label>School</label>
                                            <input type="text" name="school" class="form-control" value="<?php echo htmlspecialchars($edit_user['school']); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label>Role</label>
                                            <select name="role" class="form-control">
                                                <option value="teacher" <?php echo $edit_user['role'] == 'teacher' ? 'selected' : ''; ?>>Teacher</option>
                                                <option value="admin" <?php echo $edit_user['role'] == 'admin' ? 'selected' : ''; ?>>Administrator</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label>Status</label>
                                            <select name="status" class="form-control">
                                                <option value="active" <?php echo $edit_user['status'] == 'active' ? 'selected' : ''; ?>>Active</option>
                                                <option value="suspended" <?php echo $edit_user['status'] == 'suspended' ? 'selected' : ''; ?>>Suspended</option>
                                                <option value="pending" <?php echo $edit_user['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit" class="btn btn-primary">Update User</button>
                                        <a href="admin.php?action=users" class="btn btn-default">Cancel</a>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card card-info">
                                <div class="card-header">
                                    <h3 class="card-title">Credit Management</h3>
                                </div>
                                <form method="POST" action="admin.php?action=users&subaction=add_credits&id=<?php echo $edit_user['id']; ?>">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label>Current Credits: <strong><?php echo $edit_user['note_credits']; ?></strong></label>
                                        </div>
                                        <div class="form-group">
                                            <label>Adjust Credits</label>
                                            <input type="number" name="credits" class="form-control" placeholder="Enter positive number to add, negative to remove" required>
                                        </div>
                                        <div class="form-group">
                                            <label>Reason/Description</label>
                                            <textarea name="description" class="form-control" placeholder="Reason for credit adjustment" required></textarea>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="submit" class="btn btn-info">Apply Credit Adjustment</button>
                                    </div>
                                </form>
                            </div>

                            <!-- Credit Transaction History -->
                            <div class="card card-secondary mt-3">
                                <div class="card-header">
                                    <h3 class="card-title">Credit Transaction History</h3>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm">
                                        <thead>
                                            <tr>
                                                <th>Date</th>
                                                <th>Credits</th>
                                                <th>Type</th>
                                                <th>Description</th>
                                                <th>By Admin</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($credit_transactions as $transaction): ?>
                                            <tr>
                                                <td><?php echo date('M j, H:i', strtotime($transaction['created_at'])); ?></td>
                                                <td class="<?php echo $transaction['credits'] > 0 ? 'text-success' : 'text-danger'; ?>">
                                                    <?php echo $transaction['credits'] > 0 ? '+' : ''; ?><?php echo $transaction['credits']; ?>
                                                </td>
                                                <td><?php echo ucfirst($transaction['type']); ?></td>
                                                <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                                                <td><?php echo $transaction['admin_username'] ?? 'System'; ?></td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- User Notes -->
                            <div class="card card-warning mt-3">
                                <div class="card-header">
                                    <h3 class="card-title">User's Notes (<?php echo count($user_notes); ?>)</h3>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm">
                                        <thead>
                                            <tr>
                                                <th>Topic</th>
                                                <th>Age Group</th>
                                                <th>Created</th>
                                                <th>AI</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($user_notes as $note): ?>
                                            <tr>
                                                <td><?php echo htmlspecialchars($note['topic']); ?></td>
                                                <td><?php echo $note['age_group']; ?> years</td>
                                                <td><?php echo date('M j, Y', strtotime($note['created_at'])); ?></td>
                                                <td><?php echo $note['ai_generated'] ? 'Yes' : 'No'; ?></td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Notes Management -->
                    <?php if ($action == 'notes'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Lesson Notes Management</h3>
                            <div class="card-tools">
                                <form method="GET" class="form-inline">
                                    <input type="hidden" name="action" value="notes">
                                    <div class="input-group input-group-sm">
                                        <input type="text" name="search" class="form-control" placeholder="Search notes..." value="<?php echo htmlspecialchars($search ?? ''); ?>">
                                        <select name="user" class="form-control ml-1">
                                            <option value="">All Users</option>
                                            <?php foreach ($users as $user): ?>
                                            <option value="<?php echo $user['id']; ?>" <?php echo ($user_filter ?? '') == $user['id'] ? 'selected' : ''; ?>>
                                                <?php echo htmlspecialchars($user['username']); ?>
                                            </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Topic</th>
                                        <th>Age Group</th>
                                        <th>User</th>
                                        <th>AI Generated</th>
                                        <th>Word Count</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($notes as $note): ?>
                                    <tr>
                                        <td><?php echo $note['id']; ?></td>
                                        <td><?php echo htmlspecialchars($note['topic']); ?></td>
                                        <td><?php echo $note['age_group']; ?> years</td>
                                        <td><?php echo htmlspecialchars($note['username']); ?></td>
                                        <td><?php echo $note['ai_generated'] ? 'Yes' : 'No'; ?></td>
                                        <td><?php echo $note['word_count']; ?></td>
                                        <td><?php echo date('M j, Y', strtotime($note['created_at'])); ?></td>
                                        <td>
                                            <a href="../notes.php?action=view&id=<?php echo $note['id']; ?>" class="btn btn-sm btn-info" target="_blank">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <button class="btn btn-sm btn-danger" onclick="deleteNote(<?php echo $note['id']; ?>)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- System Settings -->
                    <?php if ($action == 'settings'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">System Settings</h3>
                        </div>
                        <form method="POST">
                            <div class="card-body">
                                <?php foreach ($settings as $setting): ?>
                                <div class="form-group">
                                    <label for="setting_<?php echo $setting['setting_key']; ?>">
                                        <?php echo ucwords(str_replace('_', ' ', $setting['setting_key'])); ?>
                                        <?php if ($setting['description']): ?>
                                        <br><small class="text-muted"><?php echo htmlspecialchars($setting['description']); ?></small>
                                        <?php endif; ?>
                                    </label>
                                    <?php if (strpos($setting['setting_key'], 'api_key') !== false): ?>
                                    <input type="password" name="settings[<?php echo $setting['setting_key']; ?>]" 
                                           class="form-control" id="setting_<?php echo $setting['setting_key']; ?>"
                                           value="<?php echo htmlspecialchars($setting['setting_value']); ?>">
                                    <?php else: ?>
                                    <input type="text" name="settings[<?php echo $setting['setting_key']; ?>]" 
                                           class="form-control" id="setting_<?php echo $setting['setting_key']; ?>"
                                           value="<?php echo htmlspecialchars($setting['setting_value']); ?>">
                                    <?php endif; ?>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Save Settings</button>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>

                    <!-- Announcements Management -->
                    <?php if ($action == 'announcements'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Announcements</h3>
                            <div class="card-tools">
                                <a href="admin.php?action=announcements&subaction=create" class="btn btn-sm btn-primary">
                                    <i class="fas fa-plus"></i> New Announcement
                                </a>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Title</th>
                                        <th>Priority</th>
                                        <th>Status</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Created By</th>
                                        <th>Created</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($announcements as $announcement): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($announcement['title']); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo get_priority_badge($announcement['priority']); ?>">
                                                <?php echo ucfirst($announcement['priority']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge badge-<?php echo $announcement['is_active'] ? 'success' : 'secondary'; ?>">
                                                <?php echo $announcement['is_active'] ? 'Active' : 'Inactive'; ?>
                                            </span>
                                        </td>
                                        <td><?php echo $announcement['start_date'] ? date('M j, Y', strtotime($announcement['start_date'])) : 'N/A'; ?></td>
                                        <td><?php echo $announcement['end_date'] ? date('M j, Y', strtotime($announcement['end_date'])) : 'N/A'; ?></td>
                                        <td><?php echo htmlspecialchars($announcement['created_by_username']); ?></td>
                                        <td><?php echo date('M j, Y', strtotime($announcement['created_at'])); ?></td>
                                        <td>
                                            <a href="admin.php?action=announcements&subaction=edit&id=<?php echo $announcement['id']; ?>" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="admin.php?action=announcements&subaction=delete&id=<?php echo $announcement['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this announcement?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Create/Edit Announcement -->
                    <?php if ($action == 'announcements' && ($subaction == 'create' || ($subaction == 'edit' && isset($edit_announcement)))): ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title"><?php echo $subaction == 'create' ? 'Create New' : 'Edit'; ?> Announcement</h3>
                        </div>
                        <form method="POST">
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Title *</label>
                                    <input type="text" name="title" class="form-control" value="<?php echo isset($edit_announcement) ? htmlspecialchars($edit_announcement['title']) : ''; ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Content *</label>
                                    <textarea name="content" class="form-control" rows="5" required><?php echo isset($edit_announcement) ? htmlspecialchars($edit_announcement['content']) : ''; ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Priority</label>
                                    <select name="priority" class="form-control">
                                        <option value="low" <?php echo (isset($edit_announcement) && $edit_announcement['priority'] == 'low') ? 'selected' : ''; ?>>Low</option>
                                        <option value="medium" <?php echo (isset($edit_announcement) && $edit_announcement['priority'] == 'medium') ? 'selected' : ''; ?>>Medium</option>
                                        <option value="high" <?php echo (isset($edit_announcement) && $edit_announcement['priority'] == 'high') ? 'selected' : ''; ?>>High</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="is_active" class="custom-control-input" id="is_active" value="1" <?php echo (isset($edit_announcement) && $edit_announcement['is_active']) ? 'checked' : 'checked'; ?>>
                                        <label class="custom-control-label" for="is_active">Active</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Start Date (Optional)</label>
                                            <input type="date" name="start_date" class="form-control" value="<?php echo isset($edit_announcement) ? $edit_announcement['start_date'] : ''; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>End Date (Optional)</label>
                                            <input type="date" name="end_date" class="form-control" value="<?php echo isset($edit_announcement) ? $edit_announcement['end_date'] : ''; ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary"><?php echo $subaction == 'create' ? 'Create' : 'Update'; ?> Announcement</button>
                                <a href="admin.php?action=announcements" class="btn btn-default">Cancel</a>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>

                    <!-- Email Templates -->
                    <?php if ($action == 'email_templates'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Email Templates</h3>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Subject</th>
                                        <th>Variables</th>
                                        <th>Status</th>
                                        <th>Last Updated</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($templates as $template): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($template['name']); ?></td>
                                        <td><?php echo htmlspecialchars($template['subject']); ?></td>
                                        <td><?php echo htmlspecialchars($template['variables']); ?></td>
                                        <td>
                                            <span class="badge badge-<?php echo $template['is_active'] ? 'success' : 'secondary'; ?>">
                                                <?php echo $template['is_active'] ? 'Active' : 'Inactive'; ?>
                                            </span>
                                        </td>
                                        <td><?php echo date('M j, Y', strtotime($template['updated_at'])); ?></td>
                                        <td>
                                            <a href="admin.php?action=email_templates&subaction=edit&id=<?php echo $template['id']; ?>" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                    <?php if (empty($templates)): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No email templates found</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Edit Email Template -->
                    <?php if ($action == 'email_templates' && $subaction == 'edit' && isset($edit_template)): ?>
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">Edit Email Template: <?php echo htmlspecialchars($edit_template['name']); ?></h3>
                        </div>
                        <form method="POST">
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($edit_template['name']); ?>" disabled>
                                </div>
                                <div class="form-group">
                                    <label>Subject *</label>
                                    <input type="text" name="subject" class="form-control" value="<?php echo htmlspecialchars($edit_template['subject']); ?>" required>
                                </div>
                                <div class="form-group">
                                    <label>Content *</label>
                                    <textarea name="content" class="form-control" rows="10" required><?php echo htmlspecialchars($edit_template['content']); ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label>Available Variables</label>
                                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($edit_template['variables']); ?>" disabled>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="is_active" class="custom-control-input" id="is_active_template" value="1" <?php echo $edit_template['is_active'] ? 'checked' : ''; ?>>
                                        <label class="custom-control-label" for="is_active_template">Active</label>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">Update Template</button>
                                <a href="admin.php?action=email_templates" class="btn btn-default">Cancel</a>
                            </div>
                        </form>
                    </div>
                    <?php endif; ?>

                    <!-- Reports & Analytics -->
                    <?php if ($action == 'reports'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Reports & Analytics</h3>
                            <div class="card-tools">
                                <form method="GET" class="form-inline">
                                    <input type="hidden" name="action" value="reports">
                                    <select name="type" class="form-control form-control-sm mr-2">
                                        <option value="usage" <?php echo $report_type == 'usage' ? 'selected' : ''; ?>>Usage Statistics</option>
                                        <option value="users" <?php echo $report_type == 'users' ? 'selected' : ''; ?>>User Activity</option>
                                        <option value="credits" <?php echo $report_type == 'credits' ? 'selected' : ''; ?>>Credit Transactions</option>
                                    </select>
                                    <input type="date" name="start_date" class="form-control form-control-sm mr-2" value="<?php echo $start_date; ?>">
                                    <span class="mr-2">to</span>
                                    <input type="date" name="end_date" class="form-control form-control-sm mr-2" value="<?php echo $end_date; ?>">
                                    <button type="submit" class="btn btn-sm btn-primary">Generate Report</button>
                                </form>
                            </div>
                        </div>
                        <div class="card-body">
                            <?php if ($report_type == 'usage'): ?>
                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Active Users</span>
                                            <span class="info-box-number"><?php echo $usage_stats['active_users']; ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success"><i class="fas fa-sticky-note"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Total Notes</span>
                                            <span class="info-box-number"><?php echo $usage_stats['total_notes']; ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-warning"><i class="fas fa-robot"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">AI Notes</span>
                                            <span class="info-box-number"><?php echo $usage_stats['ai_notes']; ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-primary"><i class="fas fa-font"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">Avg Words</span>
                                            <span class="info-box-number"><?php echo round($usage_stats['avg_words']); ?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">Daily Usage Trend</h3>
                                </div>
                                <div class="card-body">
                                    <div class="chart-container">
                                        <canvas id="usageChart"></canvas>
                                    </div>
                                </div>
                            </div>

                            <?php elseif ($report_type == 'users'): ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>User</th>
                                            <th>Email</th>
                                            <th>School</th>
                                            <th>Total Notes</th>
                                            <th>AI Notes</th>
                                            <th>Last Activity</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($user_activity as $user): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($user['full_name']); ?> (<?php echo htmlspecialchars($user['username']); ?>)</td>
                                            <td><?php echo htmlspecialchars($user['email']); ?></td>
                                            <td><?php echo htmlspecialchars($user['school']); ?></td>
                                            <td><?php echo $user['note_count']; ?></td>
                                            <td><?php echo $user['ai_note_count']; ?></td>
                                            <td><?php echo $user['last_note_date'] ? date('M j, Y', strtotime($user['last_note_date'])) : 'No activity'; ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>

                            <?php elseif ($report_type == 'credits'): ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>User</th>
                                            <th>Credits</th>
                                            <th>Type</th>
                                            <th>Description</th>
                                            <th>Admin</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($credit_transactions as $transaction): ?>
                                        <tr>
                                            <td><?php echo date('M j, Y H:i', strtotime($transaction['created_at'])); ?></td>
                                            <td><?php echo htmlspecialchars($transaction['username']); ?></td>
                                            <td class="<?php echo $transaction['credits'] > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo $transaction['credits'] > 0 ? '+' : ''; ?><?php echo $transaction['credits']; ?>
                                            </td>
                                            <td><?php echo ucfirst($transaction['type']); ?></td>
                                            <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                                            <td><?php echo $transaction['admin_username'] ?? 'System'; ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- System Logs -->
                    <?php if ($action == 'system_logs'): ?>
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">System Logs</h3>
                            <div class="card-tools">
                                <form method="GET" class="form-inline">
                                    <input type="hidden" name="action" value="system_logs">
                                    <div class="input-group input-group-sm">
                                        <input type="text" name="search" class="form-control" placeholder="Search logs..." value="<?php echo htmlspecialchars($search ?? ''); ?>">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-default"><i class="fas fa-search"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-striped log-table">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>User</th>
                                        <th>Action</th>
                                        <th>Description</th>
                                        <th>IP Address</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($logs as $log): ?>
                                    <tr>
                                        <td><?php echo date('M j, H:i', strtotime($log['created_at'])); ?></td>
                                        <td><?php echo $log['username'] ? htmlspecialchars($log['username']) : 'System'; ?></td>
                                        <td><?php echo htmlspecialchars($log['action']); ?></td>
                                        <td><?php echo htmlspecialchars($log['description']); ?></td>
                                        <td><?php echo htmlspecialchars($log['ip_address']); ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                    <?php if (empty($logs)): ?>
                                    <tr>
                                        <td colspan="5" class="text-center">No system logs found</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer clearfix">
                            <ul class="pagination pagination-sm m-0 float-right">
                                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                    <a class="page-link" href="admin.php?action=system_logs&page=<?php echo $i; ?><?php echo $search ? '&search=' . urlencode($search) : ''; ?>"><?php echo $i; ?></a>
                                </li>
                                <?php endfor; ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- System Tools -->
                    <?php if ($action == 'system'): ?>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card card-danger">
                                <div class="card-header">
                                    <h3 class="card-title">System Maintenance</h3>
                                </div>
                                <div class="card-body">
                                    <p>Use these tools to perform system maintenance tasks.</p>
                                    <form method="POST" action="admin.php?action=system&subaction=clear_cache">
                                        <button type="submit" class="btn btn-warning">
                                            <i class="fas fa-broom"></i> Clear System Cache
                                        </button>
                                    </form>
                                    <hr>
                                    <form method="POST" action="admin.php?action=system&subaction=backup_db">
                                        <button type="submit" class="btn btn-info">
                                            <i class="fas fa-database"></i> Backup Database
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card card-info">
                                <div class="card-header">
                                    <h3 class="card-title">System Information</h3>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <strong>PHP Version:</strong>
                                        </div>
                                        <div class="col-6">
                                            <?php echo phpversion(); ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <strong>Database:</strong>
                                        </div>
                                        <div class="col-6">
                                            MySQL
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <strong>Server Software:</strong>
                                        </div>
                                        <div class="col-6">
                                            <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <strong>Server Name:</strong>
                                        </div>
                                        <div class="col-6">
                                            <?php echo $_SERVER['SERVER_NAME'] ?? 'Unknown'; ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-6">
                                            <strong>System Time:</strong>
                                        </div>
                                        <div class="col-6">
                                            <?php echo date('Y-m-d H:i:s'); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                </div>
            </section>
        </div>

        <!-- Footer -->
        <footer class="main-footer">
            <strong>Copyright &copy; 2025 <a href="https://orion.vinesubtech.com.ng">VineSub Tech</a>.</strong>
            All rights reserved.
            <div class="float-right d-none d-sm-inline-block">
                <b>Version</b> 2.0
            </div>
        </footer>
    </div>

    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js"></script>

    <script>
    // Initialize AdminLTE
    $('[data-widget="pushmenu"]').PushMenu();

    // Dashboard Chart
    <?php if ($action == 'dashboard' && isset($note_trends)): ?>
    const notesCtx = document.getElementById('notesChart').getContext('2d');
    const notesChart = new Chart(notesCtx, {
        type: 'line',
        data: {
            labels: [<?php echo implode(',', array_map(function($item) { return "'" . date('M j', strtotime($item['date'])) . "'"; }, $note_trends)); ?>],
            datasets: [{
                label: 'Notes Created',
                data: [<?php echo implode(',', array_column($note_trends, 'count')); ?>],
                backgroundColor: 'rgba(60, 141, 188, 0.2)',
                borderColor: 'rgba(60, 141, 188, 1)',
                borderWidth: 2,
                tension: 0.3,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });
    <?php endif; ?>

    // Usage Chart for Reports
    <?php if ($action == 'reports' && $report_type == 'usage' && isset($daily_usage)): ?>
    const usageCtx = document.getElementById('usageChart').getContext('2d');
    const usageChart = new Chart(usageCtx, {
        type: 'bar',
        data: {
            labels: [<?php echo implode(',', array_map(function($item) { return "'" . date('M j', strtotime($item['date'])) . "'"; }, $daily_usage)); ?>],
            datasets: [
                {
                    label: 'Notes Created',
                    data: [<?php echo implode(',', array_column($daily_usage, 'note_count')); ?>],
                    backgroundColor: 'rgba(60, 141, 188, 0.7)',
                    borderColor: 'rgba(60, 141, 188, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Active Users',
                    data: [<?php echo implode(',', array_column($daily_usage, 'user_count')); ?>],
                    backgroundColor: 'rgba(0, 166, 90, 0.7)',
                    borderColor: 'rgba(0, 166, 90, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });
    <?php endif; ?>

    // Delete note function
    function deleteNote(noteId) {
        if (confirm('Are you sure you want to delete this note?')) {
            $.post('admin_ajax.php', {
                action: 'delete_note',
                id: noteId
            }, function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            }).fail(function() {
                alert('Error deleting note');
            });
        }
    }

    // Helper functions
    function time_ago(date) {
        const now = new Date();
        const past = new Date(date);
        const diff = Math.floor((now - past) / 1000);
        
        if (diff < 60) return 'just now';
        if (diff < 3600) return Math.floor(diff / 60) + 'm ago';
        if (diff < 86400) return Math.floor(diff / 3600) + 'h ago';
        return Math.floor(diff / 86400) + 'd ago';
    }
    </script>
</body>
</html>