<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_noteai');
define('DB_USER', 'fuzesale_noteai');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Vine AI Note Maker - NERDC Compliant');
define('SITE_URL', 'http://p.vinesubtech.com.ng/noteaiv7');

// Start session
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Redirect admin users to admin panel
if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin') {
    header('Location: admin.php');
    exit();
}

// Database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT username, full_name, school, note_credits FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Get note statistics
$stmt = $pdo->prepare("SELECT COUNT(*) as total_notes FROM notes WHERE user_id = ?");
$stmt->execute([$user_id]);
$total_notes = $stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT COUNT(*) as today_notes FROM notes WHERE user_id = ? AND DATE(created_at) = CURDATE()");
$stmt->execute([$user_id]);
$today_notes = $stmt->fetchColumn();

// Get recent notes
$stmt = $pdo->prepare("SELECT id, topic, age_group, created_at FROM notes WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
$stmt->execute([$user_id]);
$recent_notes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?php echo SITE_NAME; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <nav class="navbar">
            <div class="nav-container">
                <div class="nav-logo">
                    <i class="fas fa-book-open"></i>
                    <span><?php echo SITE_NAME; ?></span>
                </div>
                <div class="nav-menu">
                    <a href="dashboard.php" class="nav-link active"><i class="fas fa-home"></i> Dashboard</a>
                    <a href="notes.php" class="nav-link"><i class="fas fa-sticky-note"></i> Notes</a>
                    <a href="profile.php" class="nav-link"><i class="fas fa-user"></i> Profile</a>
                    <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
                    <a href="admin.php" class="nav-link"><i class="fas fa-cog"></i> Admin</a>
                    <?php endif; ?>
                    <a href="logout.php" class="nav-link btn-logout"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
                <div class="hamburger">
                    <span class="bar"></span>
                    <span class="bar"></span>
                    <span class="bar"></span>
                </div>
            </div>
        </nav>
    </header>

    <main class="dashboard-main">
        <div class="dashboard-container">
            <div class="dashboard-header">
                <h1>Welcome, <?php echo htmlspecialchars($user['full_name']); ?>!</h1>
                <p>Here's your teaching assistant dashboard</p>
            </div>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-sticky-note"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $total_notes; ?></h3>
                        <p>Total Notes</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $today_notes; ?></h3>
                        <p>Today's Notes</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-coins"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo $user['note_credits']; ?></h3>
                        <p>Remaining Credits</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon">
                        <i class="fas fa-school"></i>
                    </div>
                    <div class="stat-info">
                        <h3><?php echo htmlspecialchars($user['school'] ?: 'Not set'); ?></h3>
                        <p>Your School</p>
                    </div>
                </div>
            </div>
            
            <div class="dashboard-actions">
                <a href="notes.php?action=create" class="action-card">
                    <i class="fas fa-plus-circle"></i>
                    <h3>Create New Note</h3>
                    <p>Generate a new lesson note</p>
                </a>
                
                <a href="notes.php" class="action-card">
                    <i class="fas fa-list"></i>
                    <h3>View All Notes</h3>
                    <p>Browse your lesson notes</p>
                </a>
                
                <a href="profile.php" class="action-card">
                    <i class="fas fa-user-edit"></i>
                    <h3>Edit Profile</h3>
                    <p>Update your information</p>
                </a>
            </div>
            
            <div class="recent-notes">
                <h2>Recent Notes</h2>
                <?php if (count($recent_notes) > 0): ?>
                <div class="notes-list">
                    <?php foreach ($recent_notes as $note): ?>
                    <div class="note-item">
                        <h3><?php echo htmlspecialchars($note['topic']); ?></h3>
                        <p>Age Group: <?php echo $note['age_group']; ?> years</p>
                        <p>Created: <?php echo date('M j, Y', strtotime($note['created_at'])); ?></p>
                        <div class="note-actions">
                            <a href="notes.php?action=view&id=<?php echo $note['id']; ?>" class="btn btn-sm btn-primary">View</a>
                            <a href="notes.php?action=edit&id=<?php echo $note['id']; ?>" class="btn btn-sm btn-secondary">Edit</a>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php else: ?>
                <p>You haven't created any notes yet. <a href="notes.php?action=create">Create your first note</a>.</p>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <footer>
        <div class="footer-content">
            <div class="footer-section">
                <h3><?php echo SITE_NAME; ?></h3>
                <p>Empowering educators with AI-powered lesson planning tools.</p>
            </div>
            <div class="footer-section">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="notes.php">Notes</a></li>
                    <li><a href="profile.php">Profile</a></li>
                </ul>
            </div>
            <div class="footer-section">
                <h3>Contact</h3>
                <p><i class="fas fa-envelope"></i> support@vinesubtech.com.ng</p>
            </div>
        </div>
        <div class="footer-bottom">
            <p>Copyright © 2025 - ORION HUB | Powered by <a href="https://orion.vinesubtech.com.ng" target="_blank">VineSub Tech</a>. All rights reserved.</p>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>