<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_noteai');
define('DB_USER', 'fuzesale_noteai');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Vine AI Note Maker - NERDC Compliant');
define('SITE_URL', 'http://p.vinesubtech.com.ng/noteaiv7');

// Start session
session_start();

// Check if user is logged in, redirect to dashboard
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <nav class="navbar">
            <div class="nav-container">
                <div class="nav-logo">
                    <i class="fas fa-book-open"></i>
                    <span><?php echo SITE_NAME; ?></span>
                </div>
                <div class="nav-menu">
                    <a href="#features" class="nav-link">Features</a>
                    <a href="#how-it-works" class="nav-link">How It Works</a>
                    <a href="#about" class="nav-link">About</a>
                    <a href="login.php" class="nav-link btn-login">Login</a>
                    <a href="register.php" class="nav-link btn-register">Register</a>
                </div>
                <div class="hamburger">
                    <span class="bar"></span>
                    <span class="bar"></span>
                    <span class="bar"></span>
                </div>
            </div>
        </nav>
    </header>

    <main>
        <section class="hero">
            <div class="hero-content">
                <h1>Revolutionize Your Lesson Planning</h1>
                <p>AI-powered lesson note generation tailored to the Nigerian curriculum. Save time and focus on teaching.</p>
                <div class="hero-buttons">
                    <a href="register.php" class="btn btn-primary">Get Started</a>
                    <a href="#demo" class="btn btn-secondary">See Demo</a>
                </div>
            </div>
            <div class="hero-image">
                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAwIiBoZWlnaHQ9IjQwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiBmaWxsPSIjZTVlNWU1Ii8+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoNTAsIDUwKSI+PGNpcmNsZSBjeD0iMjAwIiBjeT0iMTUwIiByPSI4MCIgZmlsbD0iIzM0OThkYiIvPjxwYXRoIGQ9Ik0xMDAgMjUwIEwyMDAgMTUwIEwzMDAgMjUwIiBzdHJva2U9IiMyYzNlNTAiIHN0cm9rZS13aWR0aD0iNCIgZmlsbD0ibm9uZSIvPjx0ZXh0IHg9IjIwMCIgeT0iMjgwIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmb250LWZhbWlseT0iQXJpYWwiIGZvbnQtc2l6ZT0iMjAiIGZvbnQtd2VpZ2h0PSJib2xkIj5MZXNzb24gTm90ZXM8L3RleHQ+PHRleHQgeD0iMjAwIiB5PSIzMTAiIHRleHQtYW5jaG9yPSJtaWRkbGUiIGZvbnQtZmFtaWx5PSJBcmlhbCIgZm9udC1zaXplPSIxNiI+R2VuZXJhdGVkIGJ5IEFJPC90ZXh0PjwvZz48L3N2Zz4=" alt="Lesson Note Generation">
            </div>
        </section>

        <section id="features" class="features">
            <h2>Powerful Features</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <i class="fas fa-robot"></i>
                    <h3>AI-Powered</h3>
                    <p>Generate comprehensive lesson notes using advanced AI technology.</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-graduation-cap"></i>
                    <h3>Curriculum-Aligned</h3>
                    <p>Notes tailored to the Nigerian educational curriculum standards.</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-clock"></i>
                    <h3>Time-Saving</h3>
                    <p>Reduce lesson planning time from hours to minutes.</p>
                </div>
                <div class="feature-card">
                    <i class="fas fa-mobile-alt"></i>
                    <h3>Mobile-Friendly</h3>
                    <p>Access your notes from any device, anywhere.</p>
                </div>
            </div>
        </section>

        <section id="how-it-works" class="how-it-works">
            <h2>How It Works</h2>
            <div class="steps">
                <div class="step">
                    <div class="step-number">1</div>
                    <h3>Sign Up</h3>
                    <p>Create your teacher account with your details.</p>
                </div>
                <div class="step">
                    <div class="step-number">2</div>
                    <h3>Enter Details</h3>
                    <p>Provide the topic and student age for your lesson note.</p>
                </div>
                <div class="step">
                    <div class="step-number">3</div>
                    <h3>Generate</h3>
                    <p>Let our AI create a comprehensive lesson note for you.</p>
                </div>
                <div class="step">
                    <div class="step-number">4</div>
                    <h3>Customize & Use</h3>
                    <p>Edit, download, or print your ready-to-use lesson note.</p>
                </div>
            </div>
        </section>

        <section id="demo" class="demo">
            <h2>See It In Action</h2>
            <div class="demo-container">
                <div class="demo-card">
                    <h3>Sample Lesson Note</h3>
                    <div class="demo-content">
                        <p><strong>Topic:</strong> Introduction to Photosynthesis</p>
                        <p><strong>Age Group:</strong> 12 years</p>
                        <p><strong>Learning Objectives:</strong> Students will understand the process of photosynthesis and its importance.</p>
                        <p><strong>Key Points:</strong> Chlorophyll, sunlight, carbon dioxide, water, glucose, oxygen</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="about" class="about">
            <h2>About VineSub Tech</h2>
            <p>VineSub Tech is dedicated to creating innovative educational technology solutions for Nigerian educators. Our mission is to empower teachers with tools that enhance productivity and improve learning outcomes.</p>
            <div class="about-info">
                <div class="info-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <span>Nigeria</span>
                </div>
                <div class="info-item">
                    <i class="fas fa-envelope"></i>
                    <span>info@vinesubtech.com.ng</span>
                </div>
                <div class="info-item">
                    <i class="fas fa-globe"></i>
                    <span>www.vinesubtech.com.ng</span>
                </div>
            </div>
        </section>
    </main>

    <footer>
        <div class="footer-content">
            <div class="footer-section">
                <h3><?php echo SITE_NAME; ?></h3>
                <p>Empowering educators with AI-powered lesson planning tools.</p>
            </div>
            <div class="footer-section">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="#features">Features</a></li>
                    <li><a href="#how-it-works">How It Works</a></li>
                    <li><a href="#about">About</a></li>
                    <li><a href="login.php">Login</a></li>
                    <li><a href="register.php">Register</a></li>
                </ul>
            </div>
            <div class="footer-section">
                <h3>Contact</h3>
                <p><i class="fas fa-envelope"></i> support@vinesubtech.com.ng</p>
                <p><i class="fas fa-phone"></i> +234 XXX-XXXX-XXX</p>
            </div>
        </div>
        <div class="footer-bottom">
            <p>Copyright © 2025 - ORION HUB | Powered by <a href="https://orion.vinesubtech.com.ng" target="_blank">VineSub Tech</a>. All rights reserved.</p>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>