<?php
require_once '../config.php';
requireLogin();

header('Content-Type: application/json');

try {
    $user_settings = getUserSettings($_SESSION['user_id']);
    echo json_encode([
        'success' => true,
        'ai_api_key' => $user_settings['ai_api_key'] ?? null,
        'flutterwave_api_key' => $user_settings['flutterwave_api_key'] ?? null
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>