<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_bulkai');
define('DB_USER', 'fuzesale_bulkai');
define('DB_PASS', '!!!###1985ENi!!!');

// App configuration
define('APP_NAME', 'Bulk AI Writer');
define('APP_VERSION', '1.0');

// Session configuration
session_start();

// Database connection
function getDB() {
    static $db = null;
    if ($db === null) {
        try {
            $db = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
            $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch(PDOException $e) {
            die("Database connection failed: " . $e->getMessage());
        }
    }
    return $db;
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Check if user is admin
function isAdmin() {
    return isset($_SESSION['user_id']) && isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true;
}

// Redirect if not logged in
function requireLogin() {
    if (!isLoggedIn()) {
        header("Location: index.php");
        exit();
    }
}

// Redirect if not admin
function requireAdmin() {
    requireLogin();
    if (!isAdmin()) {
        header("Location: bulkwriter.php");
        exit();
    }
}

// Get app setting
function getAppSetting($key, $default = null) {
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT setting_value FROM app_settings WHERE setting_key = ?");
        $stmt->execute([$key]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result ? $result['setting_value'] : $default;
    } catch (Exception $e) {
        return $default;
    }
}

// Get AI personas
function getAIPersonas() {
    try {
        $db = getDB();
        $stmt = $db->query("SELECT * FROM ai_personas WHERE is_active = TRUE ORDER BY name");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        return [];
    }
}

// Get content types
function getContentTypes() {
    try {
        $db = getDB();
        $stmt = $db->query("SELECT * FROM content_types WHERE is_active = TRUE ORDER BY name");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        return [];
    }
}

// Get user settings
function getUserSettings($user_id) {
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM user_settings WHERE user_id = ?");
        $stmt->execute([$user_id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        return null;
    }
}

// Save user settings
function saveUserSettings($user_id, $settings) {
    try {
        $db = getDB();
        $existing = getUserSettings($user_id);
        
        if ($existing) {
            $stmt = $db->prepare("UPDATE user_settings SET ai_api_key = ?, default_prompt = ?, updated_at = NOW() WHERE user_id = ?");
            $stmt->execute([
                $settings['ai_api_key'] ?? null,
                $settings['default_prompt'] ?? null,
                $user_id
            ]);
        } else {
            $stmt = $db->prepare("INSERT INTO user_settings (user_id, ai_api_key, default_prompt) VALUES (?, ?, ?)");
            $stmt->execute([
                $user_id,
                $settings['ai_api_key'] ?? null,
                $settings['default_prompt'] ?? null
            ]);
        }
        return true;
    } catch (Exception $e) {
        error_log("Error saving user settings: " . $e->getMessage());
        return false;
    }
}

// Get user notifications
function getUserNotifications($user_id, $unread_only = false) {
    try {
        $db = getDB();
        if ($unread_only) {
            $stmt = $db->prepare("SELECT * FROM notifications WHERE (user_id = ? OR user_id IS NULL) AND is_read = FALSE ORDER BY created_at DESC");
            $stmt->execute([$user_id]);
        } else {
            $stmt = $db->prepare("SELECT * FROM notifications WHERE user_id = ? OR user_id IS NULL ORDER BY created_at DESC LIMIT 10");
            $stmt->execute([$user_id]);
        }
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        return [];
    }
}

// Mark notification as read
function markNotificationAsRead($notification_id, $user_id) {
    try {
        $db = getDB();
        $stmt = $db->prepare("UPDATE notifications SET is_read = TRUE WHERE id = ? AND (user_id = ? OR user_id IS NULL)");
        return $stmt->execute([$notification_id, $user_id]);
    } catch (Exception $e) {
        return false;
    }
}

// Check if user is admin by ID
function isUserAdmin($user_id) {
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT is_admin FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        return $user && $user['is_admin'] == 1;
    } catch (Exception $e) {
        return false;
    }
}
?>