$(document).ready(function() {
    // Modal elements
    const modal = document.getElementById("paymentModal");
    const buyKeyBtn = document.getElementById("buyKeyBtn");
    const closeBtn = document.querySelector(".close-btn");
    const paymentFormContainer = document.getElementById("paymentFormContainer");
    const keyDisplayContainer = document.getElementById("keyDisplayContainer");
    const payNowBtn = document.getElementById("payNowBtn");
    const copyKeyBtn = document.getElementById("copyKeyBtn");
    const downloadKeyBtn = document.getElementById("downloadKeyBtn");
    const goBackBtn = document.getElementById("goBackBtn");
    const generatedKeyInput = document.getElementById("generatedKey");
    
    let purchasedKey = "";
    
    // Open modal
    buyKeyBtn.onclick = function() {
        modal.style.display = "block";
    }
    
    // Close modal
    closeBtn.onclick = function() {
        modal.style.display = "none";
    }
    
    // Go back button
    goBackBtn.onclick = function() {
        keyDisplayContainer.style.display = "none";
        paymentFormContainer.style.display = "block";
        window.location.href = "https://eai8.com.ng";
    }
    
    // Copy key button
    copyKeyBtn.onclick = function() {
        generatedKeyInput.select();
        document.execCommand("copy");
        alert("Key copied to clipboard!");
    }
    
    // Download key button
    downloadKeyBtn.onclick = function() {
        const key = generatedKeyInput.value;
        const blob = new Blob([key], { type: "text/plain" });
        const url = URL.createObjectURL(blob);
        const a = document.createElement("a");
        a.href = url;
        a.download = "purchased_key.txt";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
        
        // Delete the key from server
        $.post("process.php", { action: "delete_key", key: key }, function(response) {
            console.log("Key deleted from server");
        });
    }
    
    // Pay now button
    payNowBtn.onclick = function() {
        const email = document.getElementById("email").value;
        const name = document.getElementById("name").value;
        const amount = document.getElementById("amount").value;
        
        if (!email || !name) {
            alert("Please fill in all fields");
            return;
        }
        
        // Make AJAX call to get a key first
        $.post("process.php", { action: "get_key" }, function(response) {
            if (response.status === "success") {
                purchasedKey = response.key;
                
                // Initialize Flutterwave payment
                FlutterwaveCheckout({
                    public_key: "FLWPUBK_TEST-xxxxxxxxxxxxxxxxxxxxxxxxxxxx-X", // Replace with your public key
                    tx_ref: "KEY_" + Date.now(),
                    amount: amount,
                    currency: "USD",
                    payment_options: "card, banktransfer, ussd",
                    redirect_url: "",
                    customer: {
                        email: email,
                        name: name,
                    },
                    callback: function(data) {
                        if (data.status === "successful") {
                            // Payment successful, show the key
                            paymentFormContainer.style.display = "none";
                            keyDisplayContainer.style.display = "block";
                            generatedKeyInput.value = purchasedKey;
                        } else {
                            alert("Payment failed. Please try again.");
                            // Return the key to the pool if payment fails
                            $.post("process.php", { action: "return_key", key: purchasedKey });
                        }
                    },
                    onclose: function() {
                        // Return the key to the pool if payment is closed
                        $.post("process.php", { action: "return_key", key: purchasedKey });
                    },
                    customizations: {
                        title: "Premium Key Purchase",
                        description: "Payment for unique access key",
                        logo: "https://eai8.com.ng/logo.png", // Replace with your logo
                    },
                });
            } else {
                alert("Sorry, no keys available at the moment.");
            }
        }, "json");
    };
    
    // Close modal when clicking outside
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
});