<?php
// Initialize keys if the file doesn't exist
if (!file_exists('keys.json')) {
    $initialKeys = ['YHGDETH', 'GFFGHJN', 'LUYDZRY', 'KIUTFVJ', 'HFDTYJN', 'HFZDTP', 'GTUESSV'];
    file_put_contents('keys.json', json_encode($initialKeys));
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Key Seller</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="assets/style.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6 text-center">
                <h1 class="mb-4">VINE ACCESS KEY</h1>
                <p class="lead mb-4">Get your Vine Access key</p>
                <button id="buyKeyBtn" class="btn btn-primary btn-lg">Buy Key</button>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    <div id="paymentModal" class="modal">
        <div class="modal-content">
            <span class="close-btn">&times;</span>
            <div id="paymentFormContainer">
                <h3>Purchase Key</h3>
                <p>Price: $10.00</p>
                <form id="paymentForm">
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" id="email" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="name">Full Name</label>
                        <input type="text" id="name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="amount">Amount ($)</label>
                        <input type="number" id="amount" class="form-control" value="10" readonly required>
                    </div>
                    <button type="button" id="payNowBtn" class="btn btn-primary mt-3">Pay Now</button>
                </form>
            </div>
            
            <div id="keyDisplayContainer" style="display: none;">
                <h3>Your Key</h3>
                <div class="key-display">
                    <input type="text" id="generatedKey" readonly class="form-control mb-3">
                    <div class="d-flex justify-content-center gap-3">
                        <button id="copyKeyBtn" class="btn btn-secondary"><i class="fas fa-copy"></i> Copy</button>
                        <button id="downloadKeyBtn" class="btn btn-success"><i class="fas fa-download"></i> Download</button>
                    </div>
                </div>
                <button id="goBackBtn" class="btn btn-link mt-3"><i class="fas fa-arrow-left"></i> Go Back</button>
            </div>
        </div>
    </div>

    <!-- Include Flutterwave inline script -->
    <script src="https://checkout.flutterwave.com/v3.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="assets/script.js"></script>
</body>
</html>