<?php
header('Content-Type: application/json');

// Initialize keys file if it doesn't exist
$keysFile = 'keys.json';
if (!file_exists($keysFile)) {
    $initialKeys = ['YHGDETH', 'GFFGHJN', 'LUYDZRY', 'KIUTFVJ', 'HFDTYJN', 'HFZDTP', 'GTUESSV'];
    file_put_contents($keysFile, json_encode($initialKeys));
}

// Get current keys
$keys = json_decode(file_get_contents($keysFile), true);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    switch ($action) {
        case 'get_key':
            if (!empty($keys)) {
                // Get a random key
                $randomIndex = array_rand($keys);
                $selectedKey = $keys[$randomIndex];
                
                // Remove the key from the array temporarily
                unset($keys[$randomIndex]);
                file_put_contents($keysFile, json_encode(array_values($keys)));
                
                echo json_encode(['status' => 'success', 'key' => $selectedKey]);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'No keys available']);
            }
            break;
            
        case 'return_key':
            $key = $_POST['key'] ?? '';
            if (!empty($key)) {
                // Add the key back to the pool
                if (!in_array($key, $keys)) {
                    $keys[] = $key;
                    file_put_contents($keysFile, json_encode($keys));
                }
                echo json_encode(['status' => 'success']);
            } else {
                echo json_encode(['status' => 'error']);
            }
            break;
            
        case 'delete_key':
            // Key is already removed during get_key, no need to do anything
            echo json_encode(['status' => 'success']);
            break;
            
        default:
            echo json_encode(['status' => 'error', 'message' => 'Invalid action']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>