<?php
session_start();
require_once 'database.php';

// Handle registration
if ($_POST['action'] === 'register') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    
    if (empty($email) || empty($password)) {
        echo json_encode(['success' => false, 'error' => 'Email and password are required']);
        exit;
    }
    
    if ($password !== $confirm_password) {
        echo json_encode(['success' => false, 'error' => 'Passwords do not match']);
        exit;
    }
    
    $db = new Database();
    $result = $db->registerUser($email, $password);
    
    if ($result['success']) {
        $_SESSION['user_id'] = $result['user_id'];
        $_SESSION['user_email'] = $email;
        echo json_encode(['success' => true, 'redirect' => 'project_manager.php']);
    } else {
        echo json_encode(['success' => false, 'error' => $result['error']]);
    }
    exit;
}

// Handle login
if ($_POST['action'] === 'login') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        echo json_encode(['success' => false, 'error' => 'Email and password are required']);
        exit;
    }
    
    $db = new Database();
    $user = $db->loginUser($email, $password);
    
    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_email'] = $user['email'];
        echo json_encode(['success' => true, 'redirect' => 'project_manager.php']);
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid email or password']);
    }
    exit;
}

// Check if user is logged in
if ($_POST['action'] === 'check_auth') {
    if (isset($_SESSION['user_id'])) {
        echo json_encode(['authenticated' => true, 'email' => $_SESSION['user_email']]);
    } else {
        echo json_encode(['authenticated' => false]);
    }
    exit;
}
?>