<?php
session_start();
require_once 'database.php';

// Auto-setup database on first visit
if (!isset($_SESSION['db_checked'])) {
    $db = new Database();
    $db->autoSetup();
    $_SESSION['db_checked'] = true;
}

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header('Location: project_manager.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulk AI Content Writer - Login</title>
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css" rel="stylesheet">
    <link rel="stylesheet" href="styles.css">
</head>
<body class="auth-body">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <h1><i class="mdi mdi-content-paste"></i> Bulk AI Content Writer</h1>
                <p>Turn 50 topics into a dominant, SEO-empowered content library in one click</p>
            </div>

            <div id="auth-messages"></div>

            <div class="auth-tabs">
                <button class="tab-button active" data-tab="login">Login</button>
                <button class="tab-button" data-tab="register">Register</button>
            </div>

            <div class="tab-content active" id="login-tab">
                <form id="login-form" class="auth-form">
                    <div class="form-group">
                        <label><i class="mdi mdi-email"></i> Email</label>
                        <input type="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label><i class="mdi mdi-lock"></i> Password</label>
                        <input type="password" name="password" required>
                    </div>
                    <button type="submit" class="auth-button">
                        <i class="mdi mdi-login"></i> Login
                    </button>
                </form>
            </div>

            <div class="tab-content" id="register-tab">
                <form id="register-form" class="auth-form">
                    <div class="form-group">
                        <label><i class="mdi mdi-email"></i> Email</label>
                        <input type="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label><i class="mdi mdi-lock"></i> Password</label>
                        <input type="password" name="password" required minlength="6">
                    </div>
                    <div class="form-group">
                        <label><i class="mdi mdi-lock-check"></i> Confirm Password</label>
                        <input type="password" name="confirm_password" required minlength="6">
                    </div>
                    <button type="submit" class="auth-button">
                        <i class="mdi mdi-account-plus"></i> Register
                    </button>
                </form>
            </div>

            <div class="auth-features">
                <h3><i class="mdi mdi-star-circle"></i> Key Features</h3>
                <ul>
                    <li><i class="mdi mdi-check"></i> Generate 50+ articles simultaneously</li>
                    <li><i class="mdi mdi-link-variant"></i> Intelligent internal linking</li>
                    <li><i class="mdi mdi-seo"></i> SEO-optimized content</li>
                    <li><i class="mdi mdi-export"></i> Bulk export capabilities</li>
                    <li><i class="mdi mdi-api"></i> Multiple API key support</li>
                </ul>
            </div>
        </div>
    </div>

    <script>
        // Tab switching functionality
        document.querySelectorAll('.tab-button').forEach(button => {
            button.addEventListener('click', () => {
                const tab = button.getAttribute('data-tab');
                
                // Update buttons
                document.querySelectorAll('.tab-button').forEach(btn => {
                    btn.classList.remove('active');
                });
                button.classList.add('active');
                
                // Update content
                document.querySelectorAll('.tab-content').forEach(content => {
                    content.classList.remove('active');
                });
                document.getElementById(tab + '-tab').classList.add('active');
            });
        });

        // Show notification
        function showNotification(message, type = 'error') {
            const messagesDiv = document.getElementById('auth-messages');
            const notification = document.createElement('div');
            notification.className = `alert alert-${type}`;
            notification.innerHTML = `
                <i class="mdi mdi-${type === 'success' ? 'check-circle' : 'alert-circle'}"></i>
                <span>${message}</span>
                <button class="alert-close" onclick="this.parentElement.remove()"><i class="mdi mdi-close"></i></button>
            `;
            messagesDiv.innerHTML = '';
            messagesDiv.appendChild(notification);
        }

        // Login form handler
        document.getElementById('login-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            formData.append('action', 'login');
            
            const button = e.target.querySelector('button[type="submit"]');
            const originalText = button.innerHTML;
            button.innerHTML = '<div class="loading-spinner small"></div> Logging in...';
            button.disabled = true;
            
            try {
                const response = await fetch('auth.php', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    showNotification('Login successful! Redirecting...', 'success');
                    setTimeout(() => {
                        window.location.href = result.redirect;
                    }, 1000);
                } else {
                    showNotification(result.error);
                }
            } catch (error) {
                showNotification('Network error. Please try again.');
            } finally {
                button.innerHTML = originalText;
                button.disabled = false;
            }
        });

        // Register form handler
        document.getElementById('register-form').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            formData.append('action', 'register');
            
            const button = e.target.querySelector('button[type="submit"]');
            const originalText = button.innerHTML;
            button.innerHTML = '<div class="loading-spinner small"></div> Registering...';
            button.disabled = true;
            
            try {
                const response = await fetch('auth.php', {
                    method: 'POST',
                    body: formData
                });
                
                const result = await response.json();
                
                if (result.success) {
                    showNotification('Registration successful! Redirecting...', 'success');
                    setTimeout(() => {
                        window.location.href = result.redirect;
                    }, 1000);
                } else {
                    showNotification(result.error);
                }
            } catch (error) {
                showNotification('Network error. Please try again.');
            } finally {
                button.innerHTML = originalText;
                button.disabled = false;
            }
        });
    </script>
</body>
</html>