<?php
function createHeader($active_page = 'project') {
    $user_email = $_SESSION['user_email'] ?? '';
    
    return '
    <header class="main-header">
        <div class="header-container">
            <div class="logo">
                <i class="mdi mdi-content-paste"></i>
                <span>Bulk AI Content Writer</span>
            </div>
            
            <nav class="main-nav">
                <a href="project_manager.php" class="nav-link ' . ($active_page === 'project' ? 'active' : '') . '">
                    <i class="mdi mdi-view-dashboard"></i> Dashboard
                </a>
                <a href="content_generator.php' . (isset($_GET['project_id']) ? '?project_id=' . $_GET['project_id'] : '') . '" class="nav-link ' . ($active_page === 'generator' ? 'active' : '') . '">
                    <i class="mdi mdi-auto-fix"></i> Content Generator
                </a>
            </nav>
            
            <div class="user-menu">
                <div class="user-info">
                    <i class="mdi mdi-account-circle"></i>
                    <span>' . htmlspecialchars($user_email) . '</span>
                </div>
                <div class="theme-toggle">
                    <button id="theme-toggle" class="theme-btn">
                        <i class="mdi mdi-white-balance-sunny"></i>
                    </button>
                </div>
                <a href="logout.php" class="logout-btn">
                    <i class="mdi mdi-logout"></i> Logout
                </a>
            </div>
        </div>
    </header>';
}

function createArticleControls($article_id, $content, $title) {
    return '
    <div class="article-controls">
        <button class="control-btn copy-btn" data-content="' . htmlspecialchars($content) . '" title="Copy Article">
            <i class="mdi mdi-content-copy"></i>
        </button>
        <button class="control-btn export-btn" data-content="' . htmlspecialchars($content) . '" data-title="' . htmlspecialchars($title) . '" title="Export as DOC">
            <i class="mdi mdi-export"></i>
        </button>
        <button class="control-btn regenerate-btn" data-article-id="' . $article_id . '" title="Regenerate">
            <i class="mdi mdi-refresh"></i>
        </button>
        <button class="control-btn pause-btn" style="display: none;" title="Pause Generation">
            <i class="mdi mdi-pause"></i>
        </button>
    </div>';
}

function createProgressBar($progress = 0, $text = '') {
    return '
    <div class="progress-container">
        <div class="progress-header">
            <span class="progress-text">' . htmlspecialchars($text) . '</span>
            <span class="progress-percentage">' . $progress . '%</span>
        </div>
        <div class="progress-bar">
            <div class="progress-fill" style="width: ' . $progress . '%"></div>
        </div>
    </div>';
}

function createEmptyState($icon = 'mdi-file-document-outline', $title = 'No Content', $message = 'Get started by generating some content.') {
    return '
    <div class="empty-state">
        <div class="empty-icon">
            <i class="mdi ' . $icon . '"></i>
        </div>
        <h3>' . htmlspecialchars($title) . '</h3>
        <p>' . htmlspecialchars($message) . '</p>
    </div>';
}

function createAlert($message, $type = 'info') {
    $icons = [
        'info' => 'mdi-information',
        'success' => 'mdi-check-circle',
        'warning' => 'mdi-alert',
        'error' => 'mdi-alert-circle'
    ];
    
    return '
    <div class="alert alert-' . $type . '">
        <i class="mdi ' . ($icons[$type] ?? 'mdi-information') . '"></i>
        <span>' . htmlspecialchars($message) . '</span>
        <button class="alert-close">
            <i class="mdi mdi-close"></i>
        </button>
    </div>';
}

function createLoadingSpinner($size = 'medium') {
    $sizes = [
        'small' => '20px',
        'medium' => '40px',
        'large' => '60px'
    ];
    
    return '
    <div class="loading-spinner ' . $size . '">
        <div class="spinner"></div>
    </div>';
}

function createModal($id, $title, $content, $actions = '') {
    return '
    <div class="modal" id="' . $id . '">
        <div class="modal-overlay"></div>
        <div class="modal-content">
            <div class="modal-header">
                <h3>' . htmlspecialchars($title) . '</h3>
                <button class="modal-close">
                    <i class="mdi mdi-close"></i>
                </button>
            </div>
            <div class="modal-body">
                ' . $content . '
            </div>
            <div class="modal-actions">
                ' . $actions . '
            </div>
        </div>
    </div>';
}

function createArticlePreview($article) {
    return '
    <div class="generated-article" data-article-id="' . $article['id'] . '">
        <div class="article-header">
            <h3>' . htmlspecialchars($article['topic']) . '</h3>
            <div class="article-meta">
                <span><i class="mdi mdi-counter"></i> ' . ($article['word_count'] ?? '0') . ' words</span>
                <span><i class="mdi mdi-calendar"></i> ' . date('M j, H:i', strtotime($article['created_at'])) . '</span>
                <span><i class="mdi mdi-link"></i> ' . ($article['link_count'] ?? '0') . ' internal links</span>
            </div>
        </div>
        <div class="article-content">
            ' . ($article['content'] ?? '') . '
        </div>
        <div class="article-actions">
            ' . createArticleControls($article['id'], $article['content'] ?? '', $article['topic']) . '
        </div>
    </div>';
}

function createSettingsPanel($settings) {
    return '
    <div class="settings-panel">
        <div class="settings-section">
            <h4><i class="mdi mdi-tune"></i> AI Settings</h4>
            <div class="setting-group">
                <label>Temperature</label>
                <input type="range" min="0" max="1" step="0.1" value="' . ($settings['temperature'] ?? '0.7') . '" class="setting-slider">
            </div>
            <div class="setting-group">
                <label>Creativity Level</label>
                <select class="setting-select">
                    <option value="low">Low</option>
                    <option value="medium" selected>Medium</option>
                    <option value="high">High</option>
                </select>
            </div>
        </div>
    </div>';
}
?>