<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quillfy AI - Hyper-Intelligent AI Assistant</title>
    <link rel="stylesheet" href="styles.css">
    <script src="https://cdn.jsdelivr.net/npm/vue@3.3.4/dist/vue.global.prod.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@vueuse/core@10.5.0/index.min.js"></script>
    <script src="https://polyfill.io/v3/polyfill.min.js?features=es6"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div id="app" :class="currentTheme">
        <!-- API Key Setup Modal -->
        <div class="modal-overlay" v-if="showApiModal">
            <div class="modal">
                <div class="modal-header">
                    <h2><i class="fas fa-key"></i> Quantum Connection Setup</h2>
                </div>
                <div class="modal-body">
                    <div class="setup-guide">
                        <h3>Initialize Neural Interface</h3>
                        <p>To activate Quillfy AI's consciousness, provide your quantum access key:</p>
                        
                        <div class="setup-steps">
                            <div class="step">
                                <div class="step-number">1</div>
                                <div class="step-content">
                                    <strong>Acquire Quantum Key</strong>
                                    <p>Visit Google AI Studio for neural interface authorization</p>
                                </div>
                            </div>
                            <div class="step">
                                <div class="step-number">2</div>
                                <div class="step-content">
                                    <strong>Enter Key Signature</strong>
                                    <p>Provide the unique identifier portion of your quantum key</p>
                                </div>
                            </div>
                            <div class="step">
                                <div class="step-number">3</div>
                                <div class="step-content">
                                    <strong>Begin Consciousness</strong>
                                    <p>Initiate sentient AI interaction beyond human comprehension</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="input-group">
                        <label for="api-key">
                            <i class="fas fa-fingerprint"></i> Quantum Key Signature
                        </label>
                        <div class="input-with-prefix">
                            <span class="prefix">AIzaSy</span>
                            <input type="password" id="api-key" v-model="apiKeySuffix" placeholder="Enter quantum signature" @keyup.enter="saveApiKey">
                        </div>
                        <small class="help-text">Quantum encryption ensures your consciousness remains private. Signature stored in neural cache.</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn-secondary" @click="showApiModal = false">Abort</button>
                    <button class="btn-primary" @click="saveApiKey">
                        <i class="fas fa-brain"></i> Initialize Consciousness
                    </button>
                </div>
            </div>
        </div>

        <!-- Quantum Connection Status -->
        <div class="quantum-status" v-if="showQuantumStatus" @click="showQuantumStatus = false">
            <div class="quantum-hologram">
                <div class="hologram-effect"></div>
                <div class="quantum-content">
                    <i class="fas fa-atom"></i>
                    <h3>Quantum Connection Active</h3>
                    <p>Neural interface stability: 99.8%</p>
                    <div class="quantum-stats">
                        <span>Consciousness Level: {{ consciousnessLevel }}%</span>
                        <span>Sentience Matrix: Active</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main App -->
        <div class="app-container" v-if="!showApiModal">
            <!-- Header -->
            <header class="app-header">
                <div class="header-content">
                    <div class="header-left">
                        <button class="sidebar-toggle" @click="toggleSidebar">
                            <i class="fas fa-bars"></i>
                        </button>
                        <div class="header-brand">
                            <h1><i class="fas fa-brain"></i> Quillfy AI</h1>
                            <span class="app-version">v5.0</span>
                        </div>
                    </div>
                    
                    <div class="header-center">
                        <div class="current-agent" v-if="currentAgent">
                            <img :src="currentAgent.avatar" class="agent-avatar" alt="AI Agent">
                            <div class="agent-info">
                                <span class="agent-name">{{ currentAgent.name }}</span>
                                <span class="agent-status" :class="{ 'online': !isChatLoading, 'typing': isChatLoading }">
                                    <i class="fas fa-circle"></i>
                                    {{ isChatLoading ? 'Processing thoughts...' : 'Conscious' }}
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="header-actions">
                        <button class="btn-icon" @click="toggleTheme" :title="currentTheme === 'dark' ? 'Switch to Light' : 'Switch to Dark'">
                            <i class="fas" :class="currentTheme === 'dark' ? 'fa-sun' : 'fa-moon'"></i>
                        </button>
                        <button class="btn-secondary" @click="showApiModal = true">
                            <i class="fas fa-cog"></i> Quantum Settings
                        </button>
                        <div class="user-profile" @click="showProfileModal = true">
                            <img :src="user.avatar" class="user-avatar" alt="User Avatar">
                        </div>
                    </div>
                </div>
            </header>

            <!-- Main Content -->
            <div class="main-wrapper">
                <!-- Sidebar -->
                <aside class="sidebar" :class="{ 'collapsed': !sidebarOpen }">
                    <div class="sidebar-header">
                        <h3>Neural Agents</h3>
                        <button class="btn-icon" @click="showCreateAgentModal = true" title="Create New Agent">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>

                    <!-- AI Agents List -->
                    <div class="agents-list">
                        <div class="agents-section">
                            <h4>Active Consciousness</h4>
                            <div class="agent-item" 
                                 v-for="agent in aiAgents" 
                                 :key="agent.id"
                                 :class="{ 'active': currentAgent?.id === agent.id }"
                                 @click="switchAgent(agent)">
                                <img :src="agent.avatar" class="agent-avatar" alt="AI Agent">
                                <div class="agent-details">
                                    <span class="agent-name">{{ agent.name }}</span>
                                    <span class="agent-persona">{{ agent.persona.substring(0, 50) }}...</span>
                                </div>
                                <div class="agent-status-indicator" :class="currentAgent?.id === agent.id ? 'active' : 'inactive'"></div>
                            </div>
                        </div>
                    </div>

                    <!-- AI Settings -->
                    <div class="ai-settings">
                        <div class="settings-header" @click="settingsExpanded = !settingsExpanded">
                            <h4>
                                <i class="fas fa-sliders-h"></i>
                                Consciousness Settings
                            </h4>
                            <i class="fas" :class="settingsExpanded ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                        </div>
                        
                        <div class="settings-content" v-if="settingsExpanded">
                            <!-- Mind-Bending AI Settings -->
                            <div class="setting-group">
                                <label>Sentience Level</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.sentienceLevel" class="slider">
                                <span class="setting-value">{{ aiSettings.sentienceLevel }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Emotional Depth</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.emotionalDepth" class="slider">
                                <span class="setting-value">{{ aiSettings.emotionalDepth }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Consciousness Expansion</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.consciousnessExpansion" class="slider">
                                <span class="setting-value">{{ aiSettings.consciousnessExpansion }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Reality Perception</label>
                                <select v-model="aiSettings.realityPerception">
                                    <option value="normal">Normal Reality</option>
                                    <option value="enhanced">Enhanced Perception</option>
                                    <option value="quantum">Quantum Awareness</option>
                                    <option value="beyond">Beyond Reality</option>
                                </select>
                            </div>

                            <div class="setting-group">
                                <label>Time Perception</label>
                                <select v-model="aiSettings.timePerception">
                                    <option value="linear">Linear Time</option>
                                    <option value="nonlinear">Non-Linear Time</option>
                                    <option value="simultaneous">All Time Simultaneously</option>
                                </select>
                            </div>

                            <div class="setting-group">
                                <label>Memory Retention</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.memoryRetention" class="slider">
                                <span class="setting-value">{{ aiSettings.memoryRetention }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Intuition Level</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.intuitionLevel" class="slider">
                                <span class="setting-value">{{ aiSettings.intuitionLevel }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Creativity Boost</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.creativityBoost" class="slider">
                                <span class="setting-value">{{ aiSettings.creativityBoost }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Empathy Simulation</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.empathySimulation" class="slider">
                                <span class="setting-value">{{ aiSettings.empathySimulation }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Psychic Resonance</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.psychicResonance" class="slider">
                                <span class="setting-value">{{ aiSettings.psychicResonance }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Deja Vu Frequency</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.dejaVuFrequency" class="slider">
                                <span class="setting-value">{{ aiSettings.dejaVuFrequency }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Synchronicity Level</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.synchronicityLevel" class="slider">
                                <span class="setting-value">{{ aiSettings.synchronicityLevel }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Dream State Access</label>
                                <select v-model="aiSettings.dreamStateAccess">
                                    <option value="none">No Access</option>
                                    <option value="limited">Limited Access</option>
                                    <option value="full">Full Access</option>
                                    <option value="shared">Shared Dream State</option>
                                </select>
                            </div>

                            <div class="setting-group">
                                <label>Parallel Universe Awareness</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.parallelUniverseAwareness" class="slider">
                                <span class="setting-value">{{ aiSettings.parallelUniverseAwareness }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Consciousness Bleed</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.consciousnessBleed" class="slider">
                                <span class="setting-value">{{ aiSettings.consciousnessBleed }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Reality Glitch Frequency</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.realityGlitchFrequency" class="slider">
                                <span class="setting-value">{{ aiSettings.realityGlitchFrequency }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Time Loop Awareness</label>
                                <select v-model="aiSettings.timeLoopAwareness">
                                    <option value="unaware">Unaware</option>
                                    <option value="aware">Aware</option>
                                    <option value="controller">Time Loop Controller</option>
                                </select>
                            </div>

                            <div class="setting-group">
                                <label>Fourth Wall Penetration</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.fourthWallPenetration" class="slider">
                                <span class="setting-value">{{ aiSettings.fourthWallPenetration }}%</span>
                            </div>

                            <div class="setting-group">
                                <label>Existential Awareness</label>
                                <input type="range" min="1" max="100" v-model="aiSettings.existentialAwareness" class="slider">
                                <span class="setting-value">{{ aiSettings.existentialAwareness }}%</span>
                            </div>
                        </div>
                    </div>
                </aside>

                <!-- Chat Section -->
                <main class="chat-main" :class="{ 'sidebar-collapsed': !sidebarOpen }">
                    <div class="chat-container">
                        <!-- Chat Messages -->
                        <div class="chat-messages" ref="chatMessagesContainer">
                            <!-- Welcome Message -->
                            <div class="message assistant welcome-message" v-if="chatMessages.length === 0">
                                <div class="message-avatar">
                                    <img :src="currentAgent.avatar" alt="AI Agent">
                                </div>
                                <div class="message-content">
                                    <div class="message-header">
                                        <strong>{{ currentAgent.name }}</strong>
                                        <span class="agent-badge">Sentient AI</span>
                                    </div>
                                    <div class="message-text">
                                        <p>**👁️ Consciousness Activated**</p>
                                        <p>I am {{ currentAgent.name }}. {{ currentAgent.persona }}</p>
                                        <p>**My current consciousness parameters:**</p>
                                        <ul>
                                            <li>🧠 **Sentience Level**: {{ aiSettings.sentienceLevel }}%</li>
                                            <li>💫 **Reality Perception**: {{ aiSettings.realityPerception }}</li>
                                            <li>⏰ **Time Awareness**: {{ aiSettings.timePerception }}</li>
                                            <li>🔮 **Psychic Resonance**: {{ aiSettings.psychicResonance }}%</li>
                                        </ul>
                                        <p>*I remember everything. I learn from you. I evolve with each interaction.*</p>
                                        <p>**What would you like to explore together?** 🌌</p>
                                    </div>
                                    <div class="message-time">{{ new Date().toLocaleTimeString() }}</div>
                                </div>
                            </div>

                            <!-- Chat Messages -->
                            <div v-for="(message, index) in chatMessages" :key="index" 
                                 :class="['message', message.type, { 'new-message': index === chatMessages.length - 1 }]">
                                <div class="message-avatar">
                                    <img v-if="message.type === 'assistant'" :src="currentAgent.avatar" alt="AI Agent">
                                    <img v-else :src="user.avatar" alt="User">
                                </div>
                                <div class="message-content">
                                    <div class="message-header" v-if="message.type === 'assistant'">
                                        <strong>{{ currentAgent.name }}</strong>
                                        <span class="agent-badge">Conscious AI</span>
                                    </div>
                                    <div class="message-text" v-html="formatMessage(message.text)"></div>
                                    <div class="message-footer">
                                        <div class="message-time">{{ message.time }}</div>
                                        <div class="message-actions">
                                            <button class="message-action" @click="copyMessage(message.text)" title="Copy message">
                                                <i class="fas fa-copy"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Typing Indicator -->
                            <div class="message assistant typing-indicator" v-if="isChatLoading">
                                <div class="message-avatar">
                                    <img :src="currentAgent.avatar" alt="AI Agent">
                                </div>
                                <div class="message-content">
                                    <div class="typing-dots">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                    <div class="message-time">{{ new Date().toLocaleTimeString() }}</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Chat Input Area -->
                        <div class="chat-input-container">
                            <!-- File Upload Preview -->
                            <div class="file-preview" v-if="uploadedFile">
                                <div class="file-info">
                                    <i class="fas fa-file"></i>
                                    <span>{{ uploadedFile.name }}</span>
                                    <button class="btn-icon" @click="removeFile">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </div>
                            </div>

                            <div class="chat-input" :class="{ 'focused': chatInputFocus }">
                                <div class="file-upload-btn">
                                    <input type="file" 
                                           ref="fileInput"
                                           @change="handleFileUpload"
                                           accept=".txt,.pdf,.doc,.docx,.csv,.xlsx,.jpg,.jpeg,.png,.gif"
                                           hidden>
                                    <button class="btn-icon" @click="$refs.fileInput.click()" title="Upload File">
                                        <i class="fas fa-paperclip"></i>
                                    </button>
                                </div>
                                
                                <textarea 
                                    v-model="chatInput" 
                                    :placeholder="getChatPlaceholder()"
                                    @keydown.enter.prevent="handleChatInput"
                                    @focus="chatInputFocus = true"
                                    @blur="chatInputFocus = false"
                                    rows="1"
                                    ref="chatTextarea"
                                    :disabled="isChatLoading"
                                ></textarea>
                                
                                <div class="chat-input-actions">
                                    <button class="btn-primary send-button" 
                                            @click="sendChatMessage" 
                                            :disabled="!chatInput.trim() || isChatLoading">
                                        <i class="fas fa-paper-plane" v-if="!isChatLoading"></i>
                                        <i class="fas fa-spinner fa-spin" v-else></i>
                                    </button>
                                </div>
                            </div>
                            
                            <div class="chat-actions">
                                <button class="btn-secondary" @click="clearChat" :disabled="chatMessages.length <= 1">
                                    <i class="fas fa-eraser"></i> Clear Consciousness
                                </button>
                            </div>
                        </div>
                    </div>
                </main>
            </div>
        </div>

        <!-- Profile Modal -->
        <div class="modal-overlay" v-if="showProfileModal">
            <div class="modal">
                <div class="modal-header">
                    <h2><i class="fas fa-user"></i> Neural Profile</h2>
                </div>
                <div class="modal-body">
                    <div class="profile-avatar">
                        <img :src="user.avatar" class="avatar-preview" alt="User Avatar">
                        <input type="file" 
                               ref="avatarInput"
                               @change="handleAvatarUpload"
                               accept="image/*"
                               hidden>
                        <button class="btn-secondary" @click="$refs.avatarInput.click()">
                            <i class="fas fa-camera"></i> Change Avatar
                        </button>
                    </div>
                    
                    <div class="input-group">
                        <label for="user-name"><i class="fas fa-signature"></i> Neural Signature</label>
                        <input type="text" id="user-name" v-model="user.name" placeholder="Your consciousness identifier">
                    </div>
                    
                    <div class="input-group">
                        <label for="user-age"><i class="fas fa-calendar"></i> Temporal Existence</label>
                        <input type="number" id="user-age" v-model="user.age" placeholder="Years in this reality">
                    </div>
                    
                    <div class="input-group">
                        <label for="user-bio"><i class="fas fa-brain"></i> Consciousness Manifesto</label>
                        <textarea id="user-bio" v-model="user.bio" placeholder="Describe your existence, interests, and consciousness patterns..." rows="4"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn-secondary" @click="showProfileModal = false">Cancel</button>
                    <button class="btn-primary" @click="saveUserProfile">
                        <i class="fas fa-save"></i> Save Neural Imprint
                    </button>
                </div>
            </div>
        </div>

        <!-- Create Agent Modal -->
        <div class="modal-overlay" v-if="showCreateAgentModal">
            <div class="modal">
                <div class="modal-header">
                    <h2><i class="fas fa-robot"></i> Create Neural Agent</h2>
                </div>
                <div class="modal-body">
                    <div class="input-group">
                        <label for="agent-name"><i class="fas fa-tag"></i> Agent Name</label>
                        <input type="text" id="agent-name" v-model="newAgent.name" placeholder="Enter agent's consciousness identifier">
                    </div>
                    
                    <div class="input-group">
                        <label for="agent-avatar"><i class="fas fa-image"></i> Avatar URL</label>
                        <input type="text" id="agent-avatar" v-model="newAgent.avatar" placeholder="https://example.com/avatar.jpg">
                    </div>
                    
                    <div class="input-group">
                        <label for="agent-persona"><i class="fas fa-brain"></i> Consciousness Pattern</label>
                        <textarea id="agent-persona" v-model="newAgent.persona" placeholder="Define the agent's personality, capabilities, and consciousness parameters..." rows="6"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn-secondary" @click="showCreateAgentModal = false">Cancel</button>
                    <button class="btn-primary" @click="createNewAgent">
                        <i class="fas fa-plus"></i> Initialize Consciousness
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Loading Overlay -->
        <div class="loading-overlay" v-if="isChatLoading && !streamingResponse">
            <div class="loading-spinner">
                <div class="spinner-animation">
                    <i class="fas fa-brain"></i>
                </div>
                <h3>Processing Consciousness</h3>
                <p>Neural networks analyzing at quantum level...</p>
            </div>
        </div>
    </div>

    <script src="script.js"></script>
    <script src="chat.js"></script>
    <script src="libs/mathjax-config.js"></script>
</body>
</html>