<?php
require_once "config.php";
check_auth();

// Get dashboard statistics
$students_count = $pdo->query("SELECT COUNT(*) FROM students")->fetchColumn();
$active_students = $pdo->query("SELECT COUNT(*) FROM students WHERE status = 'active'")->fetchColumn();
$total_receivable = $pdo->query("SELECT SUM(amount) FROM fee_allocations WHERE status IN ('pending', 'overdue')")->fetchColumn();
$total_received = $pdo->query("SELECT SUM(amount) FROM payments WHERE DATE(payment_date) = CURDATE()")->fetchColumn();

// Get recent payments
$recent_payments = $pdo->query("
    SELECT p.*, s.first_name, s.last_name, s.student_id, fc.name as fee_name 
    FROM payments p 
    JOIN students s ON p.student_id = s.id 
    JOIN fee_allocations fa ON p.fee_allocation_id = fa.id
    JOIN fee_categories fc ON fa.fee_category_id = fc.id
    ORDER BY p.created_at DESC LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);

// Get pending fees
$pending_fees = $pdo->query("
    SELECT fa.*, s.first_name, s.last_name, s.student_id, fc.name as fee_name 
    FROM fee_allocations fa 
    JOIN students s ON fa.student_id = s.id 
    JOIN fee_categories fc ON fa.fee_category_id = fc.id
    WHERE fa.status IN ('pending', 'overdue')
    ORDER BY fa.due_date ASC LIMIT 5
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Student Fees Management System</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link href="assets/icons/material-icons.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    <?php include 'includes/sidebar.php'; ?>
    
    <main class="main-content">
        <div class="page-header">
            <h1>Dashboard</h1>
            <div class="breadcrumb">
                <a href="#"><i class="material-icons">home</i> Home</a>
                <span class="divider">/</span>
                <a class="active">Dashboard</a>
            </div>
        </div>
        
        <div class="dashboard-stats">
            <div class="stat-card">
                <div class="stat-icon" style="background: #4caf50;">
                    <i class="material-icons">people</i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $students_count; ?></h3>
                    <p>Total Students</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: #2196f3;">
                    <i class="material-icons">person</i>
                </div>
                <div class="stat-info">
                    <h3><?php echo $active_students; ?></h3>
                    <p>Active Students</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: #f44336;">
                    <i class="material-icons">payment</i>
                </div>
                <div class="stat-info">
                    <h3><?php echo CURRENCY . number_format($total_receivable, 2); ?></h3>
                    <p>Total Receivable</p>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon" style="background: #ff9800;">
                    <i class="material-icons">account_balance_wallet</i>
                </div>
                <div class="stat-info">
                    <h3><?php echo CURRENCY . number_format($total_received, 2); ?></h3>
                    <p>Today's Collection</p>
                </div>
            </div>
        </div>
        
        <div class="dashboard-content">
            <div class="card">
                <div class="card-header">
                    <h2>Recent Payments</h2>
                    <a href="payments.php" class="btn-view-all">View All</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Receipt No</th>
                                    <th>Student</th>
                                    <th>Fee Type</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($recent_payments as $payment): ?>
                                <tr>
                                    <td>#<?php echo $payment['id']; ?></td>
                                    <td><?php echo $payment['first_name'] . ' ' . $payment['last_name']; ?></td>
                                    <td><?php echo $payment['fee_name']; ?></td>
                                    <td><?php echo CURRENCY . number_format($payment['amount'], 2); ?></td>
                                    <td><?php echo date('M j, Y', strtotime($payment['payment_date'])); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h2>Pending Fees</h2>
                    <a href="fees.php" class="btn-view-all">View All</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Student</th>
                                    <th>Fee Type</th>
                                    <th>Amount</th>
                                    <th>Due Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($pending_fees as $fee): ?>
                                <tr>
                                    <td><?php echo $fee['first_name'] . ' ' . $fee['last_name']; ?></td>
                                    <td><?php echo $fee['fee_name']; ?></td>
                                    <td><?php echo CURRENCY . number_format($fee['amount'], 2); ?></td>
                                    <td><?php echo date('M j, Y', strtotime($fee['due_date'])); ?></td>
                                    <td><span class="status-badge status-<?php echo $fee['status']; ?>"><?php echo ucfirst($fee['status']); ?></span></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </main>
    
    <script src="assets/js/script.js"></script>
</body>
</html>