CREATE DATABASE IF NOT EXISTS fuzesale_mem3;
USE fuzesale_mem3;

CREATE TABLE users (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL UNIQUE,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin', 'accountant', 'member') DEFAULT 'member',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE content (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    body TEXT NOT NULL,
    created_by INT(11) NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (created_by) REFERENCES users(id)
);

CREATE TABLE students (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    student_id VARCHAR(20) NOT NULL UNIQUE,
    first_name VARCHAR(50) NOT NULL,
    last_name VARCHAR(50) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    phone VARCHAR(20),
    address TEXT,
    class VARCHAR(50),
    section VARCHAR(50),
    guardian_name VARCHAR(100),
    guardian_phone VARCHAR(20),
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

CREATE TABLE fee_categories (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    description TEXT,
    frequency ENUM('one-time', 'monthly', 'quarterly', 'yearly') DEFAULT 'one-time',
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE fee_allocations (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    student_id INT(11) NOT NULL,
    fee_category_id INT(11) NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    due_date DATE,
    status ENUM('pending', 'paid', 'overdue') DEFAULT 'pending',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (student_id) REFERENCES students(id),
    FOREIGN KEY (fee_category_id) REFERENCES fee_categories(id)
);

CREATE TABLE payments (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    student_id INT(11) NOT NULL,
    fee_allocation_id INT(11) NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    payment_date DATE NOT NULL,
    payment_method ENUM('cash', 'bank transfer', 'card', 'online') DEFAULT 'cash',
    transaction_id VARCHAR(100),
    received_by INT(11) NOT NULL,
    notes TEXT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (student_id) REFERENCES students(id),
    FOREIGN KEY (fee_allocation_id) REFERENCES fee_allocations(id),
    FOREIGN KEY (received_by) REFERENCES users(id)
);

CREATE TABLE custom_fields (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    field_name VARCHAR(100) NOT NULL,
    field_type ENUM('text', 'number', 'date', 'email', 'select') DEFAULT 'text',
    field_options TEXT,
    model ENUM('students', 'payments', 'fee_categories') DEFAULT 'students',
    is_required BOOLEAN DEFAULT FALSE,
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE custom_field_values (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    field_id INT(11) NOT NULL,
    record_id INT(11) NOT NULL,
    field_value TEXT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (field_id) REFERENCES custom_fields(id)
);

CREATE TABLE settings (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) NOT NULL UNIQUE,
    setting_value TEXT,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);

-- Insert admin user
INSERT INTO users (username, email, password, role) VALUES 
('admin', 'admin@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin'),
('accountant', 'accountant@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'accountant'),
('johndoe', 'john@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'member');

-- Insert sample content
INSERT INTO content (title, body, created_by) VALUES
('Welcome to Our Site', 'This is a sample welcome message for all members.', 1),
('Member Benefits', 'As a member, you get access to exclusive content and features.', 1);

-- Insert sample fee categories
INSERT INTO fee_categories (name, amount, description, frequency) VALUES
('Admission Fee', 15000.00, 'One time admission fee', 'one-time'),
('Tuition Fee', 25000.00, 'Monthly tuition fee', 'monthly'),
('Examination Fee', 5000.00, 'Term examination fee', 'quarterly'),
('Sports Fee', 2000.00, 'Annual sports fee', 'yearly');

-- Insert default settings
INSERT INTO settings (setting_key, setting_value) VALUES
('school_name', 'Excel Academy'),
('school_address', '123 Education Street, Knowledge City'),
('school_phone', '+234 801 234 5678'),
('school_email', 'info@excelacademy.edu.ng'),
('currency_symbol', '₦'),
('currency_code', 'NGN'),
('receipt_prefix', 'EXCEL'),
('watermark_logo', 'assets/img/logo.png'),
('academic_year', '2023/2024'),
('low_balance_alert', '5000');