<?php
require_once "config.php";
check_auth();

if (!isset($_GET['payment_id'])) {
    header("Location: payments.php");
    exit;
}

$payment_id = $_GET['payment_id'];

// Get payment details
$sql = "
    SELECT p.*, s.first_name, s.last_name, s.student_id, s.class, s.section,
           fc.name as fee_name, u.username as received_by, 
           sch.setting_value as school_name,
           sch_addr.setting_value as school_address,
           sch_phone.setting_value as school_phone
    FROM payments p 
    JOIN students s ON p.student_id = s.id 
    JOIN fee_allocations fa ON p.fee_allocation_id = fa.id
    JOIN fee_categories fc ON fa.fee_category_id = fc.id
    JOIN users u ON p.received_by = u.id
    LEFT JOIN settings sch ON sch.setting_key = 'school_name'
    LEFT JOIN settings sch_addr ON sch_addr.setting_key = 'school_address'
    LEFT JOIN settings sch_phone ON sch_phone.setting_key = 'school_phone'
    WHERE p.id = :payment_id
";

$stmt = $pdo->prepare($sql);
$stmt->bindParam(':payment_id', $payment_id);
$stmt->execute();
$payment = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$payment) {
    header("Location: payments.php");
    exit;
}

// Get school logo setting
$logo_sql = "SELECT setting_value FROM settings WHERE setting_key = 'watermark_logo'";
$logo_stmt = $pdo->query($logo_sql);
$logo_setting = $logo_stmt->fetch(PDO::FETCH_ASSOC);
$logo_path = $logo_setting ? $logo_setting['setting_value'] : 'assets/img/logo.png';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Receipt - <?php echo $payment['school_name']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">
    <link href="assets/icons/material-icons.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background: white;
            color: #333;
            line-height: 1.6;
            margin: 0;
            padding: 20px;
        }
        
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border: 2px solid #ddd;
            border-radius: 10px;
            padding: 30px;
            position: relative;
        }
        
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            opacity: 0.1;
            z-index: -1;
            text-align: center;
        }
        
        .watermark img {
            width: 300px;
            height: auto;
        }
        
        .receipt-header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 20px;
        }
        
        .school-name {
            font-size: 28px;
            font-weight: 700;
            color: #333;
            margin-bottom: 5px;
        }
        
        .school-address {
            color: #666;
            margin-bottom: 5px;
        }
        
        .school-phone {
            color: #666;
            margin-bottom: 15px;
        }
        
        .receipt-title {
            font-size: 24px;
            font-weight: 500;
            color: #333;
            margin: 20px 0;
            text-align: center;
        }
        
        .receipt-details {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .detail-group {
            margin-bottom: 15px;
        }
        
        .detail-label {
            font-weight: 500;
            color: #666;
            margin-bottom: 5px;
        }
        
        .detail-value {
            font-size: 16px;
            color: #333;
        }
        
        .amount-paid {
            font-size: 24px;
            font-weight: 700;
            color: #2e7d32;
            text-align: center;
            margin: 20px 0;
            padding: 15px;
            background: #e8f5e9;
            border-radius: 5px;
        }
        
        .payment-method {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .footer {
            margin-top: 40px;
            text-align: center;
            border-top: 2px solid #ddd;
            padding-top: 20px;
            color: #666;
        }
        
        .signature {
            margin-top: 40px;
            text-align: right;
        }
        
        .signature-line {
            border-top: 1px solid #333;
            width: 200px;
            margin-left: auto;
            display: block;
            margin-top: 40px;
        }
        
        .signature-label {
            margin-top: 5px;
            font-style: italic;
        }
        
        @media print {
            body {
                padding: 0;
            }
            
            .receipt-container {
                border: none;
                padding: 0;
            }
            
            .no-print {
                display: none;
            }
            
            .watermark {
                opacity: 0.05;
            }
        }
        
        .button-container {
            text-align: center;
            margin: 20px 0;
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            padding: 10px 20px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            margin: 0 5px;
        }
        
        .btn i {
            margin-right: 8px;
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <div class="watermark">
            <img src="<?php echo $logo_path; ?>" alt="School Logo">
        </div>
        
        <div class="receipt-header">
            <div class="school-name"><?php echo $payment['school_name']; ?></div>
            <div class="school-address"><?php echo $payment['school_address']; ?></div>
            <div class="school-phone"><?php echo $payment['school_phone']; ?></div>
        </div>
        
        <div class="receipt-title">OFFICIAL FEE PAYMENT RECEIPT</div>
        
        <div class="receipt-details">
            <div class="left-column">
                <div class="detail-group">
                    <div class="detail-label">Receipt Number</div>
                    <div class="detail-value">#<?php echo $payment['id']; ?></div>
                </div>
                
                <div class="detail-group">
                    <div class="detail-label">Payment Date</div>
                    <div class="detail-value"><?php echo date('F j, Y', strtotime($payment['payment_date'])); ?></div>
                </div>
                
                <div class="detail-group">
                    <div class="detail-label">Student ID</div>
                    <div class="detail-value"><?php echo $payment['student_id']; ?></div>
                </div>
                
                <div class="detail-group">
                    <div class="detail-label">Student Name</div>
                    <div class="detail-value"><?php echo $payment['first_name'] . ' ' . $payment['last_name']; ?></div>
                </div>
            </div>
            
            <div class="right-column">
                <div class="detail-group">
                    <div class="detail-label">Class & Section</div>
                    <div class="detail-value"><?php echo $payment['class'] . ' - ' . $payment['section']; ?></div>
                </div>
                
                <div class="detail-group">
                    <div class="detail-label">Fee Type</div>
                    <div class="detail-value"><?php echo $payment['fee_name']; ?></div>
                </div>
                
                <div class="detail-group">
                    <div class="detail-label">Payment Method</div>
                    <div class="detail-value"><?php echo ucfirst(str_replace('_', ' ', $payment['payment_method'])); ?></div>
                </div>
                
                <?php if (!empty($payment['transaction_id'])): ?>
                <div class="detail-group">
                    <div class="detail-label">Transaction ID</div>
                    <div class="detail-value"><?php echo $payment['transaction_id']; ?></div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="amount-paid">
            Amount Paid: <?php echo CURRENCY . number_format($payment['amount'], 2); ?>
        </div>
        
        <?php if (!empty($payment['notes'])): ?>
        <div class="detail-group">
            <div class="detail-label">Payment Notes</div>
            <div class="detail-value"><?php echo $payment['notes']; ?></div>
        </div>
        <?php endif; ?>
        
        <div class="payment-method">
            <div class="detail-label">Received by</div>
            <div class="detail-value"><?php echo $payment['received_by']; ?></div>
        </div>
        
        <div class="signature">
            <span class="signature-line"></span>
            <div class="signature-label">Authorized Signature</div>
        </div>
        
        <div class="footer">
            <p>This is a computer generated receipt. No signature is required.</p>
            <p>Thank you for your payment!</p>
            <p>Generated on: <?php echo date('F j, Y \a\t g:i A'); ?></p>
        </div>
    </div>
    
    <div class="button-container no-print">
        <button onclick="window.print()" class="btn">
            <i class="material-icons">print</i> Print Receipt
        </button>
        <a href="payments.php" class="btn" style="background: #6c757d;">
            <i class="material-icons">arrow_back</i> Back to Payments
        </a>
    </div>
</body>
</html>