<?php
session_start();

// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_mem3');
define('DB_USER', 'fuzesale_mem3');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Student Fees Management System');
define('SITE_URL', 'http://p.vinesubtech.com.ng/membv2');
define('CURRENCY', '₦');
define('CURRENCY_CODE', 'NGN');
define('VERSION', '2.0');

// Create connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set timezone
date_default_timezone_set('Africa/Lagos');

// Initialize currency session
if (!isset($_SESSION['currency'])) {
    $_SESSION['currency'] = [
        'symbol' => CURRENCY,
        'code' => CURRENCY_CODE,
        'rate' => 1
    ];
}

// Initialize custom fields
if (!isset($_SESSION['custom_fields'])) {
    $_SESSION['custom_fields'] = [];
}

// Check if user is logged in
function is_logged_in() {
    return isset($_SESSION['user_id']);
}

// Check if user is admin
function is_admin() {
    return isset($_SESSION['role']) && $_SESSION['role'] === 'admin';
}

// Redirect if not logged in
function require_login() {
    if (!is_logged_in()) {
        header("Location: index.php");
        exit();
    }
}

// Redirect if not admin
function require_admin() {
    require_login();
    if (!is_admin()) {
        header("Location: dashboard.php");
        exit();
    }
}

// Get exchange rate (simulated)
function get_exchange_rate($to_currency) {
    $rates = [
        'NGN' => 1,
        'USD' => 0.0012,
        'EUR' => 0.0011,
        'GBP' => 0.0009,
        'JPY' => 0.18
    ];
    
    return isset($rates[$to_currency]) ? $rates[$to_currency] : 1;
}

// Format currency
function format_currency($amount) {
    return $_SESSION['currency']['symbol'] . number_format($amount * $_SESSION['currency']['rate'], 2);
}

// Watermark function
function apply_watermark() {
    echo '<div class="watermark">' . SITE_NAME . '</div>';
}

// Calculate payment status
function get_payment_status($paid, $total) {
    if ($paid >= $total) {
        return ['status' => 'paid', 'class' => 'success'];
    } elseif ($paid > 0) {
        return ['status' => 'partial', 'class' => 'warning'];
    } else {
        return ['status' => 'unpaid', 'class' => 'danger'];
    }
}

// Export data to CSV
function export_to_csv($data, $filename) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $filename . '.csv"');
    
    $output = fopen('php://output', 'w');
    
    // Add headers
    if (!empty($data)) {
        fputcsv($output, array_keys($data[0]));
    }
    
    // Add data
    foreach ($data as $row) {
        fputcsv($output, $row);
    }
    
    fclose($output);
    exit();
}

// Export data to JSON
function export_to_json($data, $filename) {
    header('Content-Type: application/json');
    header('Content-Disposition: attachment; filename="' . $filename . '.json"');
    
    echo json_encode($data, JSON_PRETTY_PRINT);
    exit();
}

// Import data from JSON
function import_from_json($file) {
    $json = file_get_contents($file['tmp_name']);
    return json_decode($json, true);
}

// Backup database
function backup_database($conn) {
    $tables = array();
    $result = $conn->query("SHOW TABLES");
    
    while ($row = $result->fetch_row()) {
        $tables[] = $row[0];
    }
    
    $backup = array();
    
    foreach ($tables as $table) {
        $result = $conn->query("SELECT * FROM $table");
        $fields = $result->fetch_fields();
        $fieldNames = array();
        
        foreach ($fields as $field) {
            $fieldNames[] = $field->name;
        }
        
        $backup[$table] = array(
            'fields' => $fieldNames,
            'data' => array()
        );
        
        while ($row = $result->fetch_assoc()) {
            $backup[$table]['data'][] = $row;
        }
    }
    
    return $backup;
}

// Restore database
function restore_database($conn, $backup) {
    foreach ($backup as $table => $data) {
        // Clear existing data
        $conn->query("TRUNCATE TABLE $table");
        
        // Insert new data
        if (!empty($data['data'])) {
            $fields = implode(', ', $data['fields']);
            $placeholders = implode(', ', array_fill(0, count($data['fields']), '?'));
            
            $stmt = $conn->prepare("INSERT INTO $table ($fields) VALUES ($placeholders)");
            
            foreach ($data['data'] as $row) {
                $values = array();
                foreach ($data['fields'] as $field) {
                    $values[] = $row[$field];
                }
                
                $types = str_repeat('s', count($values));
                $stmt->bind_param($types, ...$values);
                $stmt->execute();
            }
            
            $stmt->close();
        }
    }
}
?>