<?php
require_once 'config.php';
require_login();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_fee'])) {
        $student_id = $conn->real_escape_string($_POST['student_id']);
        $fee_structure_id = $conn->real_escape_string($_POST['fee_structure_id']);
        $amount_paid = $conn->real_escape_string($_POST['amount_paid']);
        $payment_date = $conn->real_escape_string($_POST['payment_date']);
        $payment_method = $conn->real_escape_string($_POST['payment_method']);
        $transaction_id = $conn->real_escape_string($_POST['transaction_id']);
        $status = $conn->real_escape_string($_POST['status']);
        
        $sql = "INSERT INTO fees (student_id, fee_structure_id, amount_paid, payment_date, payment_method, transaction_id, status) 
                VALUES ('$student_id', '$fee_structure_id', '$amount_paid', '$payment_date', '$payment_method', '$transaction_id', '$status')";
        
        if ($conn->query($sql)) {
            $success = "Fee payment recorded successfully!";
        } else {
            $error = "Error recording fee payment: " . $conn->error;
        }
    } elseif (isset($_POST['edit_fee'])) {
        $id = $conn->real_escape_string($_POST['id']);
        $student_id = $conn->real_escape_string($_POST['student_id']);
        $fee_structure_id = $conn->real_escape_string($_POST['fee_structure_id']);
        $amount_paid = $conn->real_escape_string($_POST['amount_paid']);
        $payment_date = $conn->real_escape_string($_POST['payment_date']);
        $payment_method = $conn->real_escape_string($_POST['payment_method']);
        $transaction_id = $conn->real_escape_string($_POST['transaction_id']);
        $status = $conn->real_escape_string($_POST['status']);
        
        $sql = "UPDATE fees SET 
                student_id='$student_id', 
                fee_structure_id='$fee_structure_id', 
                amount_paid='$amount_paid', 
                payment_date='$payment_date', 
                payment_method='$payment_method', 
                transaction_id='$transaction_id', 
                status='$status' 
                WHERE id=$id";
        
        if ($conn->query($sql)) {
            $success = "Fee payment updated successfully!";
        } else {
            $error = "Error updating fee payment: " . $conn->error;
        }
    } elseif (isset($_GET['delete'])) {
        $id = $conn->real_escape_string($_GET['delete']);
        $sql = "DELETE FROM fees WHERE id=$id";
        
        if ($conn->query($sql)) {
            $success = "Fee payment deleted successfully!";
        } else {
            $error = "Error deleting fee payment: " . $conn->error;
        }
    }
}

// Handle student filter
$student_filter = "";
if (isset($_GET['student']) && !empty($_GET['student'])) {
    $student_id = $conn->real_escape_string($_GET['student']);
    $student_filter = "WHERE f.student_id = $student_id";
}

// Handle status filter
$status_filter = "";
if (isset($_GET['status']) && !empty($_GET['status'])) {
    $status = $conn->real_escape_string($_GET['status']);
    $status_filter = $student_filter ? " AND f.status = '$status'" : "WHERE f.status = '$status'";
}

// Handle date filter
$date_filter = "";
if (isset($_GET['date_from']) && !empty($_GET['date_from']) && isset($_GET['date_to']) && !empty($_GET['date_to'])) {
    $date_from = $conn->real_escape_string($_GET['date_from']);
    $date_to = $conn->real_escape_string($_GET['date_to']);
    
    $date_condition = "f.payment_date BETWEEN '$date_from' AND '$date_to'";
    $date_filter = $student_filter || $status_filter ? " AND $date_condition" : "WHERE $date_condition";
}

// Fetch all fees with student names
$fees = $conn->query("
    SELECT f.*, s.name as student_name, s.student_id as student_code, s.class, fs.amount as total_amount 
    FROM fees f 
    JOIN students s ON f.student_id = s.id 
    JOIN fee_structure fs ON f.fee_structure_id = fs.id 
    $student_filter $status_filter $date_filter
    ORDER BY f.payment_date DESC
");

// Fetch students for dropdown
$students = $conn->query("SELECT * FROM students ORDER BY name");

// Fetch fee structure for dropdown
$fee_structures = $conn->query("SELECT * FROM fee_structure ORDER BY class");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fees Management - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.8rem 1rem;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
        }
        .watermark {
            position: fixed;
            bottom: 20px;
            right: 20px;
            opacity: 0.1;
            font-size: 24px;
            font-weight: bold;
            color: #000;
            pointer-events: none;
            z-index: 9999;
        }
        .filter-card {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar p-0">
                <div class="p-4">
                    <h4 class="text-center mb-4"><?php echo SITE_NAME; ?></h4>
                    <hr>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class="mdi mdi-view-dashboard me-2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="students.php">
                                <i class="mdi mdi-account-group me-2"></i> Students
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="fees.php">
                                <i class="mdi mdi-cash-multiple me-2"></i> Fees Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reports.php">
                                <i class="mdi mdi-chart-bar me-2"></i> Reports
                            </a>
                        </li>
                        <?php if (is_admin()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="settings.php">
                                <i class="mdi mdi-cog me-2"></i> Settings
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-item mt-4">
                            <a class="nav-link text-danger" href="index.php?logout=1">
                                <i class="mdi mdi-logout me-2"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main content -->
            <div class="col-md-9 col-lg-10 ms-sm-auto px-4 py-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Fees Management</h2>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addFeeModal">
                        <i class="mdi mdi-plus-circle me-1"></i> Record Payment
                    </button>
                </div>

                <!-- Filters -->
                <div class="card filter-card">
                    <div class="card-body">
                        <form method="GET" class="row g-3">
                            <div class="col-md-3">
                                <select class="form-select" name="student">
                                    <option value="">Filter by Student</option>
                                    <?php while($student = $students->fetch_assoc()): ?>
                                    <option value="<?php echo $student['id']; ?>" <?php echo isset($_GET['student']) && $_GET['student'] == $student['id'] ? 'selected' : ''; ?>>
                                        <?php echo $student['name']; ?> (<?php echo $student['student_id']; ?>)
                                    </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <select class="form-select" name="status">
                                    <option value="">Filter by Status</option>
                                    <option value="completed" <?php echo isset($_GET['status']) && $_GET['status'] == 'completed' ? 'selected' : ''; ?>>Completed</option>
                                    <option value="pending" <?php echo isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                    <option value="failed" <?php echo isset($_GET['status']) && $_GET['status'] == 'failed' ? 'selected' : ''; ?>>Failed</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <input type="date" class="form-control" name="date_from" value="<?php echo isset($_GET['date_from']) ? $_GET['date_from'] : ''; ?>" placeholder="From Date">
                            </div>
                            <div class="col-md-3">
                                <input type="date" class="form-control" name="date_to" value="<?php echo isset($_GET['date_to']) ? $_GET['date_to'] : ''; ?>" placeholder="To Date">
                            </div>
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary me-2">Apply Filters</button>
                                <a href="fees.php" class="btn btn-outline-secondary">Clear Filters</a>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Alerts -->
                <?php if (isset($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <!-- Fees table -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Transaction ID</th>
                                        <th>Student ID</th>
                                        <th>Student Name</th>
                                        <th>Class</th>
                                        <th>Amount Paid</th>
                                        <th>Total Amount</th>
                                        <th>Payment Date</th>
                                        <th>Payment Method</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($fee = $fees->fetch_assoc()): ?>
                                    <tr>
                                        <td><?php echo $fee['transaction_id'] ? $fee['transaction_id'] : 'N/A'; ?></td>
                                        <td><?php echo $fee['student_code']; ?></td>
                                        <td><?php echo $fee['student_name']; ?></td>
                                        <td><?php echo $fee['class']; ?></td>
                                        <td><?php echo format_currency($fee['amount_paid']); ?></td>
                                        <td><?php echo format_currency($fee['total_amount']); ?></td>
                                        <td><?php echo date('M j, Y', strtotime($fee['payment_date'])); ?></td>
                                        <td><?php echo ucfirst(str_replace('_', ' ', $fee['payment_method'])); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $fee['status'] === 'completed' ? 'success' : ($fee['status'] === 'pending' ? 'warning' : 'danger'); ?>">
                                                <?php echo ucfirst($fee['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editFeeModal" 
                                                data-id="<?php echo $fee['id']; ?>"
                                                data-student_id="<?php echo $fee['student_id']; ?>"
                                                data-fee_structure_id="<?php echo $fee['fee_structure_id']; ?>"
                                                data-amount_paid="<?php echo $fee['amount_paid']; ?>"
                                                data-payment_date="<?php echo $fee['payment_date']; ?>"
                                                data-payment_method="<?php echo $fee['payment_method']; ?>"
                                                data-transaction_id="<?php echo $fee['transaction_id']; ?>"
                                                data-status="<?php echo $fee['status']; ?>">
                                                <i class="mdi mdi-pencil"></i>
                                            </button>
                                            <a href="fees.php?delete=<?php echo $fee['id']; ?>" class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Are you sure you want to delete this fee record?')">
                                                <i class="mdi mdi-delete"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Fee Modal -->
    <div class="modal fade" id="addFeeModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Record Fee Payment</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Student</label>
                            <select class="form-select" name="student_id" required>
                                <option value="">Select Student</option>
                                <?php 
                                $students = $conn->query("SELECT * FROM students ORDER BY name");
                                while($student = $students->fetch_assoc()): 
                                ?>
                                <option value="<?php echo $student['id']; ?>"><?php echo $student['name']; ?> (<?php echo $student['student_id']; ?>)</option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Fee Structure</label>
                            <select class="form-select" name="fee_structure_id" required>
                                <option value="">Select Fee Structure</option>
                                <?php 
                                $fee_structures = $conn->query("SELECT * FROM fee_structure ORDER BY class");
                                while($fee_structure = $fee_structures->fetch_assoc()): 
                                ?>
                                <option value="<?php echo $fee_structure['id']; ?>"><?php echo $fee_structure['class']; ?> - <?php echo format_currency($fee_structure['amount']); ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Amount Paid</label>
                            <input type="number" step="0.01" class="form-control" name="amount_paid" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Payment Date</label>
                            <input type="date" class="form-control" name="payment_date" required value="<?php echo date('Y-m-d'); ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Payment Method</label>
                            <select class="form-select" name="payment_method" required>
                                <option value="cash">Cash</option>
                                <option value="bank_transfer">Bank Transfer</option>
                                <option value="card">Card</option>
                                <option value="online">Online</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Transaction ID (if any)</label>
                            <input type="text" class="form-control" name="transaction_id">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status" required>
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="add_fee" class="btn btn-primary">Record Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Fee Modal -->
    <div class="modal fade" id="editFeeModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Fee Payment</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <input type="hidden" name="id" id="edit_fee_id">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Student</label>
                            <select class="form-select" name="student_id" id="edit_student_id" required>
                                <option value="">Select Student</option>
                                <?php 
                                $students = $conn->query("SELECT * FROM students ORDER BY name");
                                while($student = $students->fetch_assoc()): 
                                ?>
                                <option value="<?php echo $student['id']; ?>"><?php echo $student['name']; ?> (<?php echo $student['student_id']; ?>)</option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Fee Structure</label>
                            <select class="form-select" name="fee_structure_id" id="edit_fee_structure_id" required>
                                <option value="">Select Fee Structure</option>
                                <?php 
                                $fee_structures = $conn->query("SELECT * FROM fee_structure ORDER BY class");
                                while($fee_structure = $fee_structures->fetch_assoc()): 
                                ?>
                                <option value="<?php echo $fee_structure['id']; ?>"><?php echo $fee_structure['class']; ?> - <?php echo format_currency($fee_structure['amount']); ?></option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Amount Paid</label>
                            <input type="number" step="0.01" class="form-control" name="amount_paid" id="edit_amount_paid" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Payment Date</label>
                            <input type="date" class="form-control" name="payment_date" id="edit_payment_date" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Payment Method</label>
                            <select class="form-select" name="payment_method" id="edit_payment_method" required>
                                <option value="cash">Cash</option>
                                <option value="bank_transfer">Bank Transfer</option>
                                <option value="card">Card</option>
                                <option value="online">Online</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Transaction ID (if any)</label>
                            <input type="text" class="form-control" name="transaction_id" id="edit_transaction_id">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status" id="edit_status" required>
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="edit_fee" class="btn btn-primary">Update Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <?php apply_watermark(); ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Edit modal script
        var editFeeModal = document.getElementById('editFeeModal');
        editFeeModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            editFeeModal.querySelector('#edit_fee_id').value = button.getAttribute('data-id');
            editFeeModal.querySelector('#edit_student_id').value = button.getAttribute('data-student_id');
            editFeeModal.querySelector('#edit_fee_structure_id').value = button.getAttribute('data-fee_structure_id');
            editFeeModal.querySelector('#edit_amount_paid').value = button.getAttribute('data-amount_paid');
            editFeeModal.querySelector('#edit_payment_date').value = button.getAttribute('data-payment_date');
            editFeeModal.querySelector('#edit_payment_method').value = button.getAttribute('data-payment_method');
            editFeeModal.querySelector('#edit_transaction_id').value = button.getAttribute('data-transaction_id');
            editFeeModal.querySelector('#edit_status').value = button.getAttribute('data-status');
        });
    </script>
</body>
</html>