<?php
require_once 'config.php';
require_admin(); // Only admin can access settings

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle custom field creation
    if (isset($_POST['add_custom_field'])) {
        $field_name = $conn->real_escape_string($_POST['field_name']);
        $field_type = $conn->real_escape_string($_POST['field_type']);
        $model = $conn->real_escape_string($_POST['model']);
        $is_required = isset($_POST['is_required']) ? 1 : 0;
        
        // Process field options for select type
        $field_options = '';
        if ($field_type === 'select' && !empty($_POST['field_options'])) {
            $options = explode(',', $_POST['field_options']);
            $options = array_map('trim', $options);
            $field_options = json_encode($options);
        }
        
        $sql = "INSERT INTO custom_fields (field_name, field_type, field_options, model, is_required) 
                VALUES ('$field_name', '$field_type', '$field_options', '$model', $is_required)";
        
        if ($conn->query($sql)) {
            $success = "Custom field added successfully!";
        } else {
            $error = "Error adding custom field: " . $conn->error;
        }
    }
    
    // Handle custom field deletion
    elseif (isset($_GET['delete_field'])) {
        $field_id = $conn->real_escape_string($_GET['delete_field']);
        $sql = "DELETE FROM custom_fields WHERE id = $field_id";
        
        if ($conn->query($sql)) {
            $success = "Custom field deleted successfully!";
        } else {
            $error = "Error deleting custom field: " . $conn->error;
        }
    }
    
    // Handle special fee creation
    elseif (isset($_POST['add_special_fee'])) {
        $student_id = $conn->real_escape_string($_POST['student_id']);
        $description = $conn->real_escape_string($_POST['description']);
        $amount = $conn->real_escape_string($_POST['amount']);
        $due_date = $conn->real_escape_string($_POST['due_date']);
        
        $sql = "INSERT INTO special_fees (student_id, description, amount, due_date) 
                VALUES ('$student_id', '$description', '$amount', '$due_date')";
        
        if ($conn->query($sql)) {
            $success = "Special fee added successfully!";
        } else {
            $error = "Error adding special fee: " . $conn->error;
        }
    }
    
    // Handle special fee deletion
    elseif (isset($_GET['delete_special_fee'])) {
        $fee_id = $conn->real_escape_string($_GET['delete_special_fee']);
        $sql = "DELETE FROM special_fees WHERE id = $fee_id";
        
        if ($conn->query($sql)) {
            $success = "Special fee deleted successfully!";
        } else {
            $error = "Error deleting special fee: " . $conn->error;
        }
    }
    
    // Handle fee structure update
    elseif (isset($_POST['update_fee_structure'])) {
        $class = $conn->real_escape_string($_POST['class']);
        $amount = $conn->real_escape_string($_POST['amount']);
        $academic_year = $conn->real_escape_string($_POST['academic_year']);
        $description = $conn->real_escape_string($_POST['description']);
        
        // Check if fee structure already exists for this class and year
        $check_sql = "SELECT id FROM fee_structure WHERE class = '$class' AND academic_year = '$academic_year'";
        $result = $conn->query($check_sql);
        
        if ($result->num_rows > 0) {
            // Update existing record
            $row = $result->fetch_assoc();
            $sql = "UPDATE fee_structure SET amount = '$amount', description = '$description' 
                    WHERE id = " . $row['id'];
        } else {
            // Insert new record
            $sql = "INSERT INTO fee_structure (class, amount, academic_year, description) 
                    VALUES ('$class', '$amount', '$academic_year', '$description')";
        }
        
        if ($conn->query($sql)) {
            $success = "Fee structure updated successfully!";
        } else {
            $error = "Error updating fee structure: " . $conn->error;
        }
    }
    
    // Handle system settings update
    elseif (isset($_POST['update_settings'])) {
        foreach ($_POST as $key => $value) {
            if (strpos($key, 'setting_') === 0) {
                $setting_key = str_replace('setting_', '', $key);
                $setting_value = $conn->real_escape_string($value);
                
                $check_sql = "SELECT id FROM system_settings WHERE setting_key = '$setting_key'";
                $result = $conn->query($check_sql);
                
                if ($result->num_rows > 0) {
                    $sql = "UPDATE system_settings SET setting_value = '$setting_value' WHERE setting_key = '$setting_key'";
                } else {
                    $sql = "INSERT INTO system_settings (setting_key, setting_value) VALUES ('$setting_key', '$setting_value')";
                }
                
                $conn->query($sql);
            }
        }
        $success = "System settings updated successfully!";
    }
    
    // Handle currency settings update
    elseif (isset($_POST['update_currency_settings'])) {
        $currency = $conn->real_escape_string($_POST['currency']);
        $currency_rate = $conn->real_escape_string($_POST['currency_rate']);
        
        // Update session currency
        $symbols = [
            'NGN' => '₦',
            'USD' => '$',
            'EUR' => '€',
            'GBP' => '£',
            'JPY' => '¥'
        ];
        
        $_SESSION['currency'] = [
            'symbol' => $symbols[$currency] ?? '₦',
            'code' => $currency,
            'rate' => $currency_rate
        ];
        
        // Update database settings
        $check_sql = "SELECT id FROM system_settings WHERE setting_key = 'currency'";
        $result = $conn->query($check_sql);
        
        if ($result->num_rows > 0) {
            $sql = "UPDATE system_settings SET setting_value = '$currency' WHERE setting_key = 'currency'";
        } else {
            $sql = "INSERT INTO system_settings (setting_key, setting_value) VALUES ('currency', '$currency')";
        }
        $conn->query($sql);
        
        $check_sql = "SELECT id FROM system_settings WHERE setting_key = 'currency_rate'";
        $result = $conn->query($check_sql);
        
        if ($result->num_rows > 0) {
            $sql = "UPDATE system_settings SET setting_value = '$currency_rate' WHERE setting_key = 'currency_rate'";
        } else {
            $sql = "INSERT INTO system_settings (setting_key, setting_value) VALUES ('currency_rate', '$currency_rate')";
        }
        $conn->query($sql);
        
        $success = "Currency settings updated successfully!";
    }
}

// Fetch custom fields
$custom_fields = $conn->query("SELECT * FROM custom_fields ORDER BY model, field_name");

// Fetch special fees with student names
$special_fees = $conn->query("
    SELECT sf.*, s.name as student_name, s.student_id 
    FROM special_fees sf 
    JOIN students s ON sf.student_id = s.id 
    ORDER BY sf.due_date DESC
");

// Fetch fee structure
$fee_structure = $conn->query("SELECT * FROM fee_structure ORDER BY class, academic_year");

// Fetch students for dropdowns
$students = $conn->query("SELECT * FROM students ORDER BY name");

// Fetch system settings
$system_settings = $conn->query("SELECT * FROM system_settings");
$settings = [];
while ($row = $system_settings->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Get current currency settings
$current_currency = $settings['currency'] ?? 'NGN';
$current_currency_rate = $settings['currency_rate'] ?? 1;
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.8rem 1rem;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
        }
        .watermark {
            position: fixed;
            bottom: 20px;
            right: 20px;
            opacity: 0.1;
            font-size: 24px;
            font-weight: bold;
            color: #000;
            pointer-events: none;
            z-index: 9999;
        }
        .settings-section {
            margin-bottom: 30px;
        }
        .settings-card {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar p-0">
                <div class="p-4">
                    <h4 class="text-center mb-4"><?php echo SITE_NAME; ?></h4>
                    <hr>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class="mdi mdi-view-dashboard me-2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="students.php">
                                <i class="mdi mdi-account-group me-2"></i> Students
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="fees.php">
                                <i class="mdi mdi-cash-multiple me-2"></i> Fees Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reports.php">
                                <i class="mdi mdi-chart-bar me-2"></i> Reports
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="settings.php">
                                <i class="mdi mdi-cog me-2"></i> Settings
                            </a>
                        </li>
                        <li class="nav-item mt-4">
                            <a class="nav-link text-danger" href="index.php?logout=1">
                                <i class="mdi mdi-logout me-2"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main content -->
            <div class="col-md-9 col-lg-10 ms-sm-auto px-4 py-4">
                <h2 class="mb-4">System Settings</h2>

                <!-- Alerts -->
                <?php if (isset($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <!-- System Settings Section -->
                <div class="settings-section">
                    <div class="card settings-card">
                        <div class="card-header">
                            <h5 class="mb-0">System Information</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">School Name</label>
                                            <input type="text" class="form-control" name="setting_school_name" 
                                                   value="<?php echo $settings['school_name'] ?? ''; ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">School Email</label>
                                            <input type="email" class="form-control" name="setting_school_email" 
                                                   value="<?php echo $settings['school_email'] ?? ''; ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">School Phone</label>
                                            <input type="text" class="form-control" name="setting_school_phone" 
                                                   value="<?php echo $settings['school_phone'] ?? ''; ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Academic Year</label>
                                            <input type="text" class="form-control" name="setting_academic_year" 
                                                   value="<?php echo $settings['academic_year'] ?? '2023-2024'; ?>" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">School Address</label>
                                    <textarea class="form-control" name="setting_school_address" rows="2"><?php echo $settings['school_address'] ?? ''; ?></textarea>
                                </div>
                                <button type="submit" name="update_settings" class="btn btn-primary">Save Settings</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Currency Settings Section -->
                <div class="settings-section">
                    <div class="card settings-card">
                        <div class="card-header">
                            <h5 class="mb-0">Currency Settings</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Default Currency</label>
                                            <select class="form-select" name="currency" required>
                                                <option value="NGN" <?php echo $current_currency === 'NGN' ? 'selected' : ''; ?>>Naira (₦)</option>
                                                <option value="USD" <?php echo $current_currency === 'USD' ? 'selected' : ''; ?>>US Dollar ($)</option>
                                                <option value="EUR" <?php echo $current_currency === 'EUR' ? 'selected' : ''; ?>>Euro (€)</option>
                                                <option value="GBP" <?php echo $current_currency === 'GBP' ? 'selected' : ''; ?>>British Pound (£)</option>
                                                <option value="JPY" <?php echo $current_currency === 'JPY' ? 'selected' : ''; ?>>Japanese Yen (¥)</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Exchange Rate (to Naira)</label>
                                            <input type="number" step="0.0001" class="form-control" name="currency_rate" 
                                                   value="<?php echo $current_currency_rate; ?>" required>
                                            <div class="form-text">1 unit of selected currency = how many Naira?</div>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" name="update_currency_settings" class="btn btn-primary">Save Currency Settings</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Fee Structure Section -->
                <div class="settings-section">
                    <div class="card settings-card">
                        <div class="card-header">
                            <h5 class="mb-0">Fee Structure Management</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" class="mb-4">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Class</label>
                                            <select class="form-select" name="class" required>
                                                <option value="">Select Class</option>
                                                <option value="KG">Kindergarten</option>
                                                <option value="Nursery">Nursery</option>
                                                <option value="Primary 1">Primary 1</option>
                                                <option value="Primary 2">Primary 2</option>
                                                <option value="Primary 3">Primary 3</option>
                                                <option value="Primary 4">Primary 4</option>
                                                <option value="Primary 5">Primary 5</option>
                                                <option value="Primary 6">Primary 6</option>
                                                <option value="JSS 1">JSS 1</option>
                                                <option value="JSS 2">JSS 2</option>
                                                <option value="JSS 3">JSS 3</option>
                                                <option value="SS 1">SS 1</option>
                                                <option value="SS 2">SS 2</option>
                                                <option value="SS 3">SS 3</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Academic Year</label>
                                            <input type="text" class="form-control" name="academic_year" 
                                                   value="<?php echo $settings['academic_year'] ?? '2023-2024'; ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Amount (<?php echo $_SESSION['currency']['symbol']; ?>)</label>
                                            <input type="number" step="0.01" class="form-control" name="amount" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Description</label>
                                            <input type="text" class="form-control" name="description">
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" name="update_fee_structure" class="btn btn-primary">Update Fee Structure</button>
                            </form>

                            <h6>Current Fee Structure</h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Class</th>
                                            <th>Academic Year</th>
                                            <th>Amount</th>
                                            <th>Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($fee = $fee_structure->fetch_assoc()): ?>
                                        <tr>
                                            <td><?php echo $fee['class']; ?></td>
                                            <td><?php echo $fee['academic_year']; ?></td>
                                            <td><?php echo format_currency($fee['amount']); ?></td>
                                            <td><?php echo $fee['description']; ?></td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Custom Fields Section -->
                <div class="settings-section">
                    <div class="card settings-card">
                        <div class="card-header">
                            <h5 class="mb-0">Custom Fields Management</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" class="mb-4">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label class="form-label">Field Name</label>
                                            <input type="text" class="form-control" name="field_name" required>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Field Type</label>
                                            <select class="form-select" name="field_type" id="fieldType" required>
                                                <option value="text">Text</option>
                                                <option value="number">Number</option>
                                                <option value="date">Date</option>
                                                <option value="select">Dropdown</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Model</label>
                                            <select class="form-select" name="model" required>
                                                <option value="students">Students</option>
                                                <option value="fees">Fees</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="mb-3 form-check">
                                            <input type="checkbox" class="form-check-input" name="is_required" id="isRequired">
                                            <label class="form-check-label" for="isRequired">Required</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row" id="fieldOptionsContainer" style="display: none;">
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label">Field Options (comma separated)</label>
                                            <input type="text" class="form-control" name="field_options" placeholder="Option 1, Option 2, Option 3">
                                            <div class="form-text">Enter options separated by commas for dropdown fields</div>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" name="add_custom_field" class="btn btn-primary">Add Custom Field</button>
                            </form>

                            <h6>Existing Custom Fields</h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Field Name</th>
                                            <th>Type</th>
                                            <th>Model</th>
                                            <th>Required</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($field = $custom_fields->fetch_assoc()): ?>
                                        <tr>
                                            <td><?php echo $field['field_name']; ?></td>
                                            <td><?php echo ucfirst($field['field_type']); ?></td>
                                            <td><?php echo ucfirst($field['model']); ?></td>
                                            <td><?php echo $field['is_required'] ? 'Yes' : 'No'; ?></td>
                                            <td>
                                                <a href="settings.php?delete_field=<?php echo $field['id']; ?>" class="btn btn-sm btn-danger" 
                                                   onclick="return confirm('Are you sure you want to delete this custom field?')">
                                                    <i class="mdi mdi-delete"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Special Fees Section -->
                <div class="settings-section">
                    <div class="card settings-card">
                        <div class="card-header">
                            <h5 class="mb-0">Special Fees Management</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" class="mb-4">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label class="form-label">Student</label>
                                            <select class="form-select" name="student_id" required>
                                                <option value="">Select Student</option>
                                                <?php while($student = $students->fetch_assoc()): ?>
                                                <option value="<?php echo $student['id']; ?>">
                                                    <?php echo $student['name']; ?> (<?php echo $student['student_id']; ?>)
                                                </option>
                                                <?php endwhile; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="mb-3">
                                            <label class="form-label">Description</label>
                                            <input type="text" class="form-control" name="description" required>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="mb-3">
                                            <label class="form-label">Amount (<?php echo $_SESSION['currency']['symbol']; ?>)</label>
                                            <input type="number" step="0.01" class="form-control" name="amount" required>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="mb-3">
                                            <label class="form-label">Due Date</label>
                                            <input type="date" class="form-control" name="due_date" required>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" name="add_special_fee" class="btn btn-primary">Add Special Fee</button>
                            </form>

                            <h6>Existing Special Fees</h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-striped">
                                    <thead>
                                        <tr>
                                            <th>Student</th>
                                            <th>Description</th>
                                            <th>Amount</th>
                                            <th>Due Date</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while($fee = $special_fees->fetch_assoc()): ?>
                                        <tr>
                                            <td><?php echo $fee['student_name']; ?> (<?php echo $fee['student_id']; ?>)</td>
                                            <td><?php echo $fee['description']; ?></td>
                                            <td><?php echo format_currency($fee['amount']); ?></td>
                                            <td><?php echo date('M j, Y', strtotime($fee['due_date'])); ?></td>
                                            <td>
                                                <a href="settings.php?delete_special_fee=<?php echo $fee['id']; ?>" class="btn btn-sm btn-danger" 
                                                   onclick="return confirm('Are you sure you want to delete this special fee?')">
                                                    <i class="mdi mdi-delete"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php apply_watermark(); ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Show/hide field options based on field type
        document.getElementById('fieldType').addEventListener('change', function() {
            const fieldOptionsContainer = document.getElementById('fieldOptionsContainer');
            fieldOptionsContainer.style.display = this.value === 'select' ? 'block' : 'none';
        });

        // Trigger change event on page load
        document.getElementById('fieldType').dispatchEvent(new Event('change'));
    </script>
</body>
</html>