<?php
require_once 'config.php';
require_login();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_student'])) {
        $student_id = $conn->real_escape_string($_POST['student_id']);
        $name = $conn->real_escape_string($_POST['name']);
        $email = $conn->real_escape_string($_POST['email']);
        $phone = $conn->real_escape_string($_POST['phone']);
        $class = $conn->real_escape_string($_POST['class']);
        $guardian_name = $conn->real_escape_string($_POST['guardian_name']);
        $guardian_phone = $conn->real_escape_string($_POST['guardian_phone']);
        $address = $conn->real_escape_string($_POST['address']);
        
        $sql = "INSERT INTO students (student_id, name, email, phone, class, guardian_name, guardian_phone, address) 
                VALUES ('$student_id', '$name', '$email', '$phone', '$class', '$guardian_name', '$guardian_phone', '$address')";
        
        if ($conn->query($sql)) {
            $success = "Student added successfully!";
        } else {
            $error = "Error adding student: " . $conn->error;
        }
    } elseif (isset($_POST['edit_student'])) {
        $id = $conn->real_escape_string($_POST['id']);
        $student_id = $conn->real_escape_string($_POST['student_id']);
        $name = $conn->real_escape_string($_POST['name']);
        $email = $conn->real_escape_string($_POST['email']);
        $phone = $conn->real_escape_string($_POST['phone']);
        $class = $conn->real_escape_string($_POST['class']);
        $guardian_name = $conn->real_escape_string($_POST['guardian_name']);
        $guardian_phone = $conn->real_escape_string($_POST['guardian_phone']);
        $address = $conn->real_escape_string($_POST['address']);
        
        $sql = "UPDATE students SET 
                student_id='$student_id', 
                name='$name', 
                email='$email', 
                phone='$phone', 
                class='$class', 
                guardian_name='$guardian_name', 
                guardian_phone='$guardian_phone', 
                address='$address' 
                WHERE id=$id";
        
        if ($conn->query($sql)) {
            $success = "Student updated successfully!";
        } else {
            $error = "Error updating student: " . $conn->error;
        }
    } elseif (isset($_GET['delete'])) {
        $id = $conn->real_escape_string($_GET['delete']);
        $sql = "DELETE FROM students WHERE id=$id";
        
        if ($conn->query($sql)) {
            $success = "Student deleted successfully!";
        } else {
            $error = "Error deleting student: " . $conn->error;
        }
    }
}

// Handle search
$search = "";
$where = "";
if (isset($_GET['search']) && !empty($_GET['search'])) {
    $search = $conn->real_escape_string($_GET['search']);
    $where = "WHERE s.student_id LIKE '%$search%' OR s.name LIKE '%$search%' OR s.email LIKE '%$search%' OR s.class LIKE '%$search%'";
}

// Handle class filter
$class_filter = "";
if (isset($_GET['class']) && !empty($_GET['class'])) {
    $class = $conn->real_escape_string($_GET['class']);
    $class_filter = $where ? " AND s.class='$class'" : "WHERE s.class='$class'";
}

// Fetch all students with payment status
$students = $conn->query("
    SELECT s.*, COALESCE(SUM(f.amount_paid), 0) as paid_amount,
    (SELECT amount FROM fee_structure WHERE class = s.class LIMIT 1) as total_amount
    FROM students s 
    LEFT JOIN fees f ON s.id = f.student_id AND f.status = 'completed'
    $where $class_filter
    GROUP BY s.id
    ORDER BY s.id DESC
");

// Fetch classes for filter
$classes = $conn->query("SELECT DISTINCT class FROM students ORDER BY class");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Students - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
            color: white;
        }
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.8rem 1rem;
        }
        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            color: white;
            background: rgba(255, 255, 255, 0.1);
        }
        .watermark {
            position: fixed;
            bottom: 20px;
            right: 20px;
            opacity: 0.1;
            font-size: 24px;
            font-weight: bold;
            color: #000;
            pointer-events: none;
            z-index: 9999;
        }
        .payment-badge {
            font-size: 0.8rem;
        }
        .table-responsive {
            min-height: 400px;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 sidebar p-0">
                <div class="p-4">
                    <h4 class="text-center mb-4"><?php echo SITE_NAME; ?></h4>
                    <hr>
                    <ul class="nav flex-column">
                        <li class="nav-item">
                            <a class="nav-link" href="dashboard.php">
                                <i class="mdi mdi-view-dashboard me-2"></i> Dashboard
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link active" href="students.php">
                                <i class="mdi mdi-account-group me-2"></i> Students
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="fees.php">
                                <i class="mdi mdi-cash-multiple me-2"></i> Fees Management
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="reports.php">
                                <i class="mdi mdi-chart-bar me-2"></i> Reports
                            </a>
                        </li>
                        <?php if (is_admin()): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="settings.php">
                                <i class="mdi mdi-cog me-2"></i> Settings
                            </a>
                        </li>
                        <?php endif; ?>
                        <li class="nav-item mt-4">
                            <a class="nav-link text-danger" href="index.php?logout=1">
                                <i class="mdi mdi-logout me-2"></i> Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- Main content -->
            <div class="col-md-9 col-lg-10 ms-sm-auto px-4 py-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Student Management</h2>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addStudentModal">
                        <i class="mdi mdi-plus-circle me-1"></i> Add Student
                    </button>
                </div>

                <!-- Search and filter -->
                <div class="card mb-4">
                    <div class="card-body">
                        <form method="GET" class="row g-3">
                            <div class="col-md-6">
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Search students..." name="search" value="<?php echo htmlspecialchars($search); ?>">
                                    <button class="btn btn-outline-primary" type="submit">
                                        <i class="mdi mdi-magnify"></i> Search
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <select class="form-select" name="class">
                                    <option value="">Filter by Class</option>
                                    <?php while($class = $classes->fetch_assoc()): ?>
                                    <option value="<?php echo $class['class']; ?>" <?php echo isset($_GET['class']) && $_GET['class'] == $class['class'] ? 'selected' : ''; ?>>
                                        <?php echo $class['class']; ?>
                                    </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <a href="students.php" class="btn btn-outline-secondary w-100">Clear</a>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Alerts -->
                <?php if (isset($success)): ?>
                <div class="alert alert-success"><?php echo $success; ?></div>
                <?php endif; ?>
                
                <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo $error; ?></div>
                <?php endif; ?>

                <!-- Students table -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Student ID</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Class</th>
                                        <th>Payment Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($student = $students->fetch_assoc()): 
                                        $status = get_payment_status($student['paid_amount'], $student['total_amount']);
                                    ?>
                                    <tr>
                                        <td><?php echo $student['student_id']; ?></td>
                                        <td><?php echo $student['name']; ?></td>
                                        <td><?php echo $student['email']; ?></td>
                                        <td><?php echo $student['phone']; ?></td>
                                        <td><?php echo $student['class']; ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $status['class']; ?> payment-badge">
                                                <?php echo ucfirst($status['status']); ?> 
                                                (<?php echo format_currency($student['paid_amount']); ?> / <?php echo format_currency($student['total_amount']); ?>)
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editStudentModal" 
                                                data-id="<?php echo $student['id']; ?>"
                                                data-student_id="<?php echo $student['student_id']; ?>"
                                                data-name="<?php echo $student['name']; ?>"
                                                data-email="<?php echo $student['email']; ?>"
                                                data-phone="<?php echo $student['phone']; ?>"
                                                data-class="<?php echo $student['class']; ?>"
                                                data-guardian_name="<?php echo $student['guardian_name']; ?>"
                                                data-guardian_phone="<?php echo $student['guardian_phone']; ?>"
                                                data-address="<?php echo $student['address']; ?>">
                                                <i class="mdi mdi-pencil"></i>
                                            </button>
                                            <a href="students.php?delete=<?php echo $student['id']; ?>" class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Are you sure you want to delete this student?')">
                                                <i class="mdi mdi-delete"></i>
                                            </a>
                                            <a href="fees.php?student=<?php echo $student['id']; ?>" class="btn btn-sm btn-info">
                                                <i class="mdi mdi-cash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Student Modal -->
    <div class="modal fade" id="addStudentModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Student</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Student ID</label>
                                    <input type="text" class="form-control" name="student_id" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Class</label>
                                    <select class="form-select" name="class" required>
                                        <option value="">Select Class</option>
                                        <option value="KG">Kindergarten</option>
                                        <option value="Nursery">Nursery</option>
                                        <option value="Primary 1">Primary 1</option>
                                        <option value="Primary 2">Primary 2</option>
                                        <option value="Primary 3">Primary 3</option>
                                        <option value="Primary 4">Primary 4</option>
                                        <option value="Primary 5">Primary 5</option>
                                        <option value="Primary 6">Primary 6</option>
                                        <option value="JSS 1">JSS 1</option>
                                        <option value="JSS 2">JSS 2</option>
                                        <option value="JSS 3">JSS 3</option>
                                        <option value="SS 1">SS 1</option>
                                        <option value="SS 2">SS 2</option>
                                        <option value="SS 3">SS 3</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Full Name</label>
                                    <input type="text" class="form-control" name="name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Phone</label>
                                    <input type="text" class="form-control" name="phone" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Guardian Name</label>
                                    <input type="text" class="form-control" name="guardian_name">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Guardian Phone</label>
                                    <input type="text" class="form-control" name="guardian_phone">
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Address</label>
                            <textarea class="form-control" name="address" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="add_student" class="btn btn-primary">Add Student</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Student Modal -->
    <div class="modal fade" id="editStudentModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Student</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Student ID</label>
                                    <input type="text" class="form-control" name="student_id" id="edit_student_id" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Class</label>
                                    <select class="form-select" name="class" id="edit_class" required>
                                        <option value="">Select Class</option>
                                        <option value="KG">Kindergarten</option>
                                        <option value="Nursery">Nursery</option>
                                        <option value="Primary 1">Primary 1</option>
                                        <option value="Primary 2">Primary 2</option>
                                        <option value="Primary 3">Primary 3</option>
                                        <option value="Primary 4">Primary 4</option>
                                        <option value="Primary 5">Primary 5</option>
                                        <option value="Primary 6">Primary 6</option>
                                        <option value="JSS 1">JSS 1</option>
                                        <option value="JSS 2">JSS 2</option>
                                        <option value="JSS 3">JSS 3</option>
                                        <option value="SS 1">SS 1</option>
                                        <option value="SS 2">SS 2</option>
                                        <option value="SS 3">SS 3</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Full Name</label>
                                    <input type="text" class="form-control" name="name" id="edit_name" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" id="edit_email" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Phone</label>
                                    <input type="text" class="form-control" name="phone" id="edit_phone" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Guardian Name</label>
                                    <input type="text" class="form-control" name="guardian_name" id="edit_guardian_name">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Guardian Phone</label>
                                    <input type="text" class="form-control" name="guardian_phone" id="edit_guardian_phone">
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Address</label>
                            <textarea class="form-control" name="address" id="edit_address" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" name="edit_student" class="btn btn-primary">Update Student</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <?php apply_watermark(); ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Edit modal script
        var editStudentModal = document.getElementById('editStudentModal');
        editStudentModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            editStudentModal.querySelector('#edit_id').value = button.getAttribute('data-id');
            editStudentModal.querySelector('#edit_student_id').value = button.getAttribute('data-student_id');
            editStudentModal.querySelector('#edit_name').value = button.getAttribute('data-name');
            editStudentModal.querySelector('#edit_email').value = button.getAttribute('data-email');
            editStudentModal.querySelector('#edit_phone').value = button.getAttribute('data-phone');
            editStudentModal.querySelector('#edit_class').value = button.getAttribute('data-class');
            editStudentModal.querySelector('#edit_guardian_name').value = button.getAttribute('data-guardian_name');
            editStudentModal.querySelector('#edit_guardian_phone').value = button.getAttribute('data-guardian_phone');
            editStudentModal.querySelector('#edit_address').value = button.getAttribute('data-address');
        });
    </script>
</body>
</html>