-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Sep 10, 2025 at 11:26 AM
-- Server version: 8.0.37
-- PHP Version: 8.4.11

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `fuzesale_note9`
--

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `topic` varchar(255) NOT NULL,
  `user_age` int NOT NULL,
  `content` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `notes`
--

INSERT INTO `notes` (`id`, `user_id`, `topic`, `user_age`, `content`, `created_at`, `updated_at`) VALUES
(1, 3, 'The Digestive System of a Bird', 13, '```html\r\n<h1>Topic: The Digestive System of a Bird</h1>\r\n<hr>\r\n<h2>Learning Objective:</h2>\r\n<ul>\r\n  <li>At the end of the lesson, students should be able to:</li>\r\n    <ul>\r\n      <li>Identify the main parts of a bird\'s digestive system and their functions.</li>\r\n      <li>Explain how a bird\'s digestive system is adapted for processing food quickly.</li>\r\n      <li>Compare and contrast a bird\'s digestive system with the human digestive system.</li>\r\n      <li>Describe the importance of grit in a bird\'s digestion.</li>\r\n      <li>Understand how different diets affect the digestive systems of different bird species.</li>\r\n  </ul>\r\n</ul>\r\n\r\n<h2>Instructional Materials:</h2>\r\n<ul>\r\n  <li>Diagram or illustration of a bird\'s digestive system (can be found online or in textbooks).</li>\r\n  <li>Pictures or videos of different types of birds eating (e.g., a parrot eating seeds, an eagle eating meat).</li>\r\n  <li>Samples of birdseed or other bird food (if available).</li>\r\n  <li>Small pebbles or grit (for demonstration).</li>\r\n</ul>\r\n\r\n<h2>Previous Knowledge:</h2>\r\n<ul>\r\n  <li>Students should have a basic understanding of the human digestive system.</li>\r\n  <li>Students should know that different animals eat different types of food.</li>\r\n  <li>Students should understand the concept of adaptation (how animals are suited to their environment).</li>\r\n</ul>\r\n<hr>\r\n\r\n<h2>Step 1: Introduction and Definitions</h2>\r\n<p>Hello everyone! Today, we\'re diving into the fascinating world of bird digestion. Think about all the different birds you see around Nigeria – from the tiny sunbirds sipping nectar in your garden to the majestic eagles soaring overhead. They all need food to survive, and they all have special digestive systems to break down that food.</p>\r\n\r\n<p>So, what is digestion? <b>Digestion</b> is the process of breaking down food into smaller pieces that the body can absorb and use for energy, growth, and repair.</p>\r\n\r\n<p>Birds are unique because they need to digest food quickly to maintain their energy for flight. Let\'s explore how their digestive systems are designed to do just that!</p>\r\n\r\n<h2>Step 2: Break Down of the Topic</h2>\r\n<p>A bird\'s digestive system is like a specialized assembly line, with each part playing a crucial role. Let\'s take a look at the main parts:</p>\r\n\r\n<h3>1. The Beak (Mouth)</h3>\r\n<p>Unlike us, birds don\'t have teeth! Instead, they use their <b>beaks</b> to pick up and break food into smaller pieces. Think about a chicken pecking at grains – that\'s its beak at work.  Different birds have different beaks, adapted for different diets. A parrot has a strong, curved beak for cracking seeds, while an eagle has a sharp, hooked beak for tearing meat.</p>\r\n\r\n<h3>2. The Esophagus</h3>\r\n<p>The <b>esophagus</b> is a simple tube that connects the beak to the crop. It\'s like a food slide! It\'s responsible for transporting food from the mouth down to the next organ.</p>\r\n\r\n<h3>3. The Crop</h3>\r\n<p>The <b>crop</b> is a pouch-like storage organ at the base of the esophagus. Imagine it as a bird\'s \"lunchbox\". Here, food is stored and moistened, allowing the bird to eat a large amount of food quickly and then digest it later. Think of a pigeon that quickly gathers seeds and stores them in its crop before flying away to digest them in safety.</p>\r\n\r\n<h3>4. The Proventriculus (True Stomach)</h3>\r\n<p>The <b>proventriculus</b> is the bird\'s true stomach. This is where chemical digestion begins. It secretes acids and enzymes that start breaking down the food.  It\'s similar to our stomach, but it doesn\'t hold food for very long.</p>\r\n\r\n<h3>5. The Gizzard</h3>\r\n<p>The <b>gizzard</b> is a muscular organ that grinds food. Since birds don\'t have teeth, the gizzard takes on that role. It contains small stones or grit (tiny pebbles) that the bird swallows. These stones help to physically break down the food, like a grinding mill. Think about how chickens peck at the ground and swallow small stones – that\'s them getting grit for their gizzards! The gizzard is especially important for birds that eat seeds and grains.</p>\r\n\r\n<h3>6. The Small Intestine</h3>\r\n<p>The <b>small intestine</b> is where most of the digestion and absorption of nutrients happens. Here, enzymes from the pancreas and bile from the liver further break down the food. The nutrients are then absorbed into the bloodstream. It is similar to the human small intestine in the function</p>\r\n\r\n<h3>7. The Liver and Pancreas</h3>\r\n<p>These are accessory organs. The <b>Liver</b> produces bile, which helps digest fats. The <b>pancreas</b> produces enzymes that help digest carbohydrates, proteins, and fats.</p>\r\n\r\n<h3>8. The Large Intestine</h3>\r\n<p>The <b>large intestine</b> is short in birds. Its main function is to absorb water from the undigested food.  The large intestine of birds has a vestigial structure known as the caeca which contain bacteria that help to break down undigested plant materials</p>\r\n\r\n<h3>9. The Cloaca</h3>\r\n<p>The <b>cloaca</b> is a common chamber where the digestive, urinary, and reproductive systems all empty.  It\'s the final stop in the digestive process. Waste products (called feces) are then eliminated from the body through the vent, which is the external opening of the cloaca.</p>\r\n\r\n<h2>Adaptations in Bird Digestion</h2>\r\n\r\n<p>Bird digestive systems are specially adapted for their diets and lifestyles. The presence of the <b>crop</b> and <b>gizzard</b> are special adaptations for quick digestion. The size and structure of these organs can vary depending on the bird\'s diet. For example:</p>\r\n\r\n<ul>\r\n  <li>Birds that eat insects (insectivores) may have smaller crops and gizzards because insects are relatively easy to digest.</li>\r\n  <li>Birds that eat seeds (granivores) tend to have larger, more muscular gizzards to grind tough seeds.</li>\r\n  <li>Birds of prey (carnivores) like eagles have a proventriculus that secretes strong acids to digest meat. They also produce pellets of indigestible material like bones and feathers, which they regurgitate (cough up).</li>\r\n</ul>\r\n\r\n<h2>How Birds Compare to Humans</h2>\r\n\r\n<p>Both birds and humans have digestive systems that break down food for energy. However, there are some key differences:</p>\r\n\r\n<ul>\r\n  <li><b>Teeth:</b> Humans have teeth to chew food, while birds use their beaks and gizzard.</li>\r\n  <li><b>Crop and Gizzard:</b> Birds have a crop and gizzard, which humans lack.</li>\r\n  <li><b>Speed of Digestion:</b> Birds generally digest food much faster than humans, which is important for maintaining energy for flight.</li>\r\n  <li><b>Cloaca:</b> Birds have a cloaca, while mammals (including humans) have separate openings for digestion, urination, and reproduction.</li>\r\n</ul>\r\n\r\n<h2>Step 3: Summary of the Topic</h2>\r\n<p>So, to recap, a bird\'s digestive system is a highly efficient system designed to quickly process food. It includes the beak, esophagus, crop, proventriculus, gizzard, small intestine, liver, pancreas, large intestine, and cloaca. Each part plays a specific role in breaking down food, absorbing nutrients, and eliminating waste. Different birds have different adaptations in their digestive systems depending on their diet.</p>\r\n\r\n<h2>Assignment:</h2>\r\n\r\n<ol>\r\n  <li>Describe the function of the crop and explain why it is important for birds.</li>\r\n  <li>Explain the role of the gizzard and why birds swallow grit.</li>\r\n  <li>How does the beak of an eagle differ from the beak of a parrot, and how does this relate to their diet?</li>\r\n  <li>Compare and contrast the digestive system of a bird with the digestive system of a human.</li>\r\n  <li>Explain how the digestive system of a bird is adapted for flight.</li>\r\n</ol>\r\n```', '2025-09-10 09:54:41', '2025-09-10 09:54:41'),
(2, 1, 'The Digestive System of a lizard', 15, '```html\r\n <h1>The Digestive System of a Lizard</h1>\r\n <hr>\r\n <h2>Learning Objective:</h2>\r\n <ul>\r\n  <li>At the end of this lesson, students should be able to:</li>\r\n  <li>Describe the main parts of a lizard\'s digestive system.</li>\r\n  <li>Explain the function of each part in the digestion process.</li>\r\n  <li>Outline the differences in digestive systems based on lizard diet (e.g., insectivore vs. herbivore).</li>\r\n  <li>Understand how environmental factors like temperature affect lizard digestion.</li>\r\n  <li>Relate the lizard digestive system to other animal digestive systems.</li>\r\n </ul>\r\n <hr>\r\n <h2>Instructional Materials:</h2>\r\n <ul>\r\n  <li>Diagram or model of a lizard\'s digestive system</li>\r\n  <li>Pictures or videos of different lizards eating (e.g., a gecko eating an insect, an iguana eating leaves)</li>\r\n  <li>Worksheet with questions about the digestive system</li>\r\n  <li>(Optional) Preserved lizard or lizard skeleton for observation</li>\r\n </ul>\r\n <hr>\r\n <h2>Previous Knowledge:</h2>\r\n <p>Students should already know:</p>\r\n <ul>\r\n  <li>Basic concepts of digestion (breaking down food for energy).</li>\r\n  <li>The function of the mouth, stomach, and intestines in humans.</li>\r\n  <li>Different types of diets (herbivore, carnivore, omnivore, insectivore).</li>\r\n  <li>Basic reptile characteristics.</li>\r\n </ul>\r\n <hr>\r\n <h2>Step 1: Introduction and Definitions</h2>\r\n <p>Hey everyone! Today, we\'re diving into the fascinating world of lizards and how they digest their food. Think of it like this: you eat your jollof rice and chicken, but how does your body turn that into energy to play football or study? Lizards have a similar process, but with some cool adaptations. </p>\r\n <p><b>Digestion:</b> This is the process of breaking down food into smaller pieces that the body can absorb and use for energy, growth, and repair.</p>\r\n <p><b>Digestive System:</b> This is the group of organs that work together to break down food.</p>\r\n <p>Just like humans, lizards have a digestive system to break down their food. However, depending on what they eat (insects, plants, or other animals), their digestive systems might have slight differences.</p>\r\n\r\n <h2>Step 2: Breakdown of the Topic</h2>\r\n\r\n <h3>A. The Journey of Food Through a Lizard</h3>\r\n\r\n <p>Imagine a lizard, maybe a gecko in your house, catching a tasty insect. Let\'s follow that insect through its digestive system:</p>\r\n\r\n <h4>1. Mouth and Esophagus:</h4>\r\n <ul>\r\n  <li><b>Mouth:</b> Just like you use your mouth to chew food, lizards use their mouths to grab and sometimes chew their food. Some lizards have teeth for crushing insects, while others, like chameleons with their sticky tongues, just swallow their prey whole. Think of it like swallowing amala – no chewing involved!</li>\r\n  <li><b>Esophagus:</b> This is a tube that connects the mouth to the stomach. It\'s like a slide, pushing the food down. Muscles in the esophagus contract to move the food down, a process called peristalsis.</li>\r\n </ul>\r\n\r\n <h4>2. Stomach:</h4>\r\n <p>The stomach is like a food processor. It\'s a muscular sac that churns and mixes the food with strong digestive juices (acids and enzymes). These juices help break down the proteins and other nutrients in the insect. This process is similar to how your stomach breaks down the eba and soup you eat.</p>\r\n\r\n <h4>3. Small Intestine:</h4>\r\n <p>This is where the real magic happens! The small intestine is a long, coiled tube where most of the nutrients from the digested food are absorbed into the lizard\'s bloodstream. Think of it as a place where the goodness from the food is extracted and sent throughout the body. The small intestine has a large surface area (increased by structures called villi) to maximize absorption.</p>\r\n\r\n <h4>4. Large Intestine:</h4>\r\n <p>After the small intestine has taken all the good stuff, the remaining waste moves into the large intestine. Here, water is absorbed from the waste, making it more solid. It\'s like squeezing out the excess water from soaked garri before you drink it.</p>\r\n\r\n <h4>5. Cloaca:</h4>\r\n <p>The cloaca is a single opening at the end of the digestive system. It\'s a multi-purpose exit for waste (feces and urine), as well as for reproductive products (eggs or sperm). It’s like a “one-stop shop” for getting rid of everything that the lizard doesn\'t need. </p>\r\n\r\n <h4>6. Liver and Pancreas (Accessory Organs):</h4>\r\n <p>These organs aren\'t directly part of the digestive tract, but they play a crucial role in digestion. They are like helpers in the kitchen:</p>\r\n <ul>\r\n  <li><b>Liver:</b> Produces bile, which helps to break down fats. Think of bile like the detergent you use to wash oily plates.</li>\r\n  <li><b>Pancreas:</b> Produces enzymes that help to break down carbohydrates, proteins, and fats. These enzymes are like specialized tools for dismantling the food into its basic building blocks.</li>\r\n </ul>\r\n\r\n <h3>B. Diet and Digestive Adaptations</h3>\r\n\r\n <p>Not all lizards eat the same thing, so their digestive systems can be slightly different:</p>\r\n\r\n <ul>\r\n  <li><b>Insectivores (insect eaters):</b> Like geckos and chameleons. They often have shorter digestive tracts because insects are relatively easy to digest.</li>\r\n  <li><b>Herbivores (plant eaters):</b> Like iguanas. They have longer digestive tracts with specialized compartments to help break down tough plant material. Some also have symbiotic bacteria in their gut that help them digest cellulose (the main component of plant cell walls). This is similar to how cows digest grass!</li>\r\n  <li><b>Carnivores (meat eaters):</b> Like monitor lizards. Their digestive systems are adapted to digest meat, with strong stomach acids and enzymes.</li>\r\n </ul>\r\n\r\n <h3>C. Environmental Factors: Temperature</h3>\r\n <p>Lizards are ectothermic (cold-blooded), meaning their body temperature depends on the environment. Temperature plays a significant role in their digestion.</p>\r\n <ul>\r\n  <li><b>Higher Temperature:</b> Speeds up digestion. Lizards often bask in the sun to warm up and digest their food more efficiently.</li>\r\n  <li><b>Lower Temperature:</b> Slows down digestion. If a lizard gets too cold, its digestion will slow down significantly, and it may even regurgitate its food.</li>\r\n </ul>\r\n\r\n <h2>Step 3: Summary</h2>\r\n\r\n <p>So, to recap, a lizard\'s digestive system is a fascinating process that allows them to break down food for energy. It involves the mouth, esophagus, stomach, small intestine, large intestine, cloaca, liver, and pancreas. The type of food a lizard eats (insects, plants, or meat) affects the structure and function of its digestive system. Temperature also plays a critical role in how efficiently a lizard can digest its food. Just remember the gecko eating an insect – that\'s the whole process in action!</p>\r\n\r\n <h2>Assignment:</h2>\r\n <ol>\r\n  <li>What are the main parts of a lizard\'s digestive system?</li>\r\n  <li>How does the diet of a lizard affect its digestive system? Give examples.</li>\r\n  <li>Explain the role of the liver and pancreas in lizard digestion.</li>\r\n  <li>Why is temperature important for a lizard\'s digestion?</li>\r\n  <li>Compare and contrast the digestive system of a lizard with that of a human. What are the similarities and differences?</li>\r\n </ol>\r\n ```', '2025-09-10 10:01:58', '2025-09-10 10:01:58');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `role` enum('admin','user') DEFAULT 'user',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `email`, `full_name`, `role`, `created_at`) VALUES
(1, 'primeadmin', '$2y$10$egtoyRnuj0V4UDasrHzYK.1daUW.3MD0SWWzhqhHcjgU8u47zO6Su', 'admin@primeacademy.com.ng', 'Prime Academy Admin', 'admin', '2025-09-10 09:51:22'),
(2, 'teacher1', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'teacher1@primeacademy.com.ng', 'Demo Teacher', 'user', '2025-09-10 09:51:22'),
(3, 'prudenceeni', '$2y$10$egtoyRnuj0V4UDasrHzYK.1daUW.3MD0SWWzhqhHcjgU8u47zO6Su', 'prudenceeni@gmail.com', 'Emmanuel Abimbola', 'user', '2025-09-10 09:53:43');

-- --------------------------------------------------------

--
-- Table structure for table `user_activities`
--

CREATE TABLE `user_activities` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `activity` varchar(255) NOT NULL,
  `details` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `notes`
--
ALTER TABLE `notes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- Indexes for table `user_activities`
--
ALTER TABLE `user_activities`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `notes`
--
ALTER TABLE `notes`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `user_activities`
--
ALTER TABLE `user_activities`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `notes`
--
ALTER TABLE `notes`
  ADD CONSTRAINT `notes_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `user_activities`
--
ALTER TABLE `user_activities`
  ADD CONSTRAINT `user_activities_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
