<?php
require_once 'includes/auth.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Vine Note Maker - Home</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="header-content">
                <div class="logo-container">
                    <img src="assets/images/machform-logo.jpg" alt="Prime Gateway Academy Logo" class="logo">
                    <div class="app-name">Vine Note Maker</div>
                </div>
                
                <button class="menu-toggle">
                    <span></span>
                    <span></span>
                    <span></span>
                </button>
                
                <nav>
                    <ul>
                        <?php if (isLoggedIn()): ?>
                            <li><a href="notewriter.php">Note Writer</a></li>
                            <li><a href="mynotes.php">My Notes</a></li>
                            <li><a href="logout.php">Logout</a></li>
                            <?php if (isAdmin()): ?>
                                <li><a href="admin.php">Admin Panel</a></li>
                            <?php endif; ?>
                        <?php else: ?>
                            <li><a href="login.php">Login</a></li>
                            <li><a href="register.php">Register</a></li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <div class="container" style="padding: 30px 15px;">
        <div class="card">
            <h1>Vine Note Maker - V2</h1>
            <p>Your ultimate AI-powered lesson note generator! Designed for educators, Vine Note Maker simplifies lesson planning by creating detailed, curriculum-aligned notes tailored to your students' age and topic.</p>
            <p>Save time, boost productivity, and focus on teaching—Vine Note Maker handles the rest. Perfect for Nigerian educators, it's smart, fast, and hassle-free! 🚀📚</p>
            
            <?php if (isLoggedIn()): ?>
                <a href="notewriter.php" class="btn btn-primary">Start Creating Notes</a>
            <?php else: ?>
                <a href="register.php" class="btn btn-primary">Get Started</a>
            <?php endif; ?>
        </div>

        <div class="row">
            <div class="col">
                <div class="card">
                    <h2><i class="fas fa-robot"></i> AI-Powered</h2>
                    <p>Leverage advanced AI to generate comprehensive lesson notes tailored to your specific needs.</p>
                </div>
            </div>
            
            <div class="col">
                <div class="card">
                    <h2><i class="fas fa-graduation-cap"></i> Curriculum-Aligned</h2>
                    <p>Notes are specifically designed to align with the Nigerian educational curriculum.</p>
                </div>
            </div>
            
            <div class="col">
                <div class="card">
                    <h2><i class="fas fa-save"></i> Cloud Storage</h2>
                    <p>All your notes are securely saved and accessible from anywhere, anytime.</p>
                </div>
            </div>
        </div>

        <?php if (isLoggedIn()): ?>
        <div class="card">
            <h2>Your Recent Notes</h2>
            <?php
            $userNotes = getUserNotes($_SESSION['user']['id']);
            if (count($userNotes) > 0): 
            ?>
                <div class="notes-list">
                    <?php foreach (array_slice($userNotes, 0, 5) as $note): ?>
                        <div class="note-item">
                            <div class="note-title"><?php echo htmlspecialchars($note['topic']); ?></div>
                            <div class="note-meta">For age: <?php echo htmlspecialchars($note['user_age']); ?> | Created: <?php echo date('M j, Y', strtotime($note['created_at'])); ?></div>
                            <div class="note-actions">
                                <a href="notewriter.php?edit=<?php echo $note['id']; ?>" class="btn btn-primary">Edit</a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php if (count($userNotes) > 5): ?>
                    <p style="text-align: center; margin-top: 15px;">
                        <a href="notewriter.php">View all your notes</a>
                    </p>
                <?php endif; ?>
            <?php else: ?>
                <p>You haven't created any notes yet. <a href="notewriter.php">Create your first note</a>!</p>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>

    <footer>
        <div class="container">
            Copyright © 2025 - PRIME GATEWAY ACADEMY | Powered by <a href="https://vinesubtech.com.ng" target="_blank">VineSub Tech</a>.
        </div>
    </footer>

    <script src="assets/js/hide.js"></script>
</body>
</html>