<?php
require_once 'includes/auth.php';

if (isLoggedIn()) {
    header('Location: notewriter.php');
    exit();
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    
    $user = getUserByUsername($username);
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user'] = $user;
        header('Location: notewriter.php');
        exit();
    } else {
        $error = 'Invalid username or password';
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Vine Note Maker</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="header-content">
                <div class="logo-container">
                    <img src="assets/images/machform-logo.jpg" alt="Prime Gateway Academy Logo" class="logo">
                    <div class="app-name">Vine Note Maker</div>
                </div>
                
                <nav>
                    <ul>
                        <li><a href="index.php">Home</a></li>
                        <li><a href="register.php">Register</a></li>
                        <li><a href="mynotes.php">My Notes</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </header>

    <div class="container" style="max-width: 500px; padding: 40px 15px;">
        <div class="card">
            <h1>Login to Vine Note Maker</h1>
            
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo $error; ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label for="username">Username</label>
                    <input type="text" id="username" name="username" class="form-control" required>
                </div>
                
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" class="form-control" required>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%;">Login</button>
            </form>
            
            <p style="text-align: center; margin-top: 20px;">
                Don't have an account? <a href="register.php">Register here</a>
            </p>
            
            <div style="margin-top: 30px; padding: 15px; background: #f9f9f9; border-radius: 8px;">
                <h3>PRIME GATEWAY ACADEMY:</h3>
                
                <p><strong>Tel:</strong> +234703965126</p>
            </div>
        </div>
    </div>

    <footer>
        <div class="container">
            Copyright © 2025 - PRIME GATEWAY ACADEMY | Powered by <a href="https://vinesubtech.com.ng" target="_blank">VineSub Tech</a>.
        </div>
    </footer>

    <script src="assets/js/hide.js"></script>
</body>
</html>