<?php
// Setup script to create the necessary directory structure and copy the logo
function createDirectoryStructure() {
    $directories = [
        'data',
        'includes',
        'assets',
        'assets/css',
        'assets/js',
        'assets/images'
    ];
    
    foreach ($directories as $dir) {
        if (!file_exists($dir)) {
            mkdir($dir, 0755, true);
        }
    }
    
    // Create a placeholder logo if it doesn't exist
    if (!file_exists('assets/images/machform-logo.jpg')) {
        // Create a simple placeholder image
        $width = 200;
        $height = 100;
        $image = imagecreatetruecolor($width, $height);
        
        // Background color
        $bgColor = imagecolorallocate($image, 41, 128, 185);
        imagefill($image, 0, 0, $bgColor);
        
        // Text color
        $textColor = imagecolorallocate($image, 255, 255, 255);
        
        // Add text
        $text = "Prime Academy";
        $fontSize = 5;
        $textX = ($width - imagefontwidth($fontSize) * strlen($text)) / 2;
        $textY = ($height - imagefontheight($fontSize)) / 2;
        imagestring($image, $fontSize, $textX, $textY, $text, $textColor);
        
        // Save image
        imagejpeg($image, 'assets/images/machform-logo.jpg');
        imagedestroy($image);
    }
    
    echo "Setup completed successfully!<br>";
    echo "Directory structure created.<br>";
    echo "Placeholder logo created at: assets/images/machform-logo.jpg<br>";
    echo "You can now access the application at: <a href='index.php'>index.php</a><br>";
    echo "Default admin credentials: primeadmin / Pr!!ime123##<br>";
    echo "Default user credentials: teacher1 / Teach##!!!<br>";
}

createDirectoryStructure();
?>