-- phpMyAdmin SQL Dump
-- version 5.2.2
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Sep 01, 2025 at 12:36 PM
-- Server version: 8.0.37
-- PHP Version: 8.4.10

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `fuzesale_noteai`
--

-- --------------------------------------------------------

--
-- Table structure for table `announcements`
--

CREATE TABLE `announcements` (
  `id` int NOT NULL,
  `title` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `priority` enum('low','medium','high') DEFAULT 'medium',
  `is_active` tinyint(1) DEFAULT '1',
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `announcements`
--

INSERT INTO `announcements` (`id`, `title`, `content`, `priority`, `is_active`, `start_date`, `end_date`, `created_by`, `created_at`, `updated_at`) VALUES
(1, 'Welcome to Vine AI Note Maker', 'We are excited to have you on board! This platform will help you create lesson notes quickly and efficiently using AI technology.', 'high', 1, NULL, NULL, 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45');

-- --------------------------------------------------------

--
-- Table structure for table `announcement_views`
--

CREATE TABLE `announcement_views` (
  `id` int NOT NULL,
  `announcement_id` int NOT NULL,
  `user_id` int NOT NULL,
  `viewed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `credit_packages`
--

CREATE TABLE `credit_packages` (
  `id` int NOT NULL,
  `name` varchar(100) NOT NULL,
  `credits` int NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `credit_packages`
--

INSERT INTO `credit_packages` (`id`, `name`, `credits`, `price`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'Starter Pack', 10, 1000.00, 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(2, 'Teacher Pack', 25, 2000.00, 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(3, 'School Pack', 100, 7000.00, 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45');

-- --------------------------------------------------------

--
-- Table structure for table `credit_transactions`
--

CREATE TABLE `credit_transactions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `admin_id` int DEFAULT NULL,
  `credits` int NOT NULL,
  `type` enum('purchase','reward','penalty','adjustment','system') DEFAULT 'adjustment',
  `description` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `credit_transactions`
--

INSERT INTO `credit_transactions` (`id`, `user_id`, `admin_id`, `credits`, `type`, `description`, `created_at`) VALUES
(1, 4, NULL, 10, 'purchase', 'Credit purchase - Package: Starter Pack', '2025-08-31 11:34:03'),
(2, 4, NULL, 10, 'purchase', 'Credit purchase - Package: Starter Pack', '2025-08-31 11:34:10'),
(3, 4, NULL, 1, 'penalty', 'AI note generation', '2025-08-31 11:34:50');

-- --------------------------------------------------------

--
-- Table structure for table `email_templates`
--

CREATE TABLE `email_templates` (
  `id` int NOT NULL,
  `name` varchar(100) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `variables` text,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `email_templates`
--

INSERT INTO `email_templates` (`id`, `name`, `subject`, `content`, `variables`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'welcome', 'Welcome to Vine AI Note Maker', 'Hello {user_name},\n\nWelcome to Vine AI Note Maker! Your account has been successfully created.\n\nYou can now login using:\nUsername: {username}\n\nThank you for joining us!\n\nBest regards,\nVineSub Tech Team', 'user_name,username', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(2, 'credit_purchase', 'Credit Purchase Confirmation', 'Hello {user_name},\n\nYour credit purchase has been confirmed. You have received {credits} credits.\n\nYour total available credits: {total_credits}\n\nThank you for your purchase!\n\nBest regards,\nVineSub Tech Team', 'user_name,credits,total_credits', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(3, 'account_suspended', 'Account Suspension Notice', 'Hello {user_name},\n\nYour account has been suspended for the following reason:\n{reason}\n\nIf you believe this is a mistake, please contact support.\n\nBest regards,\nVineSub Tech Team', 'user_name,reason', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(4, 'password_reset', 'Password Reset Request', 'Hello {user_name},\n\nYou requested a password reset. Use this code to reset your password: {reset_code}\n\nIf you didn\'t request this, please ignore this email.\n\nBest regards,\nVineSub Tech Team', 'user_name,reset_code', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45');

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `topic` varchar(255) NOT NULL,
  `age_group` int NOT NULL,
  `content` text NOT NULL,
  `word_count` int DEFAULT '0',
  `ai_generated` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `notes`
--

INSERT INTO `notes` (`id`, `user_id`, `topic`, `age_group`, `content`, `word_count`, `ai_generated`, `created_at`, `updated_at`) VALUES
(2, 4, 'Ruminant Animals', 13, 'AI-generated content for topic: Ruminant Animals for age group: 13 years. This would be generated using the Gemini API in a real implementation.', 22, 1, '2025-08-31 11:34:50', '2025-08-31 11:34:50');

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `package_id` int NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `credits` int NOT NULL,
  `status` enum('pending','completed','failed','cancelled') DEFAULT 'pending',
  `flutterwave_ref` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `payments`
--

INSERT INTO `payments` (`id`, `user_id`, `package_id`, `transaction_id`, `amount`, `credits`, `status`, `flutterwave_ref`, `created_at`, `updated_at`) VALUES
(1, 4, 1, '9602650', 1000.00, 10, 'completed', 'CREDITS_1_1756640207949', '2025-08-31 11:34:03', '2025-08-31 11:34:03'),
(2, 4, 1, '9602650', 1000.00, 10, 'completed', 'CREDITS_1_1756640207949', '2025-08-31 11:34:10', '2025-08-31 11:34:10');

-- --------------------------------------------------------

--
-- Table structure for table `settings`
--

CREATE TABLE `settings` (
  `id` int NOT NULL,
  `setting_key` varchar(50) NOT NULL,
  `setting_value` text NOT NULL,
  `description` text,
  `is_public` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings` (`id`, `setting_key`, `setting_value`, `description`, `is_public`, `created_at`, `updated_at`) VALUES
(1, 'app_name', 'Vine AI Note Maker - NERDC Compliant', 'The name of the application', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(2, 'app_version', '2.0', 'Current application version', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(3, 'default_credits', '2', 'Default number of credits for new users', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(4, 'max_notes_per_day', '10', 'Maximum number of notes a user can create per day', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(5, 'ai_api_key', 'AIzaSyDbjf0QmBkJ1Mc0gMt0Wwp2B68nygD6zKs', 'Gemini AI API Key', 0, '2025-08-31 08:27:45', '2025-08-31 11:18:21'),
(6, 'admin_email', 'admin@vinesubtech.com.ng', 'Administrator email address', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(7, 'site_url', 'http://p.vinesubtech.com.ng/noteaiv7', 'Application URL', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(8, 'allow_registrations', '1', 'Whether new user registrations are allowed', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(9, 'maintenance_mode', '0', 'Put the site in maintenance mode', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(10, 'logo_url', '/assets/logo.png', 'Application logo URL', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(11, 'currency', '₦', 'Currency symbol', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(12, 'credit_price', '500', 'Price per credit in currency units', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(13, 'min_credits_purchase', '5', 'Minimum credits that can be purchased', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(14, 'max_credits_purchase', '100', 'Maximum credits that can be purchased', 1, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(15, 'smtp_host', 'mail.vinsubtech.com.ng', 'SMTP Host', 0, '2025-08-31 08:27:45', '2025-08-31 11:15:24'),
(16, 'smtp_port', '587', 'SMTP Port', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(17, 'smtp_username', 'info@vinesubtech.com.ng', 'SMTP Username', 0, '2025-08-31 08:27:45', '2025-08-31 11:15:24'),
(18, 'smtp_password', '!!!###1985ENi!!!', 'SMTP Password', 0, '2025-08-31 08:27:45', '2025-08-31 11:15:24'),
(19, 'smtp_encryption', 'tls', 'SMTP Encryption', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(20, 'from_email', 'info@vinesubtech.com.ng', 'From Email Address', 0, '2025-08-31 08:27:45', '2025-08-31 11:15:24'),
(21, 'from_name', 'Vine AI Note Maker', 'From Name', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(22, 'flutterwave_public_key', 'FLWPUBK_TEST-f26775e5e83f115f3f45af2d909e7ae7-X', 'Flutterwave Public Key', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(23, 'flutterwave_secret_key', 'FLWSECK_TEST-3447186033d6923b01e27e961cd102c5-X', 'Flutterwave Secret Key', 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45');

-- --------------------------------------------------------

--
-- Table structure for table `support_tickets`
--

CREATE TABLE `support_tickets` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
  `status` enum('open','in_progress','resolved','closed') DEFAULT 'open',
  `admin_notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `system_logs`
--

CREATE TABLE `system_logs` (
  `id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `description` text,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `system_logs`
--

INSERT INTO `system_logs` (`id`, `user_id`, `action`, `description`, `ip_address`, `user_agent`, `created_at`) VALUES
(1, 3, 'login', 'User logged in', '105.112.213.224', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:13:33'),
(2, 3, 'update_settings', 'Updated system settings', '105.112.213.224', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:15:24'),
(3, 3, 'update_settings', 'Updated system settings', '105.112.213.224', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:18:21'),
(4, 4, 'register', 'New user registration', '105.112.213.224', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:30:57'),
(5, 4, 'login', 'User logged in', '105.112.213.224', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:31:56'),
(6, 4, 'create_note', 'Created note: Ruminant Animals', '105.112.213.224', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-08-31 11:34:50'),
(7, 3, 'login', 'User logged in', '105.112.215.144', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-09-01 11:35:21'),
(8, 3, 'login', 'User logged in', '105.112.215.144', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36', '2025-09-01 11:35:46');

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

CREATE TABLE `transactions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `package_id` int NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `tx_ref` varchar(255) NOT NULL,
  `flutterwave_tx_id` varchar(255) DEFAULT NULL,
  `status` enum('pending','completed','failed','cancelled') DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `school` varchar(100) DEFAULT NULL,
  `note_credits` int DEFAULT '2',
  `role` enum('admin','teacher') DEFAULT 'teacher',
  `status` enum('active','suspended','pending') DEFAULT 'active',
  `last_login` datetime DEFAULT NULL,
  `login_count` int DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `email`, `full_name`, `school`, `note_credits`, `role`, `status`, `last_login`, `login_count`, `created_at`, `updated_at`) VALUES
(1, 'admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@vinesubtech.com.ng', 'System Administrator', 'VineSub Tech', 9999, 'admin', 'active', NULL, 0, '2025-08-31 08:27:45', '2025-08-31 08:27:45'),
(2, 'teacherai', '$2y$10$jp7nN77ftKC0BDpwcZ2eM.cCkL4WgM5yKd5yeVDaLwI3kEwjxJM4y', 'teacher@example.com', 'Demo Teacher', 'Demo School', 1, 'teacher', 'active', NULL, 0, '2025-08-31 08:27:45', '2025-08-31 08:35:36'),
(3, 'prudenceeni', '$2y$10$jp7nN77ftKC0BDpwcZ2eM.cCkL4WgM5yKd5yeVDaLwI3kEwjxJM4y', 'prudenceeni@gmai.com', 'Emmanuel', 'PRIME', 2, 'admin', 'active', '2025-09-01 12:35:46', 3, '2025-08-31 08:29:49', '2025-09-01 11:35:46'),
(4, 'linabliss', '$2y$10$LHdIjnliikhvEjffrz5f8etLQXWuKuTCTUjj69hzAxNrfG2sjFi2u', 'penelopecampbell46@gmail.com', 'Lina Bliss', 'PRIME', 21, 'teacher', 'active', '2025-08-31 12:31:56', 1, '2025-08-31 11:30:57', '2025-08-31 11:34:50');

-- --------------------------------------------------------

--
-- Table structure for table `user_sessions`
--

CREATE TABLE `user_sessions` (
  `id` int NOT NULL,
  `user_id` int NOT NULL,
  `session_id` varchar(255) NOT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `login_time` datetime NOT NULL,
  `last_activity` datetime NOT NULL,
  `logout_time` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `announcements`
--
ALTER TABLE `announcements`
  ADD PRIMARY KEY (`id`),
  ADD KEY `created_by` (`created_by`);

--
-- Indexes for table `announcement_views`
--
ALTER TABLE `announcement_views`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_announcement_view` (`announcement_id`,`user_id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `credit_packages`
--
ALTER TABLE `credit_packages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `credit_transactions`
--
ALTER TABLE `credit_transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `admin_id` (`admin_id`);

--
-- Indexes for table `email_templates`
--
ALTER TABLE `email_templates`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `notes`
--
ALTER TABLE `notes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `package_id` (`package_id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `setting_key` (`setting_key`);

--
-- Indexes for table `support_tickets`
--
ALTER TABLE `support_tickets`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `system_logs`
--
ALTER TABLE `system_logs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `transactions`
--
ALTER TABLE `transactions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `package_id` (`package_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indexes for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `announcements`
--
ALTER TABLE `announcements`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `announcement_views`
--
ALTER TABLE `announcement_views`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `credit_packages`
--
ALTER TABLE `credit_packages`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `credit_transactions`
--
ALTER TABLE `credit_transactions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `email_templates`
--
ALTER TABLE `email_templates`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `notes`
--
ALTER TABLE `notes`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=24;

--
-- AUTO_INCREMENT for table `support_tickets`
--
ALTER TABLE `support_tickets`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `system_logs`
--
ALTER TABLE `system_logs`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `transactions`
--
ALTER TABLE `transactions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `user_sessions`
--
ALTER TABLE `user_sessions`
  MODIFY `id` int NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `announcements`
--
ALTER TABLE `announcements`
  ADD CONSTRAINT `announcements_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `announcement_views`
--
ALTER TABLE `announcement_views`
  ADD CONSTRAINT `announcement_views_ibfk_1` FOREIGN KEY (`announcement_id`) REFERENCES `announcements` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `announcement_views_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `credit_transactions`
--
ALTER TABLE `credit_transactions`
  ADD CONSTRAINT `credit_transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `credit_transactions_ibfk_2` FOREIGN KEY (`admin_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `notes`
--
ALTER TABLE `notes`
  ADD CONSTRAINT `notes_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `payments_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `payments_ibfk_2` FOREIGN KEY (`package_id`) REFERENCES `credit_packages` (`id`);

--
-- Constraints for table `support_tickets`
--
ALTER TABLE `support_tickets`
  ADD CONSTRAINT `support_tickets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `system_logs`
--
ALTER TABLE `system_logs`
  ADD CONSTRAINT `system_logs_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `transactions`
--
ALTER TABLE `transactions`
  ADD CONSTRAINT `transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `transactions_ibfk_2` FOREIGN KEY (`package_id`) REFERENCES `credit_packages` (`id`);

--
-- Constraints for table `user_sessions`
--
ALTER TABLE `user_sessions`
  ADD CONSTRAINT `user_sessions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
