<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_noteai');
define('DB_USER', 'fuzesale_noteai');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Vine AI Note Maker - NERDC Compliant');
define('SITE_URL', 'https://p.vinesubtech.com.ng/noteaiv7');

// Flutterwave configuration
define('FLW_PUBLIC_KEY', 'FLWPUBK_TEST-f26775e5e83f115f3f45af2d909e7ae7-X');
define('FLW_SECRET_KEY', 'FLWSECK_TEST-3447186033d6923b01e27e961cd102c5-X');

// Gemini AI configuration
define('GEMINI_API_KEY', 'AIzaSyDbjf0QmBkJ1Mc0gMt0Wwp2B68nygD6zKs');
define('GEMINI_API_URL', 'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent');

// Start session
session_start();

// Database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Get settings from database
function getSetting($key, $default = '') {
    global $pdo;
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->execute([$key]);
    $result = $stmt->fetchColumn();
    return $result !== false ? $result : $default;
}

// Check if user is logged in
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Check if user is admin
function isAdmin() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

// Redirect if not logged in
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit();
    }
}

// Redirect if not admin
function requireAdmin() {
    requireLogin();
    if (!isAdmin()) {
        header('Location: dashboard.php');
        exit();
    }
}

// Get user data
function getUserData($user_id) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    return $stmt->fetch();
}

// Log action to system logs
function logAction($user_id, $action, $description = '') {
    global $pdo;
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    
    $stmt = $pdo->prepare("INSERT INTO system_logs (user_id, action, description, ip_address, user_agent) VALUES (?, ?, ?, ?, ?)");
    return $stmt->execute([$user_id, $action, $description, $ip_address, $user_agent]);
}

// Generate AI content using Gemini API
function generateAIContent($topic, $age_group) {
    $prompt = "Create a comprehensive note for Nigerian students on the topic: '$topic'. 
    The students are $age_group years old. The note should be NERDC compliant and include:
    Learning Objective: (list out the learning objectives. Example: At the end of the lesson, students should be able to - {Objectives based on the topic})
                Instructional Materials: (list out the suitable instructional materials).
                Previous Knowledge: (State the expected previous knowledge based on the topic).
<hr>
                Step 1: Introduction and definitions.
                Step 2: break down of the topic based on the input.
                Step 3: Summary of the topic.
                Assignment: Ask five relevant questions based on the topic.
                Format using fancy texts for easy readability, include headings, bold, colored fonts, italics, paragraphs, numberings and other human readable frmatings. . 
                Include as much key points as possible, tailor entire explanation to suit Nigerian curricul
    
    Make it practical, engaging, and suitable for the age group.";
    
    $data = [
        'contents' => [
            [
                'parts' => [
                    [
                        'text' => $prompt
                    ]
                ]
            ]
        ]
    ];
    
    $url = GEMINI_API_URL . "?key=" . GEMINI_API_KEY;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json'
    ]);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    $result = json_decode($response, true);
    
    if (isset($result['candidates'][0]['content']['parts'][0]['text'])) {
        return $result['candidates'][0]['content']['parts'][0]['text'];
    } else {
        error_log("Gemini API Error: " . $response);
        return "I apologize, but I'm having trouble generating the lesson note at the moment. Please try again later or contact support if the issue persists.";
    }
}

// Export note as PDF
function exportNoteAsPDF($note) {
    require_once 'vendor/autoload.php';
    
    $mpdf = new \Mpdf\Mpdf();
    $mpdf->WriteHTML('<h1>' . htmlspecialchars($note['topic']) . '</h1>');
    $mpdf->WriteHTML('<p><strong>Age Group:</strong> ' . $note['age_group'] . ' years</p>');
    $mpdf->WriteHTML('<p><strong>Created:</strong> ' . date('F j, Y', strtotime($note['created_at'])) . '</p>');
    $mpdf->WriteHTML('<hr>');
    $mpdf->WriteHTML(nl2br(htmlspecialchars($note['content'])));
    
    $filename = 'lesson_note_' . $note['id'] . '.pdf';
    $mpdf->Output($filename, 'D');
    exit;
}

// Export note as Word document
function exportNoteAsWord($note) {
    header("Content-type: application/vnd.ms-word");
    header("Content-Disposition: attachment; filename=lesson_note_" . $note['id'] . ".doc");
    
    echo "<html>";
    echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=Windows-1252\">";
    echo "<body>";
    echo "<h1>" . htmlspecialchars($note['topic']) . "</h1>";
    echo "<p><strong>Age Group:</strong> " . $note['age_group'] . " years</p>";
    echo "<p><strong>Created:</strong> " . date('F j, Y', strtotime($note['created_at'])) . "</p>";
    echo "<hr>";
    echo nl2br(htmlspecialchars($note['content']));
    echo "</body>";
    echo "</html>";
    exit;
}
?>