<?php
require_once 'config.php';

// Check if user is logged in, redirect to dashboard
if (isset($_SESSION['user_id'])) {
    if (isAdmin()) {
        header('Location: admin.php');
    } else {
        header('Location: dashboard.php');
    }
    exit();
}

// Get credit packages for display on homepage
$credit_packages = $pdo->query("SELECT * FROM credit_packages WHERE is_active = 1 ORDER BY credits LIMIT 3")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
            <div class="container">
                <a class="navbar-brand" href="index.php">
                    <i class="fas fa-book-open me-2"></i>
                    <?php echo SITE_NAME; ?>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ms-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="#features">Features</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#how-it-works">How It Works</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#pricing">Pricing</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#about">About</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="login.php">Login</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link btn btn-outline-light ms-2" href="register.php">Register</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    </header>

    <main>
        <!-- Hero Section -->
        <section class="hero py-5 bg-gradient-primary">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <h1 class="display-4 fw-bold text-white mb-4">Revolutionize Your Lesson Planning</h1>
                        <p class="lead text-light mb-4">AI-powered lesson note generation tailored to the Nigerian curriculum. Save time and focus on teaching.</p>
                        <div class="hero-buttons">
                            <a href="register.php" class="btn btn-light btn-lg me-3 mb-3">
                                <i class="fas fa-rocket me-2"></i>Get Started
                            </a>
                            <a href="#demo" class="btn btn-outline-light btn-lg mb-3">
                                <i class="fas fa-play-circle me-2"></i>See Demo
                            </a>
                        </div>
                        <div class="d-flex align-items-center text-light mt-4">
                            <div class="me-4">
                                <i class="fas fa-check-circle me-2"></i>NERDC Compliant
                            </div>
                            <div class="me-4">
                                <i class="fas fa-check-circle me-2"></i>AI-Powered
                            </div>
                            <div>
                                <i class="fas fa-check-circle me-2"></i>Time-Saving
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 text-center">
                        <div class="hero-image-container">
                            <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAwIiBoZWlnaHQ9IjQwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMTAwJSIgaGVpZ2h0PSIxMDAlIiBmaWxsPSIjZmZmZmZmIiBvcGFjaXR5PSIwLjAzIi8+PGcgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoNTAsIDUwKSI+PGNpcmNsZSBjeD0iMjAwIiBjeT0iMTUwIiByPSI4MCIgZmlsbD0iIzRlNzNkZiIvPjxwYXRoIGQ9Ik0xMDAgMjUwIEwyMDAgMTUwIEwzMDAgMjUwIiBzdHJva2U9IiM0ZTczZGYiIHN0cm9rZS13aWR0aD0iNCIgZmlsbD0ibm9uZSIvPjx0ZXh0IHg9IjIwMCIgeT0iMjgwIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmb250LWZhbWlseT0iUG9wcGlucyIgZm9udC1zaXplPSIyMCIgZm9udC13ZWlnaHQ9ImJvbGQiIGZpbGw9IiM0ZTczZGYiPkxlc3NvbiBOb3RlczwvdGV4dD48dGV4dCB4PSIyMDAiIHk9IjMxMCIgdGV4dC1hbmNob3I9Im1pZGRsZSIgZm9udC1mYW1pbHk9IlBvcHBpbnMiIGZvbnQtc2l6ZT0iMTYiIGZpbGw9IiM0ZTczZGYiPkdlbmVyYXRlZCBieSBBSTwvdGV4dD48L2c+PC9zdmc+" alt="Lesson Note Generation" class="img-fluid rounded shadow-lg">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Features Section -->
        <section id="features" class="py-5 bg-light">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-12 text-center">
                        <h2 class="display-5 fw-bold text-primary mb-3">Powerful Features</h2>
                        <p class="lead text-muted">Everything you need to create exceptional lesson notes</p>
                    </div>
                </div>
                <div class="row g-4">
                    <div class="col-md-6 col-lg-3">
                        <div class="card feature-card h-100 border-0 shadow-sm">
                            <div class="card-body text-center p-4">
                                <div class="feature-icon mb-3">
                                    <i class="fas fa-robot fa-3x text-primary"></i>
                                </div>
                                <h4 class="card-title">AI-Powered</h4>
                                <p class="card-text text-muted">Generate comprehensive lesson notes using advanced AI technology.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card feature-card h-100 border-0 shadow-sm">
                            <div class="card-body text-center p-4">
                                <div class="feature-icon mb-3">
                                    <i class="fas fa-graduation-cap fa-3x text-primary"></i>
                                </div>
                                <h4 class="card-title">Curriculum-Aligned</h4>
                                <p class="card-text text-muted">Notes tailored to the Nigerian educational curriculum standards.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card feature-card h-100 border-0 shadow-sm">
                            <div class="card-body text-center p-4">
                                <div class="feature-icon mb-3">
                                    <i class="fas fa-clock fa-3x text-primary"></i>
                                </div>
                                <h4 class="card-title">Time-Saving</h4>
                                <p class="card-text text-muted">Reduce lesson planning time from hours to minutes.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card feature-card h-100 border-0 shadow-sm">
                            <div class="card-body text-center p-4">
                                <div class="feature-icon mb-3">
                                    <i class="fas fa-mobile-alt fa-3x text-primary"></i>
                                </div>
                                <h4 class="card-title">Mobile-Friendly</h4>
                                <p class="card-text text-muted">Access your notes from any device, anywhere.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- How It Works Section -->
        <section id="how-it-works" class="py-5">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-12 text-center">
                        <h2 class="display-5 fw-bold text-primary mb-3">How It Works</h2>
                        <p class="lead text-muted">Create professional lesson notes in just a few simple steps</p>
                    </div>
                </div>
                <div class="row g-4">
                    <div class="col-md-6 col-lg-3">
                        <div class="text-center">
                            <div class="step-number mb-3">1</div>
                            <h4>Sign Up</h4>
                            <p class="text-muted">Create your teacher account with your details.</p>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="text-center">
                            <div class="step-number mb-3">2</div>
                            <h4>Enter Details</h4>
                            <p class="text-muted">Provide the topic and student age for your lesson note.</p>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="text-center">
                            <div class="step-number mb-3">3</div>
                            <h4>Generate</h4>
                            <p class="text-muted">Let our AI create a comprehensive lesson note for you.</p>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="text-center">
                            <div class="step-number mb-3">4</div>
                            <h4>Customize & Use</h4>
                            <p class="text-muted">Edit, download, or print your ready-to-use lesson note.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Pricing Section -->
        <section id="pricing" class="py-5 bg-light">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-12 text-center">
                        <h2 class="display-5 fw-bold text-primary mb-3">Affordable Pricing</h2>
                        <p class="lead text-muted">Choose the plan that works best for you</p>
                    </div>
                </div>
                <div class="row g-4 justify-content-center">
                    <?php foreach ($credit_packages as $package): ?>
                    <div class="col-md-6 col-lg-4">
                        <div class="card pricing-card h-100 border-0 shadow">
                            <div class="card-header bg-primary text-white text-center py-4">
                                <h4 class="mb-0"><?php echo htmlspecialchars($package['name']); ?></h4>
                            </div>
                            <div class="card-body text-center p-4">
                                <h2 class="price display-4 fw-bold text-primary mb-2">₦<?php echo number_format($package['price'], 0); ?></h2>
                                <p class="text-muted mb-4">One-time payment</p>
                                <ul class="list-unstyled mb-4">
                                    <li class="mb-2">
                                        <i class="fas fa-check text-success me-2"></i>
                                        <strong><?php echo $package['credits']; ?></strong> AI Note Generations
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check text-success me-2"></i>
                                        No expiration date
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check text-success me-2"></i>
                                        Full editing capabilities
                                    </li>
                                    <li class="mb-2">
                                        <i class="fas fa-check text-success me-2"></i>
                                        Download & print options
                                    </li>
                                </ul>
                                <a href="register.php" class="btn btn-primary w-100">Get Started</a>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <div class="row mt-5">
                    <div class="col-12 text-center">
                        <p class="text-muted">All plans include a free trial with <?php echo getSetting('default_credits', '2'); ?> AI note generations</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Demo Section -->
        <section id="demo" class="py-5">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-12 text-center">
                        <h2 class="display-5 fw-bold text-primary mb-3">See It In Action</h2>
                        <p class="lead text-muted">Check out a sample lesson note generated by our AI</p>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="card demo-card border-0 shadow">
                            <div class="card-header bg-primary text-white py-3">
                                <h4 class="mb-0">Sample Lesson Note</h4>
                            </div>
                            <div class="card-body">
                                <div class="demo-content">
                                    <p><strong>Topic:</strong> Introduction to Photosynthesis</p>
                                    <p><strong>Age Group:</strong> 12 years</p>
                                    <p><strong>Learning Objectives:</strong> Students will understand the process of photosynthesis and its importance.</p>
                                    <p><strong>Key Points:</strong> Chlorophyll, sunlight, carbon dioxide, water, glucose, oxygen</p>
                                    <div class="mt-3 p-3 bg-light rounded">
                                        <h5>Sample Content:</h5>
                                        <p>Photosynthesis is the process by which plants use sunlight, water, and carbon dioxide to create oxygen and energy in the form of sugar. This process is essential for life on Earth as it provides the oxygen we breathe and the food we eat.</p>
                                        <p>During photosynthesis, plants absorb light energy with chlorophyll, a green pigment in their leaves. This energy is used to convert carbon dioxide from the air and water from the soil into glucose (a sugar) and oxygen.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- About Section -->
        <section id="about" class="py-5 bg-light">
            <div class="container">
                <div class="row mb-5">
                    <div class="col-12 text-center">
                        <h2 class="display-5 fw-bold text-primary mb-3">About VineSub Tech</h2>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-8 text-center">
                        <p class="lead mb-4">VineSub Tech is dedicated to creating innovative educational technology solutions for Nigerian educators. Our mission is to empower teachers with tools that enhance productivity and improve learning outcomes.</p>
                        <div class="about-info d-flex flex-wrap justify-content-center gap-4 mt-4">
                            <div class="info-item">
                                <i class="fas fa-map-marker-alt fa-2x text-primary mb-2"></i>
                                <p class="mb-0">Nigeria</p>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-envelope fa-2x text-primary mb-2"></i>
                                <p class="mb-0">info@vinesubtech.com.ng</p>
                            </div>
                            <div class="info-item">
                                <i class="fas fa-globe fa-2x text-primary mb-2"></i>
                                <p class="mb-0">www.vinesubtech.com.ng</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section class="py-5 bg-gradient-primary text-white">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8 text-center">
                        <h2 class="display-5 fw-bold mb-4">Ready to Transform Your Lesson Planning?</h2>
                        <p class="lead mb-4">Join thousands of teachers who are already saving time with AI-powered lesson notes</p>
                        <a href="register.php" class="btn btn-light btn-lg px-5">
                            <i class="fas fa-user-plus me-2"></i>Get Started Now
                        </a>
                        <p class="mt-3">Free trial includes <?php echo getSetting('default_credits', '2'); ?> AI note generations - no credit card required</p>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="bg-dark text-white py-5">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-4">
                    <h5 class="text-primary mb-4"><?php echo SITE_NAME; ?></h5>
                    <p>Empowering educators with AI-powered lesson planning tools.</p>
                    <div class="social-icons mt-4">
                        <a href="#" class="text-white me-3"><i class="fab fa-facebook-f"></i></a>
                        <a href="#" class="text-white me-3"><i class="fab fa-twitter"></i></a>
                        <a href="#" class="text-white me-3"><i class="fab fa-instagram"></i></a>
                        <a href="#" class="text-white"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
                <div class="col-md-2">
                    <h5 class="text-primary mb-4">Quick Links</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#features" class="text-white text-decoration-none">Features</a></li>
                        <li class="mb-2"><a href="#how-it-works" class="text-white text-decoration-none">How It Works</a></li>
                        <li class="mb-2"><a href="#pricing" class="text-white text-decoration-none">Pricing</a></li>
                        <li class="mb-2"><a href="#about" class="text-white text-decoration-none">About</a></li>
                    </ul>
                </div>
                <div class="col-md-2">
                    <h5 class="text-primary mb-4">Account</h5>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="login.php" class="text-white text-decoration-none">Login</a></li>
                        <li class="mb-2"><a href="register.php" class="text-white text-decoration-none">Register</a></li>
                        <li class="mb-2"><a href="forgot-password.php" class="text-white text-decoration-none">Forgot Password</a></li>
                    </ul>
                </div>
                <div class="col-md-4">
                    <h5 class="text-primary mb-4">Contact Us</h5>
                    <p><i class="fas fa-envelope me-2"></i> support@vinesubtech.com.ng</p>
                    <p><i class="fas fa-phone me-2"></i> +234 XXX-XXXX-XXX</p>
                    <p><i class="fas fa-map-marker-alt me-2"></i> Nigeria</p>
                </div>
            </div>
            <hr class="my-4 bg-secondary">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-0">Copyright © 2025 - ORION HUB | Powered by <a href="https://orion.vinesubtech.com.ng" target="_blank" class="text-white">VineSub Tech</a>. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <a href="#" class="text-white text-decoration-none me-3">Privacy Policy</a>
                    <a href="#" class="text-white text-decoration-none">Terms of Service</a>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="script.js"></script>
</body>
</html>