<?php
require_once 'config.php';

// Handle Flutterwave payment callback
if (isset($_GET['transaction_id']) && isset($_GET['tx_ref']) && isset($_GET['status'])) {
    $transaction_id = $_GET['transaction_id'];
    $tx_ref = $_GET['tx_ref'];
    $status = $_GET['status'];
    
    // Verify transaction with Flutterwave
    $url = "https://api.flutterwave.com/v3/transactions/" . $transaction_id . "/verify";
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: Bearer ' . FLW_SECRET_KEY
    ]);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    $result = json_decode($response, true);
    
    if ($result['status'] === 'success' && $result['data']['tx_ref'] === $tx_ref) {
        $amount = $result['data']['amount'];
        $currency = $result['data']['currency'];
        $status = $result['data']['status'];
        
        // Get transaction from database
        $stmt = $pdo->prepare("SELECT t.*, p.credits FROM transactions t 
                              JOIN credit_packages p ON t.package_id = p.id 
                              WHERE t.tx_ref = ?");
        $stmt->execute([$tx_ref]);
        $transaction = $stmt->fetch();
        
        if ($transaction) {
            $user_id = $transaction['user_id'];
            $credits = $transaction['credits'];
            
            if ($status === 'successful') {
                // Update transaction status
                $stmt = $pdo->prepare("UPDATE transactions SET status = 'completed', flutterwave_tx_id = ?, updated_at = NOW() WHERE id = ?");
                $stmt->execute([$transaction_id, $transaction['id']]);
                
                // Add credits to user
                $stmt = $pdo->prepare("UPDATE users SET note_credits = note_credits + ? WHERE id = ?");
                $stmt->execute([$credits, $user_id]);
                
                // Log action
                logAction($user_id, 'payment_success', 'Payment successful for ' . $credits . ' credits');
                
                // Set success message
                $_SESSION['success'] = 'Payment successful! ' . $credits . ' credits have been added to your account.';
            } else {
                // Update transaction status
                $stmt = $pdo->prepare("UPDATE transactions SET status = 'failed', flutterwave_tx_id = ?, updated_at = NOW() WHERE id = ?");
                $stmt->execute([$transaction_id, $transaction['id']]);
                
                // Log action
                logAction($user_id, 'payment_failed', 'Payment failed for ' . $credits . ' credits');
                
                $_SESSION['error'] = 'Payment failed. Please try again.';
            }
        }
    } else {
        $_SESSION['error'] = 'Payment verification failed.';
    }
} else {
    $_SESSION['error'] = 'Invalid payment callback.';
}

// Redirect back to dashboard
header('Location: dashboard.php');
exit();
?>