<?php
require_once 'config.php';
requireLogin();

// Check if payment data exists in session
if (!isset($_SESSION['payment_data'])) {
    $_SESSION['error'] = 'Payment data not found. Please try again.';
    header('Location: dashboard.php');
    exit();
}

$payment_data = $_SESSION['payment_data'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Processing Payment - <?php echo SITE_NAME; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="style.css">
    <script src="https://checkout.flutterwave.com/v3.js"></script>
</head>
<body class="payment-processing">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header bg-primary text-white text-center">
                        <h4 class="mb-0">Processing Payment</h4>
                    </div>
                    <div class="card-body text-center py-5">
                        <div class="spinner-border text-primary mb-4" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <h5>Redirecting to payment gateway...</h5>
                        <p class="text-muted">Please wait while we connect you to our secure payment processor.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const paymentData = <?php echo json_encode($payment_data); ?>;
            
            FlutterwaveCheckout({
                public_key: '<?php echo FLW_PUBLIC_KEY; ?>',
                tx_ref: paymentData.tx_ref,
                amount: paymentData.amount,
                currency: paymentData.currency,
                payment_options: paymentData.payment_options,
                redirect_url: paymentData.redirect_url,
                customer: paymentData.customer,
                meta: paymentData.meta,
                customizations: paymentData.customizations,
                onclose: function() {
                    // If user closes the modal, redirect back to dashboard
                    window.location.href = 'dashboard.php';
                }
            });
        });
    </script>
</body>
</html>