<?php
require_once 'config.php';
requireLogin();

$user_id = $_SESSION['user_id'];
$user = getUserData($user_id);

// Process package selection
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['package_id'])) {
    $package_id = $_POST['package_id'];
    
    // Get package details
    $stmt = $pdo->prepare("SELECT * FROM credit_packages WHERE id = ? AND is_active = 1");
    $stmt->execute([$package_id]);
    $package = $stmt->fetch();
    
    if ($package) {
        // Create transaction record
        $tx_ref = 'TX_' . time() . '_' . $user_id;
        $amount = $package['price'];
        
        $stmt = $pdo->prepare("INSERT INTO transactions (user_id, package_id, amount, tx_ref, status) VALUES (?, ?, ?, ?, 'pending')");
        $stmt->execute([$user_id, $package_id, $amount, $tx_ref]);
        $transaction_id = $pdo->lastInsertId();
        
        // Log action
        logAction($user_id, 'payment_initiated', 'Initiated payment for package: ' . $package['name']);
        
        // Prepare Flutterwave payment data
        $payment_data = [
            'tx_ref' => $tx_ref,
            'amount' => $amount,
            'currency' => 'NGN',
            'payment_options' => 'card, banktransfer, ussd',
            'redirect_url' => SITE_URL . '/payment-callback.php',
            'customer' => [
                'email' => $user['email'],
                'name' => $user['full_name']
            ],
            'meta' => [
                'user_id' => $user_id,
                'transaction_id' => $transaction_id
            ],
            'customizations' => [
                'title' => SITE_NAME,
                'description' => $package['credits'] . ' AI Note Credits',
                'logo' => SITE_URL . '/logo.png'
            ]
        ];
        
        // Store payment data in session for callback
        $_SESSION['payment_data'] = $payment_data;
        $_SESSION['current_transaction'] = $transaction_id;
        
        // Redirect to payment processing page
        header('Location: payment-process.php');
        exit();
    } else {
        $_SESSION['error'] = 'Invalid package selected.';
        header('Location: dashboard.php');
        exit();
    }
} else {
    $_SESSION['error'] = 'No package selected.';
    header('Location: dashboard.php');
    exit();
}
?>