<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_noteai');
define('DB_USER', 'fuzesale_noteai');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Vine AI Note Maker - NERDC Compliant');
define('SITE_URL', 'http://p.vinesubtech.com.ng/noteaiv7');

// Start session
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

// Database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit();
}

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT note_credits FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Check if user has credits
if ($user['note_credits'] <= 0) {
    http_response_code(403);
    echo json_encode(['error' => 'No credits remaining']);
    exit();
}

// Get POST data
$input = json_decode(file_get_contents('php://input'), true);
$topic = $input['topic'] ?? '';
$age_group = $input['age_group'] ?? '';

if (empty($topic) || empty($age_group)) {
    http_response_code(400);
    echo json_encode(['error' => 'Topic and age group are required']);
    exit();
}

// Gemini API configuration (replace with your actual API key)
$api_key = 'AIzaSyDbjf0QmBkJ1Mc0gMt0Wwp2B68nygD6zKs';
$api_url = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key=' . $api_key;

// Prepare the prompt for Gemini
$prompt = "Create a comprehensive lesson note for Nigerian students on the topic: '$topic' for students aged $age_group years. 
The lesson note should include:
1. Learning objectives
2. Key concepts
3. Teaching methods
4. Learning activities
5. Assessment methods
6. Resources needed
7. Differentiation strategies for diverse learners

Make sure the content is aligned with the Nigerian educational curriculum and appropriate for the age group.";

// Prepare the request data
$request_data = [
    'contents' => [
        [
            'parts' => [
                [
                    'text' => $prompt
                ]
            ]
        ]
    ]
];

// Initialize cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($request_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);

// Execute the request
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    http_response_code(500);
    echo json_encode(['error' => 'AI service unavailable']);
    exit();
}

// Parse the response
$response_data = json_decode($response, true);
$content = $response_data['candidates'][0]['content']['parts'][0]['text'] ?? '';

if (empty($content)) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to generate content']);
    exit();
}

// Return the generated content
echo json_encode(['content' => $content]);
?>