<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_noteai');
define('DB_USER', 'fuzesale_noteai');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Vine AI Note Maker - NERDC Compliant');
define('SITE_URL', 'http://p.vinesubtech.com.ng/noteaiv7');

// Start session
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT username, full_name, school, note_credits FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Handle different actions
$action = $_GET['action'] ?? 'list';
$note_id = $_GET['id'] ?? 0;

// Initialize variables
$note = null;
$error = '';
$success = '';

// Get note data if viewing/editing
if ($action === 'view' || $action === 'edit' || $action === 'delete') {
    $stmt = $pdo->prepare("SELECT * FROM notes WHERE id = ? AND user_id = ?");
    $stmt->execute([$note_id, $user_id]);
    $note = $stmt->fetch();
    
    if (!$note) {
        $error = 'Note not found';
        $action = 'list';
    }
}

// Handle delete action
if ($action === 'delete' && $note) {
    $stmt = $pdo->prepare("DELETE FROM notes WHERE id = ? AND user_id = ?");
    if ($stmt->execute([$note_id, $user_id])) {
        $success = 'Note deleted successfully';
        $action = 'list';
    } else {
        $error = 'Failed to delete note';
    }
}

// Handle form submission for create/edit
if ($_SERVER['REQUEST_METHOD'] == 'POST' && ($action === 'create' || $action === 'edit')) {
    $topic = $_POST['topic'];
    $age_group = $_POST['age_group'];
    $content = $_POST['content'];
    
    if (empty($topic) || empty($age_group)) {
        $error = 'Please fill in all required fields';
    } else {
        if ($action === 'create') {
            // Check if user has credits
            if ($user['note_credits'] <= 0) {
                $error = 'You have no credits remaining. Please contact admin to buy more.';
            } else {
                // Insert new note
                $stmt = $pdo->prepare("INSERT INTO notes (user_id, topic, age_group, content) VALUES (?, ?, ?, ?)");
                if ($stmt->execute([$user_id, $topic, $age_group, $content])) {
                    // Decrement user credits
                    $stmt = $pdo->prepare("UPDATE users SET note_credits = note_credits - 1 WHERE id = ?");
                    $stmt->execute([$user_id]);
                    
                    // Update session
                    $_SESSION['note_credits'] = $user['note_credits'] - 1;
                    
                    $success = 'Note created successfully';
                    $action = 'list';
                } else {
                    $error = 'Failed to create note';
                }
            }
        } else if ($action === 'edit' && $note) {
            // Update existing note
            $stmt = $pdo->prepare("UPDATE notes SET topic = ?, age_group = ?, content = ? WHERE id = ? AND user_id = ?");
            if ($stmt->execute([$topic, $age_group, $content, $note_id, $user_id])) {
                $success = 'Note updated successfully';
                $action = 'list';
            } else {
                $error = 'Failed to update note';
            }
        }
    }
}

// Get all notes for listing
if ($action === 'list') {
    $stmt = $pdo->prepare("SELECT * FROM notes WHERE user_id = ? ORDER BY created_at DESC");
    $stmt->execute([$user_id]);
    $notes = $stmt->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo ucfirst($action); ?> Note - <?php echo SITE_NAME; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <nav class="navbar">
            <div class="nav-container">
                <div class="nav-logo">
                    <i class="fas fa-book-open"></i>
                    <span><?php echo SITE_NAME; ?></span>
                </div>
                <div class="nav-menu">
                    <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
                    <a href="notes.php" class="nav-link active"><i class="fas fa-sticky-note"></i> Notes</a>
                    <a href="profile.php" class="nav-link"><i class="fas fa-user"></i> Profile</a>
                    <a href="logout.php" class="nav-link btn-logout"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
                <div class="hamburger">
                    <span class="bar"></span>
                    <span class="bar"></span>
                    <span class="bar"></span>
                </div>
            </div>
        </nav>
    </header>

    <main class="notes-main">
        <div class="notes-container">
            <?php if ($action === 'list'): ?>
            <div class="notes-header">
                <h1>Your Lesson Notes</h1>
                <a href="notes.php?action=create" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create New Note
                </a>
            </div>
            
            <?php if ($success): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
            <?php endif; ?>
            
            <div class="notes-list">
                <?php if (count($notes) > 0): ?>
                <?php foreach ($notes as $note): ?>
                <div class="note-card">
                    <h3><?php echo htmlspecialchars($note['topic']); ?></h3>
                    <p class="note-meta">Age Group: <?php echo $note['age_group']; ?> years | Created: <?php echo date('M j, Y', strtotime($note['created_at'])); ?></p>
                    <div class="note-content-preview">
                        <?php echo strlen($note['content']) > 150 ? substr($note['content'], 0, 150) . '...' : $note['content']; ?>
                    </div>
                    <div class="note-actions">
                        <a href="notes.php?action=view&id=<?php echo $note['id']; ?>" class="btn btn-sm btn-primary">View</a>
                        <a href="notes.php?action=edit&id=<?php echo $note['id']; ?>" class="btn btn-sm btn-secondary">Edit</a>
                        <a href="notes.php?action=delete&id=<?php echo $note['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this note?')">Delete</a>
                    </div>
                </div>
                <?php endforeach; ?>
                <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-sticky-note"></i>
                    <h3>No notes yet</h3>
                    <p>You haven't created any lesson notes yet.</p>
                    <a href="notes.php?action=create" class="btn btn-primary">Create Your First Note</a>
                </div>
                <?php endif; ?>
            </div>
            
            <?php elseif ($action === 'view' && $note): ?>
            <div class="note-view-header">
                <h1><?php echo htmlspecialchars($note['topic']); ?></h1>
                <div class="note-view-actions">
                    <a href="notes.php?action=edit&id=<?php echo $note['id']; ?>" class="btn btn-secondary">Edit</a>
                    <a href="notes.php" class="btn btn-primary">Back to List</a>
                </div>
            </div>
            
            <div class="note-view-meta">
                <p><strong>Age Group:</strong> <?php echo $note['age_group']; ?> years</p>
                <p><strong>Created:</strong> <?php echo date('M j, Y, g:i a', strtotime($note['created_at'])); ?></p>
                <p><strong>Last Updated:</strong> <?php echo date('M j, Y, g:i a', strtotime($note['updated_at'])); ?></p>
            </div>
            
            <div class="note-view-content">
                <?php echo nl2br(htmlspecialchars($note['content'])); ?>
            </div>
            
            <?php elseif (($action === 'create' || $action === 'edit') && ($action !== 'edit' || $note)): ?>
            <div class="note-form-header">
                <h1><?php echo $action === 'create' ? 'Create New Note' : 'Edit Note'; ?></h1>
                <a href="notes.php" class="btn btn-primary">Back to List</a>
            </div>
            
            <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
            <?php endif; ?>
            
            <?php if ($action === 'create'): ?>
            <div class="credits-info">
                <p>You have <strong><?php echo $user['note_credits']; ?></strong> note credits remaining.</p>
                <?php if ($user['note_credits'] <= 0): ?>
                <div class="alert alert-warning">
                    <i class="fas fa-exclamation-triangle"></i> You have no credits remaining. <a href="#buy-credits">Contact admin to buy more</a>.
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <form method="POST" action="" class="note-form">
                <div class="form-group">
                    <label for="topic">Topic *</label>
                    <input type="text" id="topic" name="topic" value="<?php echo $note['topic'] ?? ''; ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="age_group">Age Group (Years) *</label>
                    <input type="number" id="age_group" name="age_group" min="5" max="18" value="<?php echo $note['age_group'] ?? ''; ?>" required>
                </div>
                
                <div class="form-group">
                    <label for="content">Lesson Note Content *</label>
                    <textarea id="content" name="content" rows="10" required><?php echo $note['content'] ?? ''; ?></textarea>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary" <?php echo ($action === 'create' && $user['note_credits'] <= 0) ? 'disabled' : ''; ?>>
                        <?php echo $action === 'create' ? 'Create Note' : 'Update Note'; ?>
                    </button>
                    <a href="notes.php" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
            
            <?php if ($action === 'create'): ?>
            <div class="ai-assist">
                <h3>AI Note Generation</h3>
                <p>Let our AI help you create a lesson note based on your topic and age group.</p>
                <div class="ai-form">
                    <input type="text" id="ai-topic" placeholder="Enter topic for AI generation">
                    <button type="button" id="generate-ai" class="btn btn-secondary">Generate with AI</button>
                </div>
                <div id="ai-result" class="ai-result"></div>
            </div>
            <?php endif; ?>
            
            <?php endif; ?>
        </div>
    </main>

    <footer>
        <div class="footer-content">
            <div class="footer-section">
                <h3><?php echo SITE_NAME; ?></h3>
                <p>Empowering educators with AI-powered lesson planning tools.</p>
            </div>
            <div class="footer-section">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="notes.php">Notes</a></li>
                    <li><a href="profile.php">Profile</a></li>
                </ul>
            </div>
            <div class="footer-section">
                <h3>Contact</h3>
                <p><i class="fas fa-envelope"></i> support@vinesubtech.com.ng</p>
            </div>
        </div>
        <div class="footer-bottom">
            <p>Copyright © 2025 - ORION HUB | Powered by <a href="https://orion.vinesubtech.com.ng" target="_blank">VineSub Tech</a>. All rights reserved.</p>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>