<?php
// Database configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'fuzesale_noteai');
define('DB_USER', 'fuzesale_noteai');
define('DB_PASS', '!!!###1985ENi!!!');

// Site configuration
define('SITE_NAME', 'Vine AI Note Maker - NERDC Compliant');
define('SITE_URL', 'http://p.vinesubtech.com.ng/noteaiv7');

// Start session
session_start();

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

// Database connection
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Get user data
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT username, email, full_name, school, note_credits FROM users WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

// Process profile update
$error = '';
$success = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $full_name = $_POST['full_name'];
    $school = $_POST['school'];
    
    if (empty($email) || empty($full_name)) {
        $error = 'Please fill in all required fields';
    } else {
        // Update user profile
        $stmt = $pdo->prepare("UPDATE users SET email = ?, full_name = ?, school = ? WHERE id = ?");
        if ($stmt->execute([$email, $full_name, $school, $user_id])) {
            $success = 'Profile updated successfully';
            // Refresh user data
            $stmt = $pdo->prepare("SELECT username, email, full_name, school, note_credits FROM users WHERE id = ?");
            $stmt->execute([$user_id]);
            $user = $stmt->fetch();
        } else {
            $error = 'Failed to update profile';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile - <?php echo SITE_NAME; ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <nav class="navbar">
            <div class="nav-container">
                <div class="nav-logo">
                    <i class="fas fa-book-open"></i>
                    <span><?php echo SITE_NAME; ?></span>
                </div>
                <div class="nav-menu">
                    <a href="dashboard.php" class="nav-link"><i class="fas fa-home"></i> Dashboard</a>
                    <a href="notes.php" class="nav-link"><i class="fas fa-sticky-note"></i> Notes</a>
                    <a href="profile.php" class="nav-link active"><i class="fas fa-user"></i> Profile</a>
                    <a href="logout.php" class="nav-link btn-logout"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
                <div class="hamburger">
                    <span class="bar"></span>
                    <span class="bar"></span>
                    <span class="bar"></span>
                </div>
            </div>
        </nav>
    </header>

    <main class="profile-main">
        <div class="profile-container">
            <div class="profile-header">
                <h1>Your Profile</h1>
                <a href="dashboard.php" class="btn btn-primary">Back to Dashboard</a>
            </div>
            
            <?php if ($success): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
            <?php endif; ?>
            
            <div class="profile-info">
                <div class="info-card">
                    <h3>Account Information</h3>
                    <form method="POST" action="" class="profile-form">
                        <div class="form-group">
                            <label for="username">Username</label>
                            <input type="text" id="username" value="<?php echo htmlspecialchars($user['username']); ?>" disabled>
                            <p class="form-help">Username cannot be changed</p>
                        </div>
                        
                        <div class="form-group">
                            <label for="email">Email *</label>
                            <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="full_name">Full Name *</label>
                            <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($user['full_name']); ?>" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="school">School</label>
                            <input type="text" id="school" name="school" value="<?php echo htmlspecialchars($user['school']); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label>Note Credits</label>
                            <input type="text" value="<?php echo $user['note_credits']; ?>" disabled>
                            <p class="form-help">Contact admin to purchase more credits</p>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Update Profile</button>
                    </form>
                </div>
                
                <div class="account-actions">
                    <h3>Account Actions</h3>
                    <div class="action-buttons">
                        <a href="dashboard.php" class="btn btn-secondary">Back to Dashboard</a>
                        <a href="notes.php" class="btn btn-primary">View Notes</a>
                        <a href="logout.php" class="btn btn-danger">Logout</a>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer>
        <div class="footer-content">
            <div class="footer-section">
                <h3><?php echo SITE_NAME; ?></h3>
                <p>Empowering educators with AI-powered lesson planning tools.</p>
            </div>
            <div class="footer-section">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="notes.php">Notes</a></li>
                    <li><a href="profile.php">Profile</a></li>
                </ul>
            </div>
            <div class="footer-section">
                <h3>Contact</h3>
                <p><i class="fas fa-envelope"></i> support@vinesubtech.com.ng</p>
            </div>
        </div>
        <div class="footer-bottom">
            <p>Copyright © 2025 - ORION HUB | Powered by <a href="https://orion.vinesubtech.com.ng" target="_blank">VineSub Tech</a>. All rights reserved.</p>
        </div>
    </footer>

    <script src="script.js"></script>
</body>
</html>