// Mobile navigation toggle
document.addEventListener('DOMContentLoaded', function() {
    const hamburger = document.querySelector('.hamburger');
    const navMenu = document.querySelector('.nav-menu');
    
    if (hamburger) {
        hamburger.addEventListener('click', function() {
            hamburger.classList.toggle('active');
            navMenu.classList.toggle('active');
        });
    }
    
    // Close mobile menu when clicking on a link
    document.querySelectorAll('.nav-link').forEach(link => {
        link.addEventListener('click', function() {
            hamburger.classList.remove('active');
            navMenu.classList.remove('active');
        });
    });
    
    // AI Note Generation
    const generateBtn = document.getElementById('generate-ai');
    if (generateBtn) {
        generateBtn.addEventListener('click', generateAINote);
    }
});

// AI Note Generation Function
function generateAINote() {
    const topicInput = document.getElementById('ai-topic');
    const ageGroupInput = document.getElementById('age_group');
    const resultDiv = document.getElementById('ai-result');
    
    const topic = topicInput.value.trim();
    const ageGroup = ageGroupInput.value;
    
    if (!topic) {
        resultDiv.innerHTML = '<div class="alert alert-error">Please enter a topic for AI generation</div>';
        return;
    }
    
    if (!ageGroup) {
        resultDiv.innerHTML = '<div class="alert alert-error">Please set the age group first</div>';
        return;
    }
    
    resultDiv.innerHTML = '<div class="alert">Generating note... <i class="fas fa-spinner fa-spin"></i></div>';
    
    // Make AJAX request to API
    fetch('api.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            topic: topic,
            age_group: ageGroup
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.error) {
            resultDiv.innerHTML = `<div class="alert alert-error">${data.error}</div>`;
        } else if (data.content) {
            resultDiv.innerHTML = `<div class="alert alert-success">AI-generated content:</div><div>${data.content}</div>`;
            
            // Auto-fill the content textarea
            const contentTextarea = document.getElementById('content');
            if (contentTextarea) {
                contentTextarea.value = data.content;
            }
        }
    })
    .catch(error => {
        resultDiv.innerHTML = `<div class="alert alert-error">Error: ${error.message}</div>`;
    });
}

// Form validation
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let valid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    valid = false;
                    field.style.borderColor = '#e74c3c';
                } else {
                    field.style.borderColor = '';
                }
            });
            
            if (!valid) {
                e.preventDefault();
                alert('Please fill in all required fields');
            }
        });
    });
});

// Dynamic credit check for note creation
document.addEventListener('DOMContentLoaded', function() {
    const createNoteBtn = document.querySelector('.note-form .btn-primary');
    if (createNoteBtn && createNoteBtn.disabled) {
        createNoteBtn.title = 'You have no credits remaining. Please contact admin.';
    }
});

// Responsive table handling
function makeTablesResponsive() {
    const tables = document.querySelectorAll('table');
    tables.forEach(table => {
        const wrapper = document.createElement('div');
        wrapper.className = 'table-responsive';
        table.parentNode.insertBefore(wrapper, table);
        wrapper.appendChild(table);
    });
}

// Initialize when document is ready
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', makeTablesResponsive);
} else {
    makeTablesResponsive();
}