<?php
require_once '../auth.php';

if (!$auth->isLoggedIn()) {
    echo json_encode(['error' => 'Not authenticated']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $agent_id = $_POST['agent_id'];
    
    $stmt = $pdo->prepare("SELECT * FROM ai_agents WHERE id = ? AND user_id = ?");
    $stmt->execute([$agent_id, $user_id]);
    $agent = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($agent) {
        echo json_encode(['agent' => $agent]);
    } else {
        echo json_encode(['error' => 'Agent not found']);
    }
}
?>